/*
 * Decompiled with CFR 0.152.
 */
package VRP;

import AbstractClasses.ProblemDomain;
import VRP.Instance;
import VRP.Location;
import VRP.Route;
import VRP.RouteItem;
import VRP.Solution;
import java.util.ArrayList;

public class VRP
extends ProblemDomain {
    private Instance instance;
    private Solution[] solutions;
    double bestSolutionValue = Double.POSITIVE_INFINITY;
    Solution bestSolution = new Solution();
    private final int[] mutations;
    private final int[] ruinRecreates;
    private final int[] localSearches;
    private final int[] crossovers;

    public VRP(long seed) {
        super(seed);
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 7;
        this.mutations = nArray;
        this.ruinRecreates = new int[]{2, 3};
        this.localSearches = new int[]{4, 8, 9};
        this.crossovers = new int[]{5, 6};
    }

    @Override
    public int[] getHeuristicsOfType(ProblemDomain.HeuristicType heuristicType) {
        switch (heuristicType) {
            case LOCAL_SEARCH: {
                return this.localSearches;
            }
            case RUIN_RECREATE: {
                return this.ruinRecreates;
            }
            case MUTATION: {
                return this.mutations;
            }
            case CROSSOVER: {
                return this.crossovers;
            }
        }
        return null;
    }

    @Override
    public int[] getHeuristicsThatUseIntensityOfMutation() {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        return nArray;
    }

    @Override
    public int[] getHeuristicsThatUseDepthOfSearch() {
        return new int[]{4, 8, 9};
    }

    @Override
    public void loadInstance(int instanceID) {
        this.instance = new Instance(instanceID);
    }

    @Override
    public void setMemorySize(int size) {
        Solution[] newSolutionMemory = new Solution[size];
        if (this.solutions != null) {
            int x = 0;
            while (x < this.solutions.length) {
                if (x < size) {
                    newSolutionMemory[x] = this.solutions[x];
                }
                ++x;
            }
        }
        this.solutions = newSolutionMemory;
    }

    @Override
    public void initialiseSolution(int index) {
        this.solutions[index] = this.constructiveHeuristic(this.instance);
        this.getFunctionValue(index);
    }

    @Override
    public int getNumberOfHeuristics() {
        return 10;
    }

    @Override
    public double applyHeuristic(int heuristicID, int solutionSourceIndex, int solutionDestinationIndex) {
        long startTime = System.currentTimeMillis();
        boolean isCrossover = false;
        int[] crossovers = this.getHeuristicsOfType(ProblemDomain.HeuristicType.CROSSOVER);
        int x = 0;
        while (x < crossovers.length) {
            if (crossovers[x] == heuristicID) {
                isCrossover = true;
                break;
            }
            ++x;
        }
        if (isCrossover) {
            this.solutions[solutionDestinationIndex] = this.solutions[solutionSourceIndex].copySolution();
            return this.getFunctionValue(solutionDestinationIndex);
        }
        double score = 0.0;
        if (heuristicID == 0) {
            score = this.twoOpt(solutionSourceIndex, solutionDestinationIndex);
        } else if (heuristicID == 1) {
            score = this.orOpt(solutionSourceIndex, solutionDestinationIndex);
        } else if (heuristicID == 2) {
            score = this.locRR(solutionSourceIndex, solutionDestinationIndex);
        } else if (heuristicID == 3) {
            score = this.timeRR(solutionSourceIndex, solutionDestinationIndex);
        } else if (heuristicID == 4) {
            score = this.shift(solutionSourceIndex, solutionDestinationIndex);
        } else if (heuristicID == 7) {
            score = this.shiftMutate(solutionSourceIndex, solutionDestinationIndex);
        } else if (heuristicID == 8) {
            score = this.twoOptStar(solutionSourceIndex, solutionDestinationIndex);
        } else if (heuristicID == 9) {
            score = this.GENI(solutionSourceIndex, solutionDestinationIndex);
        } else {
            System.err.println("Heuristic " + heuristicID + " does not exist");
            return 0.0;
        }
        int n = heuristicID;
        this.heuristicCallRecord[n] = this.heuristicCallRecord[n] + 1;
        int n2 = heuristicID;
        this.heuristicCallTimeRecord[n2] = this.heuristicCallTimeRecord[n2] + (int)(System.currentTimeMillis() - startTime);
        return score;
    }

    @Override
    public double applyHeuristic(int heuristicID, int solutionSourceIndex1, int solutionSourceIndex2, int solutionDestinationIndex) {
        long startTime = System.currentTimeMillis();
        boolean isCrossover = false;
        int[] crossovers = this.getHeuristicsOfType(ProblemDomain.HeuristicType.CROSSOVER);
        int x = 0;
        while (x < crossovers.length) {
            if (crossovers[x] == heuristicID) {
                isCrossover = true;
                break;
            }
            ++x;
        }
        if (isCrossover) {
            double score = 0.0;
            if (heuristicID == 5) {
                score = this.combine(solutionSourceIndex1, solutionSourceIndex2, solutionDestinationIndex);
            } else if (heuristicID == 6) {
                score = this.combineLong(solutionSourceIndex1, solutionSourceIndex2, solutionDestinationIndex);
            } else {
                System.err.println("Heuristic " + heuristicID + " does not exist");
                return 0.0;
            }
            int n = heuristicID;
            this.heuristicCallRecord[n] = this.heuristicCallRecord[n] + 1;
            int n2 = heuristicID;
            this.heuristicCallTimeRecord[n2] = this.heuristicCallTimeRecord[n2] + (int)(System.currentTimeMillis() - startTime);
            return score;
        }
        double score = 0.0;
        if (heuristicID == 0) {
            score = this.twoOpt(solutionSourceIndex1, solutionDestinationIndex);
        } else if (heuristicID == 1) {
            score = this.orOpt(solutionSourceIndex1, solutionDestinationIndex);
        } else if (heuristicID == 2) {
            score = this.locRR(solutionSourceIndex1, solutionDestinationIndex);
        } else if (heuristicID == 3) {
            score = this.timeRR(solutionSourceIndex1, solutionDestinationIndex);
        } else if (heuristicID == 4) {
            score = this.shift(solutionSourceIndex1, solutionDestinationIndex);
        } else if (heuristicID == 7) {
            score = this.shiftMutate(solutionSourceIndex1, solutionDestinationIndex);
        } else if (heuristicID == 8) {
            score = this.twoOptStar(solutionSourceIndex1, solutionDestinationIndex);
        } else if (heuristicID == 9) {
            score = this.GENI(solutionSourceIndex1, solutionDestinationIndex);
        } else {
            System.err.println("Heuristic " + heuristicID + " does not exist");
            return 0.0;
        }
        int n = heuristicID;
        this.heuristicCallRecord[n] = this.heuristicCallRecord[n] + 1;
        int n3 = heuristicID;
        this.heuristicCallTimeRecord[n3] = this.heuristicCallTimeRecord[n3] + (int)(System.currentTimeMillis() - startTime);
        return score;
    }

    Solution constructiveHeuristic(Instance i) {
        ArrayList<Location> locations = new ArrayList<Location>();
        ArrayList<Location> tempLocs = i.getDemands();
        int j = 0;
        while (j < tempLocs.size()) {
            locations.add(tempLocs.get(j).copyLocation());
            ++j;
        }
        ArrayList<Route> routes = new ArrayList<Route>();
        Location depot = (Location)locations.get(0);
        locations.remove(0);
        int numRoutes = 1;
        Route route = new Route(depot, numRoutes - 1, 0);
        routes.add(route);
        block1: while (!locations.isEmpty()) {
            int bestIndex = -1;
            double bestScore = 1000000.0;
            double bestTimeMinusReady = 0.0;
            int j2 = 0;
            while (j2 < locations.size()) {
                double diff1;
                if (routes.get(numRoutes - 1).getVolume() + ((Location)locations.get(j2)).getDemand() < i.getVehicleCapacity() && (diff1 = (double)routes.get(numRoutes - 1).getLast().getCurrLocation().getDueDate() - ((double)(((Location)locations.get(j2)).getReadyTime() + ((Location)locations.get(j2)).getServiceTime()) + this.calcDistance((Location)locations.get(j2), routes.get(numRoutes - 1).getLast().getCurrLocation()))) > 0.0) {
                    double score;
                    int readyDueDiff;
                    double lastTime;
                    RouteItem lastStop = routes.get(numRoutes - 1).getLast().getPrev();
                    Location prevLocation = lastStop.getCurrLocation();
                    double dist = this.calcDistance(prevLocation, (Location)locations.get(j2));
                    int due = ((Location)locations.get(j2)).getDueDate();
                    double timeDiff = (double)due - ((lastTime = lastStop.getTimeArrived()) + (double)prevLocation.getServiceTime() + dist);
                    if (timeDiff >= 0.0 && diff1 >= (double)(readyDueDiff = due - ((Location)locations.get(j2)).getReadyTime()) - timeDiff && (score = (dist + ((double)due - lastTime)) * (double)this.rng.nextFloat()) < bestScore) {
                        bestIndex = j2;
                        bestScore = score;
                        bestTimeMinusReady = timeDiff - (double)readyDueDiff;
                    }
                }
                if (j2 == locations.size() - 1) {
                    if (bestIndex >= 0) {
                        RouteItem lastStop = routes.get(numRoutes - 1).getLast().getPrev();
                        Location prevLocation = lastStop.getCurrLocation();
                        if (bestTimeMinusReady > 0.0) {
                            lastStop.setWaitingTime(bestTimeMinusReady);
                        } else {
                            lastStop.setWaitingTime(0.0);
                        }
                        routes.get(numRoutes - 1).addPenultimate((Location)locations.get(bestIndex), lastStop.getTimeArrived() + (double)prevLocation.getServiceTime() + lastStop.getWaitingTime() + this.calcDistance(prevLocation, (Location)locations.get(bestIndex)));
                        locations.remove(bestIndex);
                        continue block1;
                    }
                    Route route2 = new Route(depot, ++numRoutes - 1, 0);
                    routes.add(route2);
                }
                ++j2;
            }
        }
        Solution solution = new Solution(routes);
        return solution;
    }

    public int countLocs(ArrayList<Route> rs) {
        int numLocs = 0;
        for (Route r : rs) {
            RouteItem ri = r.getFirst();
            while ((ri = ri.getNext()).getNext() != null) {
                ++numLocs;
            }
        }
        return numLocs;
    }

    public double twoOpt(int solutionSourceIndex, int solutionDestinationIndex) {
        Solution copyS = this.solutions[solutionSourceIndex].copySolution();
        ArrayList<Route> rs = copyS.getRoutes();
        int numRoutesToBeMutated = (int)(this.intensityOfMutation * (double)rs.size());
        int[] routesToBeMutated = new int[numRoutesToBeMutated];
        int j = 0;
        while (j < numRoutesToBeMutated) {
            routesToBeMutated[j] = -1;
            ++j;
        }
        int i = 0;
        while (i < numRoutesToBeMutated) {
            int ref = this.rng.nextInt(rs.size());
            while (this.appears(routesToBeMutated, ref)) {
                ref = this.rng.nextInt(rs.size());
            }
            routesToBeMutated[i] = ref;
            ++i;
        }
        i = 0;
        while (i < numRoutesToBeMutated) {
            Route routeToMutate = rs.get(routesToBeMutated[i]);
            if (routeToMutate.sizeOfRoute() >= 4) {
                int startRI = routeToMutate.sizeOfRoute() == 4 ? 0 : this.rng.nextInt(routeToMutate.sizeOfRoute() - 4);
                Route r2 = routeToMutate.copyRoute();
                RouteItem ri = r2.getFirst();
                int j2 = 0;
                while (j2 < startRI) {
                    ri = ri.getNext();
                    ++j2;
                }
                RouteItem tRI = ri.getNext();
                ri.setNext(ri.getNext().getNext());
                ri.getNext().setPrev(ri);
                tRI.setNext(ri.getNext().getNext());
                tRI.setPrev(ri.getNext());
                ri.getNext().setNext(tRI);
                tRI.getNext().setPrev(tRI);
                boolean feasible = true;
                while ((ri = ri.getNext()).getNext() != null) {
                    RouteItem prev = ri.getPrev();
                    double diff = (double)ri.getCurrLocation().getDueDate() - (prev.getTimeArrived() + (double)prev.getCurrLocation().getServiceTime() + this.calcDistance(ri.getCurrLocation(), prev.getCurrLocation()));
                    if (diff >= 0.0) {
                        int readyDueDiff = ri.getCurrLocation().getDueDate() - ri.getCurrLocation().getReadyTime();
                        if (diff > (double)readyDueDiff) {
                            prev.setWaitingTime(diff - (double)readyDueDiff);
                        } else {
                            prev.setWaitingTime(0.0);
                        }
                        ri.setTimeArrived(prev.getTimeArrived() + (double)prev.getCurrLocation().getServiceTime() + prev.getWaitingTime() + this.calcDistance(ri.getCurrLocation(), prev.getCurrLocation()));
                        continue;
                    }
                    feasible = false;
                    break;
                }
                RouteItem rL = r2.getLast();
                double depotDiff = (double)rL.getCurrLocation().getDueDate() - (rL.getPrev().getTimeArrived() + (double)rL.getPrev().getCurrLocation().getServiceTime() + this.calcDistance(rL.getCurrLocation(), rL.getPrev().getCurrLocation()));
                if (depotDiff < 0.0) {
                    feasible = false;
                }
                if (feasible) {
                    routeToMutate = r2;
                    rs.set(routesToBeMutated[i], r2);
                }
            }
            ++i;
        }
        this.solutions[solutionDestinationIndex] = copyS;
        double func = this.getFunctionValue(solutionDestinationIndex);
        return func;
    }

    public double orOpt(int solutionSourceIndex, int solutionDestinationIndex) {
        Solution copyS = this.solutions[solutionSourceIndex].copySolution();
        ArrayList<Route> rs = copyS.getRoutes();
        int numRoutesToBeMutated = (int)(this.intensityOfMutation * (double)rs.size());
        int[] routesToBeMutated = new int[numRoutesToBeMutated];
        int j = 0;
        while (j < numRoutesToBeMutated) {
            routesToBeMutated[j] = -1;
            ++j;
        }
        int i = 0;
        while (i < numRoutesToBeMutated) {
            int ref = this.rng.nextInt(rs.size());
            while (this.appears(routesToBeMutated, ref)) {
                ref = this.rng.nextInt(rs.size());
            }
            routesToBeMutated[i] = ref;
            ++i;
        }
        i = 0;
        while (i < numRoutesToBeMutated) {
            Route routeToMutate = rs.get(routesToBeMutated[i]);
            if (routeToMutate.sizeOfRoute() >= 6) {
                int startRI = routeToMutate.sizeOfRoute() == 6 ? 0 : this.rng.nextInt(routeToMutate.sizeOfRoute() - 6);
                Route r2 = routeToMutate.copyRoute();
                RouteItem ri = r2.getFirst();
                int j2 = 0;
                while (j2 < startRI) {
                    ri = ri.getNext();
                    ++j2;
                }
                RouteItem tRI = ri.getNext();
                RouteItem tRI2 = ri;
                ri.setNext(ri.getNext().getNext().getNext());
                ri.getNext().setPrev(ri);
                ri = ri.getNext().getNext();
                ri.getNext().setPrev(tRI.getNext());
                tRI.getNext().setNext(ri.getNext());
                tRI.setPrev(ri);
                ri.setNext(tRI);
                ri = tRI2;
                boolean feasible = true;
                while ((ri = ri.getNext()).getNext() != null) {
                    RouteItem prev = ri.getPrev();
                    double diff = (double)ri.getCurrLocation().getDueDate() - (prev.getTimeArrived() + (double)prev.getCurrLocation().getServiceTime() + this.calcDistance(ri.getCurrLocation(), prev.getCurrLocation()));
                    if (diff >= 0.0) {
                        int readyDueDiff = ri.getCurrLocation().getDueDate() - ri.getCurrLocation().getReadyTime();
                        if (diff > (double)readyDueDiff) {
                            prev.setWaitingTime(diff - (double)readyDueDiff);
                        } else {
                            prev.setWaitingTime(0.0);
                        }
                        ri.setTimeArrived(prev.getTimeArrived() + (double)prev.getCurrLocation().getServiceTime() + prev.getWaitingTime() + this.calcDistance(ri.getCurrLocation(), prev.getCurrLocation()));
                        continue;
                    }
                    feasible = false;
                    break;
                }
                RouteItem rL = r2.getLast();
                double depotDiff = (double)rL.getCurrLocation().getDueDate() - (rL.getPrev().getTimeArrived() + (double)rL.getPrev().getCurrLocation().getServiceTime() + this.calcDistance(rL.getCurrLocation(), rL.getPrev().getCurrLocation()));
                if (depotDiff < 0.0) {
                    feasible = false;
                }
                if (feasible) {
                    routeToMutate = r2;
                    rs.set(routesToBeMutated[i], r2);
                }
            }
            ++i;
        }
        this.solutions[solutionDestinationIndex] = copyS;
        double func = this.getFunctionValue(solutionDestinationIndex);
        return func;
    }

    /*
     * Unable to fully structure code
     */
    public double shiftMutate(int solutionSourceIndex, int solutionDestinationIndex) {
        copyS = this.solutions[solutionSourceIndex].copySolution();
        copyS2 = this.solutions[solutionSourceIndex].copySolution();
        rs = copyS.getRoutes();
        numRoutesToUse = (int)(this.intensityOfMutation * (double)rs.size());
        if (numRoutesToUse < 1) {
            numRoutesToUse = 1;
        }
        routesToUse = new int[numRoutesToUse];
        i = 0;
        while (i < numRoutesToUse) {
            routesToUse[i] = -1;
            ++i;
        }
        i = 0;
        while (i < numRoutesToUse) {
            r = this.rng.nextInt(numRoutesToUse);
            while (this.appears(routesToUse, r)) {
                r = this.rng.nextInt(numRoutesToUse);
            }
            routesToUse[i] = rs.get(r).getId();
            ++i;
        }
        i = 0;
        while (i < numRoutesToUse) {
            block12: {
                block13: {
                    routes = copyS2.getRoutes();
                    there = false;
                    r = routes.get(0);
                    m = 0;
                    while (m < routes.size()) {
                        if (routes.get(m).getId() == routesToUse[i]) {
                            r = routes.get(m);
                            there = true;
                        }
                        ++m;
                    }
                    if (!there) break block12;
                    bestPos = 1;
                    greatestDistance = 0.0;
                    pos = 0;
                    ri = r.getFirst();
                    while ((ri = ri.getNext()).getNext() != null) {
                        ++pos;
                        dist = (this.calcDistance(ri.getPrev().getCurrLocation(), ri.getCurrLocation()) + this.calcDistance(ri.getNext().getCurrLocation(), ri.getCurrLocation())) * (double)this.rng.nextFloat();
                        if (!(dist > greatestDistance)) continue;
                        greatestDistance = dist;
                        bestPos = pos;
                    }
                    ri = r.getFirst();
                    j = 0;
                    while (j < bestPos) {
                        ri = ri.getNext();
                        ++j;
                    }
                    locToInsert = ri.getCurrLocation();
                    ri.getPrev().setNext(ri.getNext());
                    ri.getNext().setPrev(ri.getPrev());
                    ri = ri.getPrev();
                    if (r.sizeOfRoute() > 2) ** GOTO lbl67
                    routes.remove(r);
                    break block13;
lbl-1000:
                    // 1 sources

                    {
                        prev = ri.getPrev();
                        diff = (double)ri.getCurrLocation().getDueDate() - (prev.getTimeArrived() + (double)prev.getCurrLocation().getServiceTime() + this.calcDistance(ri.getCurrLocation(), prev.getCurrLocation()));
                        if (diff > (double)(readyDueDiff = ri.getCurrLocation().getDueDate() - ri.getCurrLocation().getReadyTime())) {
                            prev.setWaitingTime(diff - (double)readyDueDiff);
                        } else {
                            prev.setWaitingTime(0.0);
                        }
                        ri.setTimeArrived(prev.getTimeArrived() + (double)prev.getCurrLocation().getServiceTime() + prev.getWaitingTime() + this.calcDistance(ri.getCurrLocation(), prev.getCurrLocation()));
lbl67:
                        // 2 sources

                        ** while ((ri = ri.getNext()).getNext() != null)
                    }
                }
                routes = this.insertLocIntoRoute(routes, locToInsert);
                copyS.setRoutes(routes);
                copyS2.setRoutes(routes);
                copyS = copyS.copySolution();
            }
            ++i;
        }
        copyS.setRoutes(this.deleteUnwantedRoutes(copyS.getRoutes()));
        this.solutions[solutionDestinationIndex] = copyS;
        func = this.getFunctionValue(solutionDestinationIndex);
        return func;
    }

    public double interchangeMutate(int solutionSourceIndex, int solutionDestinationIndex) {
        RouteItem newRI;
        Solution copyS = this.solutions[solutionSourceIndex].copySolution();
        Solution copyS2 = this.solutions[solutionSourceIndex].copySolution();
        ArrayList<Route> rs = copyS.getRoutes();
        Route r1 = rs.get(this.rng.nextInt(rs.size()));
        while (r1.sizeOfRoute() <= 2) {
            r1 = rs.get(this.rng.nextInt(rs.size()));
        }
        Route r2 = rs.get(this.rng.nextInt(rs.size()));
        while (r1 == r2 || r2.sizeOfRoute() <= 2) {
            r2 = rs.get(this.rng.nextInt(rs.size()));
        }
        RouteItem ri = r1.getFirst();
        double tdScore = 1000000.0;
        RouteItem ri1 = r1.getFirst().getNext();
        RouteItem ri2 = r2.getFirst().getNext();
        int i = 0;
        while (i < r1.sizeOfRoute() - 2) {
            ri = ri.getNext();
            RouteItem rij = r2.getFirst();
            int j = 0;
            while (j < r2.sizeOfRoute() - 2) {
                rij = rij.getNext();
                double matrix = this.calcDistance(ri.getCurrLocation(), rij.getCurrLocation()) + (double)Math.abs(ri.getCurrLocation().getDueDate() - rij.getCurrLocation().getDueDate());
                if (matrix < tdScore) {
                    tdScore = matrix;
                    ri1 = ri;
                    ri2 = rij;
                }
                ++j;
            }
            ++i;
        }
        Location loc1 = ri1.getCurrLocation();
        Location loc2 = ri2.getCurrLocation();
        ri1.getPrev().setNext(ri1.getNext());
        ri1.getNext().setPrev(ri1.getPrev());
        ri2.getPrev().setNext(ri2.getNext());
        ri2.getNext().setPrev(ri2.getPrev());
        r1 = this.reOptimise(r1);
        r2 = this.reOptimise(r2);
        double score = 1000000.0;
        double bestPos = -1.0;
        ri = r2.getFirst();
        int routeElemPosition = 0;
        while ((ri = ri.getNext()).getNext() != null) {
            double matrix;
            if (!this.checkFeasibility(r2, ++routeElemPosition, loc1) || !((matrix = this.calcDistance(ri.getPrev().getCurrLocation(), loc1) + (double)Math.abs(ri.getPrev().getCurrLocation().getDueDate() - loc1.getDueDate())) < score)) continue;
            score = matrix;
            bestPos = routeElemPosition;
        }
        if (bestPos != -1.0) {
            ri = r2.getFirst();
            int i2 = 0;
            while (i2 < routeElemPosition) {
                ri = ri.getNext();
                ++i2;
            }
            RouteItem newRI2 = new RouteItem(loc1, ri.getPrev(), ri, 0.0);
            ri.getPrev().setNext(newRI2);
            ri.setPrev(newRI2);
            r2 = this.reOptimise(r2);
        } else {
            Route newR = new Route(r2.getFirst().getCurrLocation(), rs.size(), 0);
            ri = newR.getFirst();
            newRI = new RouteItem(loc1, ri, ri.getNext(), 0.0);
            ri.getNext().setPrev(newRI);
            ri.setNext(newRI);
            newR = this.reOptimise(newR);
            rs.add(newR);
        }
        score = 1000000.0;
        bestPos = -1.0;
        ri = r1.getFirst();
        routeElemPosition = 0;
        while ((ri = ri.getNext()).getNext() != null) {
            double matrix;
            if (!this.checkFeasibility(r1, ++routeElemPosition, loc2) || !((matrix = this.calcDistance(ri.getPrev().getCurrLocation(), loc2) + (double)Math.abs(ri.getPrev().getCurrLocation().getDueDate() - loc2.getDueDate())) < score)) continue;
            score = matrix;
            bestPos = routeElemPosition;
        }
        if (bestPos != -1.0) {
            ri = r1.getFirst();
            int i3 = 0;
            while (i3 < routeElemPosition) {
                ri = ri.getNext();
                ++i3;
            }
            RouteItem newRI3 = new RouteItem(loc2, ri.getPrev(), ri, 0.0);
            ri.getPrev().setNext(newRI3);
            ri.setPrev(newRI3);
            r1 = this.reOptimise(r1);
        } else {
            Route newR = new Route(r1.getFirst().getCurrLocation(), rs.size(), 0);
            ri = newR.getFirst();
            newRI = new RouteItem(loc1, ri, ri.getNext(), 0.0);
            ri.getNext().setPrev(newRI);
            ri.setNext(newRI);
            newR = this.reOptimise(newR);
            rs.add(newR);
        }
        copyS.setRoutes(this.deleteUnwantedRoutes(copyS.getRoutes()));
        double newFunc = this.calcFunction(copyS.getRoutes());
        this.solutions[solutionDestinationIndex] = copyS;
        if (newFunc < this.bestSolutionValue) {
            this.bestSolutionValue = newFunc;
            this.bestSolution = copyS.copySolution();
        }
        return newFunc;
    }

    public double locRR(int solutionSourceIndex, int solutionDestinationIndex) {
        Solution copyS = this.solutions[solutionSourceIndex].copySolution();
        ArrayList<Route> rs = copyS.getRoutes();
        Route rChoice = rs.get(this.rng.nextInt(rs.size()));
        int routePos = this.rng.nextInt(rChoice.sizeOfRoute() - 1);
        RouteItem rii = rChoice.getFirst();
        int i = 0;
        while (i < routePos) {
            rii = rii.getNext();
            ++i;
        }
        Location baseLocation = rii.getCurrLocation();
        double furthest = 0.0;
        for (Route r : rs) {
            rii = r.getFirst();
            while (rii != null) {
                if (this.calcDistance(rii.getCurrLocation(), baseLocation) > furthest) {
                    furthest = this.calcDistance(rii.getCurrLocation(), baseLocation);
                }
                rii = rii.getNext();
            }
        }
        double distanceWindow = this.intensityOfMutation * (3.0 * (furthest / 4.0));
        ArrayList<Location> locs = new ArrayList<Location>();
        ArrayList<Route> routesToDelete = new ArrayList<Route>();
        for (Route r : rs) {
            RouteItem ri = r.getFirst();
            while ((ri = ri.getNext()).getNext() != null) {
                double dist = this.calcDistance(ri.getCurrLocation(), baseLocation);
                if (!(dist < distanceWindow)) continue;
                locs.add(ri.getCurrLocation());
                ri.getPrev().setNext(ri.getNext());
                ri.getNext().setPrev(ri.getPrev());
            }
            if (r.sizeOfRoute() <= 2) {
                routesToDelete.add(r);
                continue;
            }
            ri = r.getFirst();
            while ((ri = ri.getNext()).getNext() != null) {
                int readyDueDiff;
                RouteItem prev = ri.getPrev();
                double diff = (double)ri.getCurrLocation().getDueDate() - (prev.getTimeArrived() + (double)prev.getCurrLocation().getServiceTime() + this.calcDistance(ri.getCurrLocation(), prev.getCurrLocation()));
                if (diff > (double)(readyDueDiff = ri.getCurrLocation().getDueDate() - ri.getCurrLocation().getReadyTime())) {
                    prev.setWaitingTime(diff - (double)readyDueDiff);
                } else {
                    prev.setWaitingTime(0.0);
                }
                ri.setTimeArrived(prev.getTimeArrived() + (double)prev.getCurrLocation().getServiceTime() + prev.getWaitingTime() + this.calcDistance(ri.getCurrLocation(), prev.getCurrLocation()));
            }
        }
        for (Route r : routesToDelete) {
            rs.remove(r);
        }
        for (Location l : locs) {
            rs = this.insertLocIntoRoute(rs, l);
        }
        copyS.setRoutes(this.deleteUnwantedRoutes(copyS.getRoutes()));
        this.solutions[solutionDestinationIndex] = copyS;
        double func = this.getFunctionValue(solutionDestinationIndex);
        return func;
    }

    public double timeRR(int solutionSourceIndex, int solutionDestinationIndex) {
        Solution copyS = this.solutions[solutionSourceIndex].copySolution();
        ArrayList<Route> rs = copyS.getRoutes();
        int timeRef = this.rng.nextInt(rs.get(0).getLast().getCurrLocation().getDueDate());
        double timeWindow = this.intensityOfMutation * (double)(rs.get(0).getLast().getCurrLocation().getDueDate() / 2);
        ArrayList<Location> locs = new ArrayList<Location>();
        ArrayList<Route> routesToDelete = new ArrayList<Route>();
        for (Route r : rs) {
            RouteItem ri = r.getFirst();
            while ((ri = ri.getNext()).getNext() != null) {
                double timeDiff = Math.abs(ri.getTimeArrived() - (double)timeRef);
                if (!(timeDiff < timeWindow)) continue;
                locs.add(ri.getCurrLocation());
                ri.getPrev().setNext(ri.getNext());
                ri.getNext().setPrev(ri.getPrev());
            }
            if (r.sizeOfRoute() <= 2) {
                routesToDelete.add(r);
                continue;
            }
            ri = r.getFirst();
            while ((ri = ri.getNext()).getNext() != null) {
                int readyDueDiff;
                RouteItem prev = ri.getPrev();
                double diff = (double)ri.getCurrLocation().getDueDate() - (prev.getTimeArrived() + (double)prev.getCurrLocation().getServiceTime() + this.calcDistance(ri.getCurrLocation(), prev.getCurrLocation()));
                if (diff > (double)(readyDueDiff = ri.getCurrLocation().getDueDate() - ri.getCurrLocation().getReadyTime())) {
                    prev.setWaitingTime(diff - (double)readyDueDiff);
                } else {
                    prev.setWaitingTime(0.0);
                }
                ri.setTimeArrived(prev.getTimeArrived() + (double)prev.getCurrLocation().getServiceTime() + prev.getWaitingTime() + this.calcDistance(ri.getCurrLocation(), prev.getCurrLocation()));
            }
        }
        for (Route r : routesToDelete) {
            rs.remove(r);
        }
        for (Location l : locs) {
            rs = this.insertLocIntoRoute(rs, l);
        }
        copyS.setRoutes(this.deleteUnwantedRoutes(copyS.getRoutes()));
        this.solutions[solutionDestinationIndex] = copyS;
        double func = this.getFunctionValue(solutionDestinationIndex);
        return func;
    }

    /*
     * Unable to fully structure code
     */
    public double shift(int solutionSourceIndex, int solutionDestinationIndex) {
        copyS = this.solutions[solutionSourceIndex].copySolution();
        copyS2 = this.solutions[solutionSourceIndex].copySolution();
        rs = copyS.getRoutes();
        numRoutesToUse = (int)(this.depthOfSearch * (double)rs.size());
        if (numRoutesToUse < 1) {
            numRoutesToUse = 1;
        }
        routesToUse = new int[numRoutesToUse];
        i = 0;
        while (i < numRoutesToUse) {
            routesToUse[i] = -1;
            ++i;
        }
        i = 0;
        while (i < numRoutesToUse) {
            r = this.rng.nextInt(numRoutesToUse);
            while (this.appears(routesToUse, r)) {
                r = this.rng.nextInt(numRoutesToUse);
            }
            routesToUse[i] = rs.get(r).getId();
            ++i;
        }
        i = 0;
        while (i < numRoutesToUse) {
            block14: {
                block15: {
                    routes = copyS2.getRoutes();
                    there = false;
                    r = routes.get(0);
                    m = 0;
                    while (m < routes.size()) {
                        if (routes.get(m).getId() == routesToUse[i]) {
                            r = routes.get(m);
                            there = true;
                        }
                        ++m;
                    }
                    if (!there) break block14;
                    firstFunc = this.calcFunction(routes);
                    bestPos = 1;
                    greatestDistance = 0.0;
                    pos = 0;
                    ri = r.getFirst();
                    while ((ri = ri.getNext()).getNext() != null) {
                        ++pos;
                        dist = (this.calcDistance(ri.getPrev().getCurrLocation(), ri.getCurrLocation()) + this.calcDistance(ri.getNext().getCurrLocation(), ri.getCurrLocation())) * (double)this.rng.nextFloat();
                        if (!(dist > greatestDistance)) continue;
                        greatestDistance = dist;
                        bestPos = pos;
                    }
                    ri = r.getFirst();
                    j = 0;
                    while (j < bestPos) {
                        ri = ri.getNext();
                        ++j;
                    }
                    locToInsert = ri.getCurrLocation();
                    ri.getPrev().setNext(ri.getNext());
                    ri.getNext().setPrev(ri.getPrev());
                    ri = ri.getPrev();
                    if (r.sizeOfRoute() > 2) ** GOTO lbl68
                    routes.remove(r);
                    break block15;
lbl-1000:
                    // 1 sources

                    {
                        prev = ri.getPrev();
                        diff = (double)ri.getCurrLocation().getDueDate() - (prev.getTimeArrived() + (double)prev.getCurrLocation().getServiceTime() + this.calcDistance(ri.getCurrLocation(), prev.getCurrLocation()));
                        if (diff > (double)(readyDueDiff = ri.getCurrLocation().getDueDate() - ri.getCurrLocation().getReadyTime())) {
                            prev.setWaitingTime(diff - (double)readyDueDiff);
                        } else {
                            prev.setWaitingTime(0.0);
                        }
                        ri.setTimeArrived(prev.getTimeArrived() + (double)prev.getCurrLocation().getServiceTime() + prev.getWaitingTime() + this.calcDistance(ri.getCurrLocation(), prev.getCurrLocation()));
lbl68:
                        // 2 sources

                        ** while ((ri = ri.getNext()).getNext() != null)
                    }
                }
                routes = this.insertLocIntoRoute(routes, locToInsert);
                newFunc = this.calcFunction(routes);
                if (newFunc >= firstFunc) {
                    copyS2.setRoutes(copyS.copySolution().getRoutes());
                } else {
                    copyS.setRoutes(routes);
                    copyS2.setRoutes(routes);
                    copyS = copyS.copySolution();
                }
            }
            ++i;
        }
        copyS.setRoutes(this.deleteUnwantedRoutes(copyS.getRoutes()));
        this.solutions[solutionDestinationIndex] = copyS;
        func = this.getFunctionValue(solutionDestinationIndex);
        return func;
    }

    public double interchange(int solutionSourceIndex, int solutionDestinationIndex) {
        RouteItem newRI;
        Solution copyS = this.solutions[solutionSourceIndex].copySolution();
        Solution copyS2 = this.solutions[solutionSourceIndex].copySolution();
        ArrayList<Route> rs = copyS.getRoutes();
        Route r1 = rs.get(this.rng.nextInt(rs.size()));
        while (r1.sizeOfRoute() <= 2) {
            r1 = rs.get(this.rng.nextInt(rs.size()));
        }
        Route r2 = rs.get(this.rng.nextInt(rs.size()));
        while (r1 == r2 || r2.sizeOfRoute() <= 2) {
            r2 = rs.get(this.rng.nextInt(rs.size()));
        }
        RouteItem ri = r1.getFirst();
        double tdScore = 1000000.0;
        RouteItem ri1 = r1.getFirst().getNext();
        RouteItem ri2 = r2.getFirst().getNext();
        int i = 0;
        while (i < r1.sizeOfRoute() - 2) {
            ri = ri.getNext();
            RouteItem rij = r2.getFirst();
            int j = 0;
            while (j < r2.sizeOfRoute() - 2) {
                rij = rij.getNext();
                double matrix = this.calcDistance(ri.getCurrLocation(), rij.getCurrLocation()) + (double)Math.abs(ri.getCurrLocation().getDueDate() - rij.getCurrLocation().getDueDate());
                if (matrix < tdScore) {
                    tdScore = matrix;
                    ri1 = ri;
                    ri2 = rij;
                }
                ++j;
            }
            ++i;
        }
        Location loc1 = ri1.getCurrLocation();
        Location loc2 = ri2.getCurrLocation();
        ri1.getPrev().setNext(ri1.getNext());
        ri1.getNext().setPrev(ri1.getPrev());
        ri2.getPrev().setNext(ri2.getNext());
        ri2.getNext().setPrev(ri2.getPrev());
        r1 = this.reOptimise(r1);
        r2 = this.reOptimise(r2);
        double score = 1000000.0;
        double bestPos = -1.0;
        ri = r2.getFirst();
        int routeElemPosition = 0;
        while ((ri = ri.getNext()).getNext() != null) {
            double matrix;
            if (!this.checkFeasibility(r2, ++routeElemPosition, loc1) || !((matrix = this.calcDistance(ri.getPrev().getCurrLocation(), loc1) + (double)Math.abs(ri.getPrev().getCurrLocation().getDueDate() - loc1.getDueDate())) < score)) continue;
            score = matrix;
            bestPos = routeElemPosition;
        }
        if (bestPos != -1.0) {
            ri = r2.getFirst();
            int i2 = 0;
            while (i2 < routeElemPosition) {
                ri = ri.getNext();
                ++i2;
            }
            RouteItem newRI2 = new RouteItem(loc1, ri.getPrev(), ri, 0.0);
            ri.getPrev().setNext(newRI2);
            ri.setPrev(newRI2);
            r2 = this.reOptimise(r2);
        } else {
            Route newR = new Route(r2.getFirst().getCurrLocation(), rs.size(), 0);
            ri = newR.getFirst();
            newRI = new RouteItem(loc1, ri, ri.getNext(), 0.0);
            ri.getNext().setPrev(newRI);
            ri.setNext(newRI);
            newR = this.reOptimise(newR);
            rs.add(newR);
        }
        score = 1000000.0;
        bestPos = -1.0;
        ri = r1.getFirst();
        routeElemPosition = 0;
        while ((ri = ri.getNext()).getNext() != null) {
            double matrix;
            if (!this.checkFeasibility(r1, ++routeElemPosition, loc2) || !((matrix = this.calcDistance(ri.getPrev().getCurrLocation(), loc2) + (double)Math.abs(ri.getPrev().getCurrLocation().getDueDate() - loc2.getDueDate())) < score)) continue;
            score = matrix;
            bestPos = routeElemPosition;
        }
        if (bestPos != -1.0) {
            ri = r1.getFirst();
            int i3 = 0;
            while (i3 < routeElemPosition) {
                ri = ri.getNext();
                ++i3;
            }
            RouteItem newRI3 = new RouteItem(loc2, ri.getPrev(), ri, 0.0);
            ri.getPrev().setNext(newRI3);
            ri.setPrev(newRI3);
            r1 = this.reOptimise(r1);
        } else {
            Route newR = new Route(r1.getFirst().getCurrLocation(), rs.size(), 0);
            ri = newR.getFirst();
            newRI = new RouteItem(loc1, ri, ri.getNext(), 0.0);
            ri.getNext().setPrev(newRI);
            ri.setNext(newRI);
            newR = this.reOptimise(newR);
            rs.add(newR);
        }
        double oldFunc = this.calcFunction(copyS2.getRoutes());
        copyS.setRoutes(this.deleteUnwantedRoutes(copyS.getRoutes()));
        double newFunc = this.calcFunction(copyS.getRoutes());
        if (newFunc < oldFunc) {
            this.solutions[solutionDestinationIndex] = copyS;
            if (newFunc < this.bestSolutionValue) {
                this.bestSolutionValue = newFunc;
                this.bestSolution = copyS.copySolution();
            }
            return newFunc;
        }
        this.solutions[solutionDestinationIndex] = copyS2;
        return oldFunc;
    }

    public double twoOptStar(int solutionSourceIndex, int solutionDestinationIndex) {
        Solution copyS = this.solutions[solutionSourceIndex].copySolution();
        ArrayList<Route> rs = copyS.getRoutes();
        int numTimesToPerform = 1;
        if ((int)(this.depthOfSearch * (double)rs.size()) != 0) {
            numTimesToPerform = this.rng.nextInt((int)(this.depthOfSearch * (double)rs.size()));
        }
        if (numTimesToPerform == 0) {
            ++numTimesToPerform;
        }
        int i = 0;
        while (i < numTimesToPerform) {
            Solution copyS2 = copyS.copySolution();
            ArrayList<Route> routes = copyS2.getRoutes();
            Route r1 = routes.get(this.rng.nextInt(routes.size()));
            Route r2 = routes.get(this.rng.nextInt(routes.size()));
            while (r1 == r2) {
                r2 = routes.get(this.rng.nextInt(routes.size()));
            }
            double bestScore = Double.POSITIVE_INFINITY;
            int bestR1Pos = -1;
            int bestR2Pos = -1;
            int currR1Pos = 0;
            RouteItem ri = r1.getFirst();
            while ((ri = ri.getNext()) != null) {
                ++currR1Pos;
                int currR2Pos = 0;
                RouteItem ri2 = r2.getFirst();
                while ((ri2 = ri2.getNext()) != null) {
                    double score;
                    if (!((score = this.feasibilityAndScore(r1, r2, currR1Pos, ++currR2Pos)) <= bestScore)) continue;
                    bestR1Pos = currR1Pos;
                    bestR2Pos = currR2Pos;
                    bestScore = score;
                }
            }
            ri = r1.getFirst();
            RouteItem ri2 = r2.getFirst();
            int j = 0;
            while (j < bestR1Pos) {
                ri = ri.getNext();
                ++j;
            }
            j = 0;
            while (j < bestR2Pos) {
                ri2 = ri2.getNext();
                ++j;
            }
            ri.getPrev().setNext(ri2);
            ri2.getPrev().setNext(ri);
            RouteItem riTemp = ri.getPrev();
            ri.setPrev(ri2.getPrev());
            ri2.setPrev(riTemp);
            r1 = this.reOptimise(r1);
            r2 = this.reOptimise(r2);
            routes = this.deleteUnwantedRoutes(routes);
            double oldFunc = this.calcFunction(copyS.getRoutes());
            double newFunc = this.calcFunction(routes);
            if (newFunc <= oldFunc) {
                copyS.setRoutes(routes);
            }
            ++i;
        }
        this.solutions[solutionDestinationIndex] = copyS.copySolution();
        double func = this.getFunctionValue(solutionDestinationIndex);
        return func;
    }

    public double feasibilityAndScore(Route r1, Route r2, int r1Pos, int r2Pos) {
        Route r11 = r1.copyRoute();
        Route r22 = r2.copyRoute();
        RouteItem ri = r11.getFirst();
        RouteItem ri2 = r22.getFirst();
        int i = 0;
        while (i < r1Pos) {
            ri = ri.getNext();
            ++i;
        }
        i = 0;
        while (i < r2Pos) {
            ri2 = ri2.getNext();
            ++i;
        }
        ri.getPrev().setNext(ri2);
        ri2.getPrev().setNext(ri);
        RouteItem riTemp = ri.getPrev();
        ri.setPrev(ri2.getPrev());
        ri2.setPrev(riTemp);
        r11 = this.reOptimise(r11);
        r22 = this.reOptimise(r22);
        double volume = 0.0;
        double score = 0.0;
        ri = r11.getFirst();
        ri2 = r22.getFirst();
        while ((ri = ri.getNext()) != null) {
            volume += (double)ri.getCurrLocation().getDemand();
            if (ri.getTimeArrived() > (double)ri.getCurrLocation().getDueDate()) {
                return Double.POSITIVE_INFINITY;
            }
            score += this.calcDistance(ri.getPrev().getCurrLocation(), ri.getCurrLocation());
        }
        if (volume > (double)this.instance.getVehicleCapacity()) {
            return Double.POSITIVE_INFINITY;
        }
        volume = 0.0;
        while ((ri2 = ri2.getNext()) != null) {
            volume += (double)ri2.getCurrLocation().getDemand();
            if (ri2.getTimeArrived() > (double)ri2.getCurrLocation().getDueDate()) {
                return Double.POSITIVE_INFINITY;
            }
            score += this.calcDistance(ri2.getPrev().getCurrLocation(), ri2.getCurrLocation());
        }
        if (volume > (double)this.instance.getVehicleCapacity()) {
            return Double.POSITIVE_INFINITY;
        }
        if (r11.sizeOfRoute() <= 2 || r22.sizeOfRoute() <= 2) {
            score -= 1000.0;
        }
        return score;
    }

    public double GENI(int solutionSourceIndex, int solutionDestinationIndex) {
        Solution copyS = this.solutions[solutionSourceIndex].copySolution();
        ArrayList<Route> rs = copyS.getRoutes();
        int numTimesToPerform = 1;
        if ((int)(this.depthOfSearch * (double)rs.size()) != 0) {
            numTimesToPerform = this.rng.nextInt((int)(this.depthOfSearch * (double)rs.size()));
        }
        if (numTimesToPerform == 0) {
            ++numTimesToPerform;
        }
        int i = 0;
        while (i < numTimesToPerform) {
            Solution copyS2 = copyS.copySolution();
            ArrayList<Route> routes = copyS2.getRoutes();
            Route r1 = routes.get(this.rng.nextInt(routes.size()));
            while (r1.sizeOfRoute() <= 3) {
                r1 = routes.get(this.rng.nextInt(routes.size()));
            }
            Route r2 = routes.get(this.rng.nextInt(routes.size()));
            while (r1 == r2 || r2.sizeOfRoute() <= 3) {
                r2 = routes.get(this.rng.nextInt(routes.size()));
            }
            RouteItem worstRouteItem = r1.getFirst();
            double worstScore = 0.0;
            RouteItem ri = r1.getFirst();
            while ((ri = ri.getNext()).getNext() != null) {
                double tempScore = (double)(ri.getCurrLocation().getReadyTime() - ri.getPrev().getCurrLocation().getReadyTime() + (ri.getNext().getCurrLocation().getDueDate() - ri.getCurrLocation().getDueDate())) + this.calcDistance(ri.getCurrLocation(), ri.getPrev().getCurrLocation()) + this.calcDistance(ri.getCurrLocation(), ri.getNext().getCurrLocation());
                if (!(tempScore > worstScore)) continue;
                worstScore = tempScore;
                worstRouteItem = ri;
            }
            worstRouteItem.getPrev().setNext(worstRouteItem.getNext());
            worstRouteItem.getNext().setPrev(worstRouteItem.getPrev());
            double firstClosestScore = Double.POSITIVE_INFINITY;
            double secondClosestScore = Double.POSITIVE_INFINITY;
            RouteItem firstRI = r2.getFirst();
            RouteItem secondRI = r2.getFirst();
            RouteItem ri2 = r2.getFirst();
            while ((ri2 = ri2.getNext()).getNext() != null) {
                double score = (double)Math.abs(worstRouteItem.getCurrLocation().getDueDate() - ri2.getCurrLocation().getDueDate()) + this.calcDistance(worstRouteItem.getCurrLocation(), ri2.getCurrLocation());
                if (score < firstClosestScore) {
                    secondClosestScore = firstClosestScore;
                    secondRI = firstRI;
                    firstClosestScore = score;
                    firstRI = ri2;
                    continue;
                }
                if (!(score < secondClosestScore)) continue;
                secondClosestScore = score;
                secondRI = ri2;
            }
            RouteItem earlyRI = firstRI;
            RouteItem lateRI = secondRI;
            if (secondRI.getCurrLocation().getDueDate() < firstRI.getCurrLocation().getDueDate()) {
                earlyRI = secondRI;
                lateRI = firstRI;
            }
            lateRI.getNext().setPrev(lateRI.getPrev());
            lateRI.getPrev().setNext(lateRI.getNext());
            lateRI.setNext(earlyRI.getNext());
            earlyRI.getNext().setPrev(lateRI);
            lateRI.setPrev(worstRouteItem);
            worstRouteItem.setNext(lateRI);
            earlyRI.setNext(worstRouteItem);
            worstRouteItem.setPrev(earlyRI);
            r1 = this.reOptimise(r1);
            r2 = this.reOptimise(r2);
            boolean feasible = true;
            double volume = 0.0;
            ri = r2.getFirst();
            while ((ri = ri.getNext()) != null) {
                volume += (double)ri.getCurrLocation().getDemand();
                if (!(ri.getTimeArrived() > (double)ri.getCurrLocation().getDueDate())) continue;
                feasible = false;
            }
            if (volume > (double)this.instance.getVehicleCapacity()) {
                feasible = false;
            }
            if (feasible) {
                double oldFunc = this.calcFunction(copyS.getRoutes());
                double newFunc = this.calcFunction(routes);
                if (newFunc <= oldFunc) {
                    copyS.setRoutes(routes);
                }
            }
            ++i;
        }
        this.solutions[solutionDestinationIndex] = copyS.copySolution();
        double func = this.getFunctionValue(solutionDestinationIndex);
        return func;
    }

    public double combine(int solutionSourceIndex1, int solutionSourceIndex2, int solutionDestinationIndex) {
        Solution newSolution;
        RouteItem ri;
        ArrayList<Route> others;
        ArrayList<Route> chosenOnes;
        Solution copyS1 = this.solutions[solutionSourceIndex1].copySolution();
        Solution copyS2 = this.solutions[solutionSourceIndex2].copySolution();
        ArrayList<Route> rs1 = copyS1.getRoutes();
        ArrayList<Route> rs2 = copyS2.getRoutes();
        ArrayList<Integer> locations = new ArrayList<Integer>();
        for (Route r : rs1) {
            RouteItem ri2 = r.getFirst();
            while ((ri2 = ri2.getNext()).getNext() != null) {
                locations.add(ri2.getCurrLocation().getId());
            }
        }
        int rand = this.rng.nextInt(50);
        double perc = (double)(75 - rand) / 100.0;
        rand = this.rng.nextInt(2);
        if (rand == 0) {
            chosenOnes = rs1;
            others = rs2;
        } else {
            chosenOnes = rs2;
            others = rs1;
        }
        ArrayList<Route> newRoutes = new ArrayList<Route>();
        ArrayList<Integer> addedLocations = new ArrayList<Integer>();
        for (Route r : chosenOnes) {
            if (!((double)this.rng.nextFloat() < perc)) continue;
            newRoutes.add(r);
            ri = r.getFirst();
            while ((ri = ri.getNext()).getNext() != null) {
                addedLocations.add(ri.getCurrLocation().getId());
            }
        }
        for (Route r : others) {
            if (!this.useableRoute(r, addedLocations)) continue;
            newRoutes.add(r);
            ri = r.getFirst();
            while ((ri = ri.getNext()).getNext() != null) {
                addedLocations.add(ri.getCurrLocation().getId());
            }
        }
        for (Route r : others) {
            ri = r.getFirst();
            while ((ri = ri.getNext()).getNext() != null) {
                if (this.containsID(ri.getCurrLocation().getId(), addedLocations)) continue;
                addedLocations.add(ri.getCurrLocation().getId());
                newRoutes = this.insertLocIntoRoute(newRoutes, ri.getCurrLocation());
            }
        }
        this.solutions[solutionDestinationIndex] = newSolution = new Solution(newRoutes);
        double func = this.getFunctionValue(solutionDestinationIndex);
        return func;
    }

    public double combineLong(int solutionSourceIndex1, int solutionSourceIndex2, int solutionDestinationIndex) {
        Solution newSolution;
        int i;
        Solution copyS1 = this.solutions[solutionSourceIndex1].copySolution();
        Solution copyS2 = this.solutions[solutionSourceIndex2].copySolution();
        ArrayList<Route> rs1 = copyS1.getRoutes();
        ArrayList<Route> rs2 = copyS2.getRoutes();
        ArrayList<Integer> addedLocations = new ArrayList<Integer>();
        ArrayList<Route> newRoutes = new ArrayList<Route>();
        ArrayList<Route> orderedRoutes = new ArrayList<Route>();
        for (Route r : rs1) {
            i = 0;
            while (i < orderedRoutes.size()) {
                if (r.sizeOfRoute() > ((Route)orderedRoutes.get(i)).sizeOfRoute()) {
                    orderedRoutes.add(i, r);
                    break;
                }
                if (i == orderedRoutes.size() - 1) {
                    orderedRoutes.add(r);
                    break;
                }
                ++i;
            }
            if (orderedRoutes.size() != 0) continue;
            orderedRoutes.add(r);
        }
        for (Route r : rs2) {
            i = 0;
            while (i < orderedRoutes.size()) {
                if (r.sizeOfRoute() > ((Route)orderedRoutes.get(i)).sizeOfRoute()) {
                    orderedRoutes.add(i, r);
                    break;
                }
                if (i == orderedRoutes.size() - 1) {
                    orderedRoutes.add(r);
                    break;
                }
                ++i;
            }
            if (orderedRoutes.size() != 0) continue;
            orderedRoutes.add(r);
        }
        for (Route r : orderedRoutes) {
            if (!this.useableRoute(r, addedLocations)) continue;
            newRoutes.add(r);
            RouteItem ri = r.getFirst();
            while ((ri = ri.getNext()).getNext() != null) {
                addedLocations.add(ri.getCurrLocation().getId());
            }
        }
        int choose = this.rng.nextInt(2);
        ArrayList<Route> remainingLocsRoutes = rs1;
        if (choose == 0) {
            remainingLocsRoutes = rs2;
        }
        for (Route r : remainingLocsRoutes) {
            RouteItem ri = r.getFirst();
            while ((ri = ri.getNext()).getNext() != null) {
                if (this.containsID(ri.getCurrLocation().getId(), addedLocations)) continue;
                addedLocations.add(ri.getCurrLocation().getId());
                newRoutes = this.insertLocIntoRoute(newRoutes, ri.getCurrLocation());
            }
        }
        this.solutions[solutionDestinationIndex] = newSolution = new Solution(newRoutes);
        double func = this.getFunctionValue(solutionDestinationIndex);
        return func;
    }

    public ArrayList<Route> deleteUnwantedRoutes(ArrayList<Route> rs) {
        ArrayList<Route> routesToDelete = new ArrayList<Route>();
        for (Route r : rs) {
            if (r.sizeOfRoute() > 2) continue;
            routesToDelete.add(r);
        }
        for (Route r : routesToDelete) {
            rs.remove(r);
        }
        return rs;
    }

    public boolean containsID(int iD, ArrayList<Integer> ids) {
        for (Integer i : ids) {
            if (i != iD) continue;
            return true;
        }
        return false;
    }

    public boolean useableRoute(Route r, ArrayList<Integer> ls) {
        RouteItem ri = r.getFirst();
        while ((ri = ri.getNext()).getNext() != null) {
            for (Integer i : ls) {
                if (i.intValue() != ri.getCurrLocation().getId()) continue;
                return false;
            }
        }
        return true;
    }

    public Route reOptimise(Route r) {
        RouteItem ri = r.getFirst();
        while ((ri = ri.getNext()).getNext() != null) {
            int readyDueDiff;
            RouteItem prev = ri.getPrev();
            double diff = (double)ri.getCurrLocation().getDueDate() - (prev.getTimeArrived() + (double)prev.getCurrLocation().getServiceTime() + this.calcDistance(ri.getCurrLocation(), prev.getCurrLocation()));
            if (diff > (double)(readyDueDiff = ri.getCurrLocation().getDueDate() - ri.getCurrLocation().getReadyTime())) {
                prev.setWaitingTime(diff - (double)readyDueDiff);
            } else {
                prev.setWaitingTime(0.0);
            }
            ri.setTimeArrived(prev.getTimeArrived() + (double)prev.getCurrLocation().getServiceTime() + prev.getWaitingTime() + this.calcDistance(ri.getCurrLocation(), prev.getCurrLocation()));
        }
        return r;
    }

    private ArrayList<Route> insertLocIntoRoute(ArrayList<Route> rs, Location loc) {
        int readyDueDiff;
        double timeDiff;
        RouteItem ri;
        int routeElemPosition = 0;
        int bestRouteNum = -1;
        int bestRouteElemPosition = 0;
        double bestWaitingTime = 1000000.0;
        int i = 0;
        while (i < rs.size()) {
            routeElemPosition = 0;
            ri = rs.get(i).getFirst();
            while ((ri = ri.getNext()).getNext() != null) {
                if (!this.checkFeasibility(rs.get(i), ++routeElemPosition, loc)) continue;
                RouteItem prev = ri.getPrev();
                timeDiff = (double)loc.getDueDate() - (prev.getTimeArrived() + (double)prev.getCurrLocation().getServiceTime() + this.calcDistance(loc, prev.getCurrLocation()));
                if (timeDiff > (double)(readyDueDiff = loc.getDueDate() - loc.getReadyTime())) {
                    if (!(bestWaitingTime > timeDiff - (double)readyDueDiff + this.calcDistance(loc, prev.getCurrLocation()))) continue;
                    bestWaitingTime = timeDiff - (double)readyDueDiff + this.calcDistance(loc, prev.getCurrLocation());
                    bestRouteNum = i;
                    bestRouteElemPosition = routeElemPosition;
                    continue;
                }
                if (!(bestWaitingTime > this.calcDistance(loc, prev.getCurrLocation()))) continue;
                bestWaitingTime = this.calcDistance(loc, prev.getCurrLocation());
                bestRouteNum = i;
                bestRouteElemPosition = routeElemPosition;
            }
            ++i;
        }
        if (bestRouteNum == -1) {
            int readyDueDiff2;
            Route newR = rs.size() == 0 ? new Route(this.instance.getDepot(), 0, 0) : new Route(rs.get(0).getFirst().getCurrLocation(), rs.size(), 0);
            ri = newR.getFirst();
            double timeDiff2 = (double)loc.getDueDate() - (ri.getTimeArrived() + (double)ri.getCurrLocation().getServiceTime() + this.calcDistance(loc, ri.getCurrLocation()));
            if (timeDiff2 > (double)(readyDueDiff2 = loc.getDueDate() - loc.getReadyTime())) {
                ri.setWaitingTime(timeDiff2 - (double)readyDueDiff2);
            } else {
                ri.setWaitingTime(0.0);
            }
            RouteItem newRI = new RouteItem(loc, ri, ri.getNext(), ri.getTimeArrived() + (double)ri.getCurrLocation().getServiceTime() + ri.getWaitingTime() + this.calcDistance(loc, ri.getCurrLocation()));
            ri.getNext().setPrev(newRI);
            ri.setNext(newRI);
            rs.add(newR);
        } else {
            Route currR = rs.get(bestRouteNum);
            ri = currR.getFirst();
            int i2 = 0;
            while (i2 < bestRouteElemPosition) {
                ri = ri.getNext();
                ++i2;
            }
            RouteItem prev = ri.getPrev();
            timeDiff = (double)loc.getDueDate() - (prev.getTimeArrived() + (double)prev.getCurrLocation().getServiceTime() + this.calcDistance(loc, prev.getCurrLocation()));
            if (timeDiff > (double)(readyDueDiff = loc.getDueDate() - loc.getReadyTime())) {
                prev.setWaitingTime(timeDiff - (double)readyDueDiff);
            } else {
                prev.setWaitingTime(0.0);
            }
            RouteItem newRI = new RouteItem(loc, prev, prev.getNext(), prev.getTimeArrived() + (double)prev.getCurrLocation().getServiceTime() + prev.getWaitingTime() + this.calcDistance(loc, prev.getCurrLocation()));
            prev.getNext().setPrev(newRI);
            prev.setNext(newRI);
            ri = newRI;
            while ((ri = ri.getNext()).getNext() != null) {
                prev = ri.getPrev();
                double diff = (double)ri.getCurrLocation().getDueDate() - (prev.getTimeArrived() + (double)prev.getCurrLocation().getServiceTime() + this.calcDistance(ri.getCurrLocation(), prev.getCurrLocation()));
                if (diff > (double)(readyDueDiff = ri.getCurrLocation().getDueDate() - ri.getCurrLocation().getReadyTime())) {
                    prev.setWaitingTime(diff - (double)readyDueDiff);
                } else {
                    prev.setWaitingTime(0.0);
                }
                ri.setTimeArrived(prev.getTimeArrived() + (double)prev.getCurrLocation().getServiceTime() + prev.getWaitingTime() + this.calcDistance(ri.getCurrLocation(), prev.getCurrLocation()));
            }
        }
        return rs;
    }

    private boolean checkFeasibility(Route r, int position, Location l) {
        if (r.calcVolume() + l.getDemand() > this.instance.getVehicleCapacity()) {
            return false;
        }
        Route route = r.copyRoute();
        RouteItem ri = route.getFirst();
        int i = 0;
        while (i < position) {
            ri = ri.getNext();
            ++i;
        }
        RouteItem prev = ri.getPrev();
        double diff = (double)l.getDueDate() - (prev.getTimeArrived() + (double)prev.getCurrLocation().getServiceTime() + this.calcDistance(l, prev.getCurrLocation()));
        if (diff < 0.0) {
            return false;
        }
        int readyDueDiff = l.getDueDate() - l.getReadyTime();
        if (diff > (double)readyDueDiff) {
            prev.setWaitingTime(diff - (double)readyDueDiff);
        } else {
            prev.setWaitingTime(0.0);
        }
        RouteItem newRI = new RouteItem(l, prev, prev.getNext(), prev.getTimeArrived() + (double)prev.getCurrLocation().getServiceTime() + prev.getWaitingTime() + this.calcDistance(l, prev.getCurrLocation()));
        prev.getNext().setPrev(newRI);
        prev.setNext(newRI);
        ri = newRI;
        while ((ri = ri.getNext()).getNext() != null) {
            prev = ri.getPrev();
            diff = (double)ri.getCurrLocation().getDueDate() - (prev.getTimeArrived() + (double)prev.getCurrLocation().getServiceTime() + this.calcDistance(ri.getCurrLocation(), prev.getCurrLocation()));
            readyDueDiff = ri.getCurrLocation().getDueDate() - ri.getCurrLocation().getReadyTime();
            if (diff < 0.0) {
                return false;
            }
            if (diff > (double)readyDueDiff) {
                prev.setWaitingTime(diff - (double)readyDueDiff);
            } else {
                prev.setWaitingTime(0.0);
            }
            ri.setTimeArrived(prev.getTimeArrived() + (double)prev.getCurrLocation().getServiceTime() + prev.getWaitingTime() + this.calcDistance(ri.getCurrLocation(), prev.getCurrLocation()));
        }
        ri = route.getLast();
        return !((double)ri.getCurrLocation().getDueDate() < ri.getPrev().getTimeArrived() + (double)ri.getPrev().getCurrLocation().getServiceTime() + this.calcDistance(ri.getPrev().getCurrLocation(), ri.getCurrLocation()));
    }

    private boolean appears(int[] arr, int ref) {
        boolean appear = false;
        int[] nArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (i == ref) {
                appear = true;
                break;
            }
            ++n2;
        }
        return appear;
    }

    public boolean duplicates(ArrayList<Route> rs) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (Route r : rs) {
            RouteItem ri = r.getFirst();
            while ((ri = ri.getNext()).getNext() != null) {
                if (ids.contains(ri.getCurrLocation().getId())) {
                    System.out.println(ri.getCurrLocation().getId());
                    return true;
                }
                ids.add(ri.getCurrLocation().getId());
            }
        }
        return false;
    }

    @Override
    public void copySolution(int solutionSourceIndex, int solutionDestinationIndex) {
        this.solutions[solutionDestinationIndex] = this.solutions[solutionSourceIndex].copySolution();
    }

    @Override
    public String toString() {
        return "Vehicle Routing";
    }

    @Override
    public int getNumberOfInstances() {
        return 56;
    }

    @Override
    public String bestSolutionToString() {
        return this.printToString(this.bestSolution);
    }

    @Override
    public double getBestSolutionValue() {
        return this.bestSolutionValue;
    }

    @Override
    public String solutionToString(int solutionIndex) {
        return this.printToString(this.solutions[solutionIndex]);
    }

    private String printToString(Solution s) {
        ArrayList<Route> rs = s.getRoutes();
        String nL = System.getProperty("line.separator");
        String printedString = "";
        int i = 0;
        while (i < rs.size()) {
            printedString = String.valueOf(printedString) + "Route " + i + nL;
            RouteItem rI = rs.get(i).getFirst();
            while (rI != null) {
                printedString = String.valueOf(printedString) + "Location" + rI.getCurrLocation().getId() + " visited at " + rI.getTimeArrived() + nL;
                rI = rI.getNext();
            }
            ++i;
        }
        return printedString;
    }

    @Override
    public double getFunctionValue(int solutionIndex) {
        ArrayList<Route> routes = this.solutions[solutionIndex].getRoutes();
        double value = this.calcFunction(routes);
        if (value < this.bestSolutionValue) {
            this.bestSolutionValue = value;
            this.bestSolution = this.solutions[solutionIndex].copySolution();
        }
        return value;
    }

    public double calcFunction(ArrayList<Route> rs) {
        ArrayList<Route> routes = rs;
        int numRs = routes.size();
        double distance = 0.0;
        for (Route r : routes) {
            RouteItem rItem = r.getFirst();
            while (rItem.getNext() != null) {
                distance += this.calcDistance(rItem.getCurrLocation(), rItem.getNext().getCurrLocation());
                rItem = rItem.getNext();
            }
        }
        double value = (double)(1000 * numRs) + distance;
        return value;
    }

    @Override
    public boolean compareSolutions(int solutionIndex1, int solutionIndex2) {
        ArrayList<Route> rs1 = this.solutions[solutionIndex1].getRoutes();
        ArrayList<Route> rs2 = this.solutions[solutionIndex2].getRoutes();
        int i = 0;
        while (i < rs1.size()) {
            if (!rs1.get(i).compareRoute(rs2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void traverseBack(Solution s) {
        ArrayList<Route> rs = s.getRoutes();
        for (Route r : rs) {
            RouteItem ri = r.getLast();
            while ((ri = ri.getPrev()) != null) {
                System.out.println(ri.getCurrLocation().getId());
            }
        }
    }

    double calcDistance(Location l1, Location l2) {
        int xdiff = Math.abs(l1.getXCoord() - l2.getXCoord());
        int ydiff = Math.abs(l1.getYCoord() - l2.getYCoord());
        return Math.sqrt(xdiff * xdiff + ydiff * ydiff);
    }

    public static void main(String[] args) {
        VRP vrp = new VRP(4234L);
        vrp.loadInstance(0);
        vrp.setMemorySize(2);
        vrp.initialiseSolution(0);
        System.out.println(vrp.duplicates(vrp.solutions[0].getRoutes()));
        System.out.println(vrp.calcFunction(vrp.solutions[0].getRoutes()));
        vrp.setIntensityOfMutation(1.0);
        vrp.setDepthOfSearch(1.0);
        int i = 0;
        while (i < 1) {
            System.out.println(vrp.twoOptStar(0, 1));
            System.out.println(vrp.duplicates(vrp.solutions[0].getRoutes()));
            System.out.println(vrp.duplicates(vrp.solutions[1].getRoutes()));
            System.out.println(vrp.shift(1, 0));
            System.out.println(vrp.interchange(0, 1));
            System.out.println(vrp.GENI(1, 0));
            ++i;
        }
        int j = 0;
        while (j < 1) {
            if (j % 2 == 0) {
                System.out.println(vrp.locRR(0, 0));
            } else {
                System.out.println(vrp.timeRR(0, 0));
            }
            int i2 = 0;
            while (i2 < 1) {
                System.out.println(vrp.twoOptStar(0, 1));
                System.out.println(vrp.shift(1, 0));
                System.out.println(vrp.interchange(0, 1));
                System.out.println(vrp.GENI(1, 0));
                ++i2;
            }
            ++j;
        }
        System.out.println(vrp.bestSolutionValue);
        System.out.println(vrp.bestSolution.getRoutes().size());
    }
}

