/*
 * Decompiled with CFR 0.152.
 */
package travelingSalesmanProblem;

import AbstractClasses.ProblemDomain;
import java.util.Arrays;
import travelingSalesmanProblem.TspBasicAlgorithms;
import travelingSalesmanProblem.TspInstance;
import travelingSalesmanProblem.TspSolution;

public class TSP
extends ProblemDomain {
    public TspInstance instance;
    private TspSolution[] memory = new TspSolution[2];
    private TspSolution bestSoFar;
    public TspBasicAlgorithms algorithms;

    public TSP(long seed) {
        super(seed);
    }

    @Override
    public double applyHeuristic(int llhID, int solutionSourceIndex, int solutionDestinationIndex) {
        long startTime = System.currentTimeMillis();
        boolean isCrossover = false;
        int[] crossovers = this.getHeuristicsOfType(ProblemDomain.HeuristicType.CROSSOVER);
        if (crossovers != null) {
            int x = 0;
            while (x < crossovers.length) {
                if (crossovers[x] == llhID) {
                    isCrossover = true;
                    break;
                }
                ++x;
            }
        }
        if (isCrossover) {
            this.copySolution(solutionSourceIndex, solutionDestinationIndex);
        } else {
            switch (llhID) {
                case 0: {
                    this.randomReinsertion(solutionSourceIndex, solutionDestinationIndex);
                    break;
                }
                case 1: {
                    this.swapTwo(solutionSourceIndex, solutionDestinationIndex);
                    break;
                }
                case 2: {
                    this.shuffle(solutionSourceIndex, solutionDestinationIndex);
                    break;
                }
                case 3: {
                    this.shuffleSubSequence(solutionSourceIndex, solutionDestinationIndex);
                    break;
                }
                case 4: {
                    this.nOptMove(solutionSourceIndex, solutionDestinationIndex);
                    break;
                }
                case 5: {
                    this.iteratedGreedy(solutionSourceIndex, solutionDestinationIndex);
                    break;
                }
                case 6: {
                    this.twoOptLocalSearch(solutionSourceIndex, solutionDestinationIndex);
                    break;
                }
                case 7: {
                    this.bestImpTwoOptLocalSearch(solutionSourceIndex, solutionDestinationIndex);
                    break;
                }
                case 8: {
                    this.threeOptLocalSearch(solutionSourceIndex, solutionDestinationIndex);
                    break;
                }
                default: {
                    System.err.println("heuristic does not exist, or the crossover index array is not set up correctly");
                    System.exit(-1);
                }
            }
        }
        int n = llhID;
        this.heuristicCallRecord[n] = this.heuristicCallRecord[n] + 1;
        int n2 = llhID;
        this.heuristicCallTimeRecord[n2] = (int)((long)this.heuristicCallTimeRecord[n2] + (System.currentTimeMillis() - startTime));
        this.verifyBestSolution(this.memory[solutionDestinationIndex]);
        assert (this.algorithms.verifyPermutation(this.memory[solutionDestinationIndex].permutation, this.instance.numbCities));
        return this.memory[solutionDestinationIndex].Cost;
    }

    @Override
    public double applyHeuristic(int llhID, int solutionSourceIndex1, int solutionSourceIndex2, int solutionDestinationIndex) {
        long startTime = System.currentTimeMillis();
        switch (llhID) {
            case 0: {
                this.randomReinsertion(solutionSourceIndex1, solutionDestinationIndex);
                break;
            }
            case 1: {
                this.swapTwo(solutionSourceIndex1, solutionDestinationIndex);
                break;
            }
            case 2: {
                this.shuffle(solutionSourceIndex1, solutionDestinationIndex);
                break;
            }
            case 3: {
                this.shuffleSubSequence(solutionSourceIndex1, solutionDestinationIndex);
                break;
            }
            case 4: {
                this.nOptMove(solutionSourceIndex1, solutionDestinationIndex);
                break;
            }
            case 5: {
                this.iteratedGreedy(solutionSourceIndex1, solutionDestinationIndex);
                break;
            }
            case 6: {
                this.twoOptLocalSearch(solutionSourceIndex1, solutionDestinationIndex);
                break;
            }
            case 7: {
                this.bestImpTwoOptLocalSearch(solutionSourceIndex1, solutionDestinationIndex);
                break;
            }
            case 8: {
                this.threeOptLocalSearch(solutionSourceIndex1, solutionDestinationIndex);
                break;
            }
            case 9: {
                this.ox(solutionSourceIndex1, solutionSourceIndex2, solutionDestinationIndex);
                break;
            }
            case 10: {
                this.pmx(solutionSourceIndex1, solutionSourceIndex2, solutionDestinationIndex);
                break;
            }
            case 11: {
                this.ppx(solutionSourceIndex1, solutionSourceIndex2, solutionDestinationIndex);
                break;
            }
            case 12: {
                this.oneX(solutionSourceIndex1, solutionSourceIndex2, solutionDestinationIndex);
                break;
            }
            default: {
                System.err.println("heuristic does not exist, or the crossover index array is not set up correctly");
                System.exit(-1);
            }
        }
        int n = llhID;
        this.heuristicCallRecord[n] = this.heuristicCallRecord[n] + 1;
        int n2 = llhID;
        this.heuristicCallTimeRecord[n2] = (int)((long)this.heuristicCallTimeRecord[n2] + (System.currentTimeMillis() - startTime));
        this.verifyBestSolution(this.memory[solutionDestinationIndex]);
        assert (this.algorithms.verifyPermutation(this.memory[solutionDestinationIndex].permutation, this.instance.numbCities));
        return this.memory[solutionDestinationIndex].Cost;
    }

    @Override
    public String bestSolutionToString() {
        return this.bestSoFar.toString();
    }

    @Override
    public boolean compareSolutions(int solutionIndex1, int solutionIndex2) {
        TspSolution s1 = this.memory[solutionIndex1];
        TspSolution s2 = this.memory[solutionIndex2];
        int i = 0;
        while (i < this.instance.numbCities) {
            if (s1.permutation[i] != s2.permutation[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void copySolution(int solutionSourceIndex, int solutionDestinationIndex) {
        this.memory[solutionDestinationIndex] = this.memory[solutionSourceIndex].clone();
    }

    @Override
    public double getBestSolutionValue() {
        return this.bestSoFar.Cost;
    }

    @Override
    public double getFunctionValue(int solutionIndex) {
        return this.memory[solutionIndex].Cost;
    }

    @Override
    public int[] getHeuristicsOfType(ProblemDomain.HeuristicType heuristicType) {
        if (heuristicType == ProblemDomain.HeuristicType.MUTATION) {
            int[] nArray = new int[5];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            nArray[4] = 4;
            return nArray;
        }
        if (heuristicType == ProblemDomain.HeuristicType.RUIN_RECREATE) {
            return new int[]{5};
        }
        if (heuristicType == ProblemDomain.HeuristicType.LOCAL_SEARCH) {
            return new int[]{6, 7, 8};
        }
        if (heuristicType == ProblemDomain.HeuristicType.CROSSOVER) {
            return new int[]{9, 10, 11, 12};
        }
        return null;
    }

    @Override
    public int[] getHeuristicsThatUseDepthOfSearch() {
        return new int[]{6, 7, 8};
    }

    @Override
    public int[] getHeuristicsThatUseIntensityOfMutation() {
        return new int[]{3, 4, 5};
    }

    @Override
    public int getNumberOfHeuristics() {
        return 13;
    }

    @Override
    public int getNumberOfInstances() {
        return 10;
    }

    @Override
    public void initialiseSolution(int i) {
        int startCity = this.rng.nextInt(this.instance.numbCities);
        int[] initialSolution = this.algorithms.greedyHeuristic(startCity);
        double cost = this.algorithms.computeCost(initialSolution);
        this.memory[i] = new TspSolution(initialSolution, cost);
        this.verifyBestSolution(this.memory[i]);
    }

    @Override
    public void loadInstance(int instanceID) {
        this.instance = new TspInstance(instanceID);
        this.algorithms = new TspBasicAlgorithms(this.instance);
    }

    @Override
    public void setMemorySize(int size) {
        TspSolution[] tempMemory = new TspSolution[size];
        if (this.memory != null) {
            if (tempMemory.length <= this.memory.length) {
                int i = 0;
                while (i < tempMemory.length) {
                    tempMemory[i] = this.memory[i];
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.memory.length) {
                    tempMemory[i] = this.memory[i];
                    ++i;
                }
            }
        }
        this.memory = tempMemory;
    }

    @Override
    public String solutionToString(int solutionIndex) {
        return this.memory[solutionIndex].toString();
    }

    @Override
    public String toString() {
        return this.instance.toString();
    }

    private void randomReinsertion(int sourceIndex, int targetIndex) {
        int i;
        int i2;
        int[] array = (int[])this.memory[sourceIndex].permutation.clone();
        int i1 = this.rng.nextInt(array.length);
        while ((i2 = this.rng.nextInt(array.length)) == i1) {
        }
        int[] newArray = new int[array.length];
        newArray[i2] = array[i1];
        if (i1 < i2) {
            i = 0;
            int count = 0;
            while (count < array.length) {
                if (i == i1) {
                    ++count;
                }
                if (i == i2) {
                    --count;
                } else {
                    newArray[i] = array[count];
                }
                ++i;
                ++count;
            }
        } else {
            i = 0;
            int count = 0;
            while (count < array.length) {
                if (i == i2) {
                    --count;
                } else {
                    newArray[i] = array[count];
                    if (i == i1) {
                        ++count;
                    }
                }
                ++i;
                ++count;
            }
        }
        double cost = this.algorithms.computeCost(newArray);
        this.memory[targetIndex] = new TspSolution(newArray, cost);
    }

    private void swapTwo(int sourceIndex, int targetIndex) {
        int[] array = (int[])this.memory[sourceIndex].permutation.clone();
        int i1 = this.rng.nextInt(array.length);
        int i2 = this.rng.nextInt(array.length);
        array[i1] = this.memory[sourceIndex].permutation[i2];
        array[i2] = this.memory[sourceIndex].permutation[i1];
        double cost = this.algorithms.computeCost(array);
        this.memory[targetIndex] = new TspSolution(array, cost);
    }

    private void shuffle(int sourceIndex, int targetIndex) {
        int[] array = (int[])this.memory[sourceIndex].permutation.clone();
        this.algorithms.shufflePermutation(array, this.rng);
        double cost = this.algorithms.computeCost(array);
        this.memory[targetIndex] = new TspSolution(array, cost);
    }

    private void shuffleSubSequence(int sourceIndex, int targetIndex) {
        int numbToShuffle = 2 + (int)(this.getIntensityOfMutation() * (double)(this.instance.numbCities - 2));
        int[] AvailableIndices = new int[this.instance.numbCities];
        Arrays.fill(AvailableIndices, 1);
        int count = this.instance.numbCities;
        int[] IndicesToShuffle = new int[numbToShuffle];
        int[] jobIndices = new int[numbToShuffle];
        int[] permutation = (int[])this.memory[sourceIndex].permutation.clone();
        int count2 = 0;
        int i = 0;
        while (i < numbToShuffle) {
            int randomInteger = this.rng.nextInt(count);
            --count;
            count2 = 0;
            int j = 0;
            while (j < permutation.length) {
                if (AvailableIndices[j] == 1) {
                    if (count2 == randomInteger) {
                        IndicesToShuffle[i] = j;
                        jobIndices[i] = permutation[j];
                        AvailableIndices[j] = -1;
                        break;
                    }
                    ++count2;
                }
                ++j;
            }
            ++i;
        }
        this.algorithms.shufflePermutation(IndicesToShuffle, this.rng);
        i = 0;
        while (i < numbToShuffle) {
            permutation[IndicesToShuffle[i]] = jobIndices[i];
            ++i;
        }
        double cost = this.algorithms.computeCost(permutation);
        this.memory[targetIndex] = new TspSolution(permutation, cost);
    }

    private void nOptMove(int sourceIndex, int targetIndex) {
        int N = 2;
        if (this.intensityOfMutation >= 0.25) {
            N = 3;
        }
        if (this.intensityOfMutation >= 0.5) {
            N = 4;
        }
        if (this.intensityOfMutation >= 0.75) {
            N = 5;
        }
        int[] tour = this.memory[sourceIndex].permutation;
        int[] newTour = (int[])tour.clone();
        int i = 0;
        while (i < N - 1) {
            int city2;
            int city1 = this.rng.nextInt(this.instance.numbCities);
            while ((city2 = this.rng.nextInt(this.instance.numbCities)) == city1) {
            }
            newTour = TspBasicAlgorithms.flip(newTour, city1, city2);
            ++i;
        }
        double cost = this.algorithms.computeCost(newTour);
        this.memory[targetIndex] = new TspSolution(newTour, cost);
    }

    private void iteratedGreedy(int sourceIndex, int targetIndex) {
        int numbCities = this.instance.numbCities;
        double mut = this.getIntensityOfMutation();
        mut = mut < 0.2 ? 0.1 : (mut < 0.4 ? 0.2 : (mut < 0.6 ? 0.3 : (mut < 0.8 ? 0.4 : 0.5)));
        int numbRemove = (int)(mut * (double)(numbCities - 1)) + 1;
        int[] partialTour = new int[numbCities - numbRemove];
        int[] citiesToInsert = new int[numbRemove];
        int[] list = (int[])this.memory[sourceIndex].permutation.clone();
        int i = 0;
        while (i < numbRemove) {
            int id = this.rng.nextInt(numbCities);
            while (list[id] < 0) {
                id = this.rng.nextInt(numbCities);
            }
            citiesToInsert[i] = list[id];
            list[id] = -1;
            ++i;
        }
        i = 0;
        int j = 0;
        while (i < numbCities) {
            try {
                if (list[i] > -1) {
                    partialTour[j] = list[i];
                } else {
                    --j;
                }
            }
            catch (Exception ex) {
                System.out.println(" " + partialTour.length + " " + list.length + " j " + j + " i " + i);
                System.exit(0);
            }
            ++i;
            ++j;
        }
        double cost = this.algorithms.computeCost(partialTour);
        int[] permutation = this.algorithms.greedyInsertion(partialTour, citiesToInsert, cost);
        cost = this.algorithms.computeCost(permutation);
        this.memory[targetIndex] = new TspSolution(permutation, cost);
    }

    private void twoOptLocalSearch(int sourceIndex, int targetIndex) {
        int maxiterations = 10;
        maxiterations = this.depthOfSearch < 0.2 ? 10 : (this.depthOfSearch < 0.4 ? 20 : (this.depthOfSearch < 0.6 ? 30 : (this.depthOfSearch < 0.8 ? 40 : 50)));
        int[] improvedTour = this.algorithms.twoOptFirstImprovement(this.memory[sourceIndex].permutation, this.instance, maxiterations);
        double cost = this.algorithms.computeCost(improvedTour);
        this.memory[targetIndex] = new TspSolution(improvedTour, cost);
    }

    private void bestImpTwoOptLocalSearch(int sourceIndex, int targetIndex) {
        int maxiterations = 10;
        maxiterations = this.depthOfSearch < 0.2 ? 10 : (this.depthOfSearch < 0.4 ? 20 : (this.depthOfSearch < 0.6 ? 30 : (this.depthOfSearch < 0.8 ? 40 : 50)));
        int[] improvedTour = this.algorithms.twoOptBestImprovement(this.memory[sourceIndex].permutation, this.instance, maxiterations);
        double cost = this.algorithms.computeCost(improvedTour);
        this.memory[targetIndex] = new TspSolution(improvedTour, cost);
    }

    private void threeOptLocalSearch(int sourceIndex, int targetIndex) {
        int maxiterations = 10;
        maxiterations = this.depthOfSearch < 0.2 ? 10 : (this.depthOfSearch < 0.4 ? 20 : (this.depthOfSearch < 0.6 ? 30 : (this.depthOfSearch < 0.8 ? 40 : 50)));
        int[] improvedTour = this.algorithms.threeOpt(this.memory[sourceIndex].permutation, this.instance, maxiterations);
        double cost = this.algorithms.computeCost(improvedTour);
        this.memory[targetIndex] = new TspSolution(improvedTour, cost);
    }

    private void ox(int sourceIndex1, int sourceIndex2, int targetIndex) {
        int job;
        int[] p1 = this.memory[sourceIndex1].permutation;
        int[] p22 = this.memory[sourceIndex2].permutation;
        if (p1.length <= 1 || p22.length <= 1 || p1.length != p22.length) {
            System.out.println("Error in ox (order crossover) input permutation are not of the same length or one of them is of size <= 1");
            System.exit(0);
        }
        int[] p2 = (int[])p22.clone();
        int n = p1.length;
        int point1 = this.rng.nextInt(n);
        int point2 = this.rng.nextInt(n);
        while (point2 == point1) {
            point2 = this.rng.nextInt(n);
        }
        if (point2 < point1) {
            int temp = point1;
            point1 = point2;
            point2 = temp;
        }
        int pointsToCopy = point2 - point1;
        int[] inverseP2 = this.algorithms.inversePermutation(p2);
        int i = 0;
        while (i < pointsToCopy) {
            job = p1[point1 + i];
            int job_index = inverseP2[job];
            p2[job_index] = -1;
            ++i;
        }
        int insertionPoint = inverseP2[p1[point1]];
        int[] receiver = new int[n + pointsToCopy];
        int counter = 0;
        int i2 = 0;
        while (i2 <= n) {
            if (i2 < insertionPoint) {
                receiver[i2] = p2[i2];
            }
            if (i2 == insertionPoint) {
                int j = 0;
                while (j < pointsToCopy) {
                    receiver[i2 + j] = p1[point1 + j];
                    ++j;
                }
            }
            if (i2 > insertionPoint) {
                receiver[i2 - 1 + pointsToCopy] = p2[i2 - 1];
            }
            ++i2;
        }
        int[] p3 = new int[n];
        counter = 0;
        int i3 = 0;
        while (i3 < n) {
            job = receiver[counter];
            if (job == -1) {
                ++counter;
                --i3;
            } else {
                p3[i3] = job;
                ++counter;
            }
            ++i3;
        }
        double cost = this.algorithms.computeCost(p3);
        this.memory[targetIndex] = new TspSolution(p3, cost);
    }

    private void pmx(int sourceIndex1, int sourceIndex2, int targetIndex) {
        int[] p1 = this.memory[sourceIndex1].permutation;
        int[] p2 = this.memory[sourceIndex2].permutation;
        if (p1.length <= 1 || p2.length <= 1 || p1.length != p2.length) {
            System.out.println("Error in ox (order crossover) input permutation are not of the same length or one of them is of size <= 1");
            System.exit(0);
        }
        int n = p1.length;
        int point1 = this.rng.nextInt(n);
        int point2 = this.rng.nextInt(n);
        while (point2 == point1) {
            point2 = this.rng.nextInt(n);
        }
        if (point2 < point1) {
            int temp = point1;
            point1 = point2;
            point2 = temp;
        }
        int pointsToCopy = point2 - point1;
        int[] p3 = new int[n];
        Arrays.fill(p3, -1);
        int[] jobsTaken = new int[n];
        int job = p1[point1];
        int i = 0;
        while (i < pointsToCopy) {
            p3[point1 + i] = job = p1[point1 + i];
            jobsTaken[job] = -1;
            ++i;
        }
        int counter = 0;
        int i2 = 0;
        while (i2 < n) {
            if (p3[i2] == -1) {
                job = p2[counter];
                while (jobsTaken[job] == -1) {
                    job = p2[++counter];
                }
                ++counter;
                p3[i2] = job;
            }
            ++i2;
        }
        double cost = this.algorithms.computeCost(p3);
        this.memory[targetIndex] = new TspSolution(p3, cost);
    }

    private void ppx(int sourceIndex1, int sourceIndex2, int targetIndex) {
        int[] p12 = this.memory[sourceIndex1].permutation;
        int[] p22 = this.memory[sourceIndex2].permutation;
        int[] p1 = (int[])p12.clone();
        int[] p2 = (int[])p22.clone();
        int n = p1.length;
        int[] inverseP1 = this.algorithms.inversePermutation(p1);
        int[] inverseP2 = this.algorithms.inversePermutation(p2);
        int counterP1 = 0;
        int counterP2 = 0;
        int[] p3 = new int[n];
        int i = 0;
        while (i < n) {
            int job;
            int randNumb = this.rng.nextInt(2);
            if (randNumb == 0) {
                job = p1[counterP1];
                while (job == -1) {
                    job = p1[++counterP1];
                }
                p3[i] = job;
                p1[counterP1] = -1;
                p2[inverseP2[job]] = -1;
                ++counterP1;
            } else {
                job = p2[counterP2];
                while (job == -1) {
                    job = p2[++counterP2];
                }
                p3[i] = job;
                p2[counterP2] = -1;
                p1[inverseP1[job]] = -1;
                ++counterP2;
            }
            ++i;
        }
        double Cost = this.algorithms.computeCost(p3);
        this.memory[targetIndex] = new TspSolution(p3, Cost);
    }

    private void oneX(int sourceIndex1, int sourceIndex2, int targetIndex) {
        int[] p1 = this.memory[sourceIndex1].permutation;
        int[] p2 = this.memory[sourceIndex2].permutation;
        int n = p1.length;
        int xPoint = this.rng.nextInt(n);
        int[] inv = new int[n];
        int[] p3 = new int[n];
        int i = 0;
        while (i < xPoint) {
            p3[i] = p1[i];
            inv[p1[i]] = 1;
            ++i;
        }
        int count = xPoint;
        int i2 = 0;
        while (i2 < n) {
            if (inv[p2[i2]] != 1) {
                p3[count] = p2[i2];
                ++count;
            }
            ++i2;
        }
        double cost = this.algorithms.computeCost(p3);
        this.memory[targetIndex] = new TspSolution(p3, cost);
    }

    private void verifyBestSolution(TspSolution solution) {
        if (this.bestSoFar == null || solution.Cost < this.bestSoFar.Cost) {
            this.bestSoFar = solution;
        }
    }
}

