/*
 * Decompiled with CFR 0.152.
 */
package travelingSalesmanProblem;

import travelingSalesmanProblem.TspDataStructure;

class TwoLayList
extends TspDataStructure {
    private Node[] list;
    private Parent[] parents;
    private int numbCities;
    private int numbParents;
    private int maxSegmentSize;
    public int sumNodes = 0;
    public int sumFlips = 0;

    public TwoLayList(int[] permutation) {
        Parent tempP;
        this.numbCities = permutation.length;
        this.maxSegmentSize = (int)(0.5 * Math.sqrt(this.numbCities)) + 1;
        this.numbParents = (int)Math.sqrt(this.numbCities);
        int numbCitiesPerSegment = this.numbCities / this.numbParents + 1;
        this.initialiseList(permutation);
        this.initialiseParents(numbCitiesPerSegment);
        int count = 0;
        int i = 0;
        while (i < this.numbParents - 1) {
            tempP = this.parents[i];
            this.list[permutation[count]].parent = tempP;
            tempP.startSegment = this.list[permutation[count]];
            int j = 1;
            while (j < numbCitiesPerSegment) {
                this.list[permutation[count]].parent = tempP;
                ++count;
                ++j;
            }
            tempP.endSegment = this.list[permutation[count - 1]];
            ++i;
        }
        tempP = this.parents[this.numbParents - 1];
        tempP.startSegment = this.list[permutation[count]];
        while (count < this.numbCities) {
            this.list[permutation[count]].parent = tempP;
            ++count;
        }
        tempP.endSegment = this.list[permutation[this.numbCities - 1]];
    }

    public Node next(Node v) {
        if (!v.parent.reverse) {
            return v.next;
        }
        return v.previous;
    }

    public Node prev(Node v) {
        if (!v.parent.reverse) {
            return v.previous;
        }
        return v.next;
    }

    @Override
    public int next(int v) {
        if (!this.list[v].parent.reverse) {
            return this.list[v].next.city;
        }
        return this.list[v].previous.city;
    }

    @Override
    public int prev(int v) {
        if (!this.list[v].parent.reverse) {
            return this.list[v].previous.city;
        }
        return this.list[v].next.city;
    }

    @Override
    public boolean sequence(int a, int b, int c) {
        Parent pa = this.list[a].parent;
        Parent pb = this.list[b].parent;
        Parent pc = this.list[c].parent;
        int pa_id = pa.id;
        int pb_id = pb.id;
        int pc_id = pc.id;
        if (pa != pb && pa != pc && pb != pc) {
            return pa_id < pb_id && pb_id < pc_id || pa_id > pc_id && (pc_id > pb_id || pb_id > pa_id);
        }
        int a_id = this.list[a].id;
        int b_id = this.list[b].id;
        int c_id = this.list[c].id;
        if (pa == pb && pb == pc) {
            if (!pa.reverse) {
                return a_id < b_id && b_id < c_id || a_id > c_id && (c_id > b_id || b_id > a_id);
            }
            return a_id > b_id && b_id > c_id || a_id < c_id && (c_id < b_id || b_id < a_id);
        }
        if (pa == pb) {
            return !pa.reverse ? a_id < b_id : a_id > b_id;
        }
        if (pa == pc) {
            return !pa.reverse ? a_id > c_id : a_id < c_id;
        }
        return !pb.reverse ? b_id < c_id : b_id > c_id;
    }

    @Override
    public void flip(int ib, int id) {
        if (ib == id) {
            return;
        }
        Node b = this.list[ib];
        Node d = this.list[id];
        if (this.next(d) == b || this.prev(b) == this.next(d)) {
            this.reverseTour();
            return;
        }
        Node a = this.prev(b);
        Node c = this.next(d);
        if (b.parent == d.parent) {
            if (c.parent == a.parent) {
                if (b.id < d.id && !b.parent.reverse || b.id > d.id && b.parent.reverse) {
                    if (Math.abs(b.id - d.id) > this.maxSegmentSize) {
                        this.splitAFirst(b);
                        this.splitALast(d);
                    }
                    this.flipSubSegment(b, d);
                } else {
                    if (Math.abs(c.id - a.id) > this.maxSegmentSize) {
                        this.splitAFirst(c);
                        this.splitALast(a);
                    }
                    this.flipSubSegment(c, a);
                    this.reverseTour();
                }
            } else {
                if (Math.abs(b.id - d.id) > this.maxSegmentSize) {
                    this.splitAFirst(b);
                    this.splitALast(d);
                }
                this.flipSubSegment(b, d);
            }
        } else if (c.parent == a.parent) {
            if (Math.abs(c.id - a.id) > this.maxSegmentSize) {
                this.splitAFirst(c);
                this.splitALast(a);
            }
            this.flipSubSegment(c, a);
            this.reverseTour();
        } else if (Math.abs(b.parent.id - d.parent.id) <= Math.abs(a.parent.id - c.parent.id) && d.parent.next != b.parent) {
            if (b.parent.returnStart() != b) {
                this.splitAFirst(b);
            }
            if (b.parent != d.parent && d.parent.returnEnd() != d) {
                this.splitALast(d);
            }
            if (b.parent == d.parent) {
                if (Math.abs(b.id - d.id) > this.maxSegmentSize) {
                    this.splitAFirst(b);
                    this.splitALast(d);
                }
                this.flipSubSegment(b, d);
            } else if (b.parent.id > d.parent.id) {
                this.flipContiguousSegments2(b.parent, d.parent);
            } else {
                this.flipContiguousSegments(b.parent, d.parent);
            }
        } else {
            if (c.parent.returnStart() != c) {
                this.splitAFirst(c);
            }
            if (c.parent != a.parent && a.parent.returnEnd() != a) {
                this.splitALast(a);
            }
            if (c.parent == a.parent) {
                if (Math.abs(c.id - a.id) > this.maxSegmentSize) {
                    this.splitAFirst(c);
                    this.splitALast(a);
                }
                this.flipSubSegment(c, a);
                this.reverseTour();
            } else {
                if (c.parent.id > a.parent.id) {
                    this.flipContiguousSegments2(c.parent, a.parent);
                } else {
                    this.flipContiguousSegments(c.parent, a.parent);
                }
                this.reverseTour();
            }
        }
    }

    @Override
    public String toString(int startCity) {
        int[] pi = this.returnTour(startCity);
        StringBuilder stb = new StringBuilder();
        int i = 0;
        while (i < this.numbCities) {
            stb.append(String.valueOf(pi[i]) + " ");
            ++i;
        }
        return stb.toString();
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    @Override
    public int[] returnTour(int startCity) {
        int[] pi = new int[this.numbCities];
        this.returnTour(startCity, pi);
        return pi;
    }

    @Override
    public void returnTour(int startCity, int[] pi) {
        int count = 0;
        Node start = this.list[startCity];
        Node aux = this.next(start);
        pi[0] = start.city;
        ++count;
        while (aux != start) {
            pi[count] = aux.city;
            aux = this.next(aux);
            ++count;
        }
    }

    private void initialiseList(int[] permutation) {
        this.list = new Node[this.numbCities];
        int i = 0;
        while (i < this.numbCities) {
            this.list[i] = new Node(i);
            ++i;
        }
        i = 0;
        while (i < this.numbCities) {
            this.list[permutation[i]].id = this.numbCities + i;
            ++i;
        }
        this.list[permutation[0]].previous = this.list[permutation[this.numbCities - 1]];
        i = 1;
        while (i < this.numbCities) {
            this.list[permutation[i]].previous = this.list[permutation[i - 1]];
            ++i;
        }
        this.list[permutation[this.numbCities - 1]].next = this.list[permutation[0]];
        i = 0;
        while (i < this.numbCities - 1) {
            this.list[permutation[i]].next = this.list[permutation[i + 1]];
            ++i;
        }
    }

    private void initialiseParents(int size) {
        int smallSize = this.numbCities - (this.numbParents - 1) * size;
        if (smallSize < this.numbParents / 2) {
            --size;
            smallSize += this.numbParents - 1;
        }
        this.parents = new Parent[this.numbParents];
        int i = 0;
        while (i < this.numbParents - 1) {
            this.parents[i] = new Parent(i);
            ++i;
        }
        this.parents[this.numbParents - 1] = new Parent(this.numbParents - 1);
        this.parents[0].previous = this.parents[this.numbParents - 1];
        i = 1;
        while (i < this.numbParents) {
            this.parents[i].previous = this.parents[i - 1];
            ++i;
        }
        this.parents[this.numbParents - 1].next = this.parents[0];
        i = 0;
        while (i < this.numbParents - 1) {
            this.parents[i].next = this.parents[i + 1];
            ++i;
        }
    }

    private void flipSubSegment(Node b, Node d) {
        Node aux;
        ++this.sumFlips;
        this.sumNodes += Math.abs(b.id - d.id);
        Parent p = b.parent;
        if (p.returnStart() == b && p.returnEnd() == d) {
            this.flipSegment(b, d, this.prev(b), this.next(d));
            return;
        }
        if (b.id > d.id) {
            Node c = b;
            b = d;
            d = c;
        }
        Node a = b.previous;
        Node c = d.next;
        if (c.parent.reverse != p.reverse) {
            c.next = b;
            a.next = d;
        } else {
            c.previous = b;
            if (a.parent.reverse != p.reverse) {
                a.previous = d;
            } else {
                a.next = d;
            }
        }
        if (b.next == d) {
            d.previous = a;
            d.next = b;
            b.previous = d;
            b.next = c;
        } else {
            d.next = d.previous;
            aux = d.next;
            while (aux != b) {
                aux.next = aux.previous;
                aux = aux.previous;
            }
            b.next = c;
            d.previous = a;
            aux = d;
            while (aux != b) {
                aux.next.previous = aux;
                aux = aux.next;
            }
        }
        if (p.startSegment == b) {
            p.startSegment = d;
        } else if (p.endSegment == d) {
            p.endSegment = b;
        }
        d.id = b.id;
        aux = d.next;
        while (aux != b) {
            aux.id = aux.previous.id + 1;
            aux = aux.next;
        }
        b.id = b.previous.id + 1;
        this.updateAllRanks(b.parent);
    }

    private void flipSegment(Node b, Node d, Node a, Node c) {
        b.parent.reverse = !b.parent.reverse;
        b.setNext(c);
        c.setPrevious(b);
        d.setPrevious(a);
        a.setNext(d);
    }

    private void flipContiguousSegments(Parent pb, Parent pd) {
        Parent pTemp;
        Node b = pb.returnStart();
        Node c = pd.returnEnd();
        Node a = this.prev(b);
        Node d = this.next(c);
        a.setNext(c);
        b.setPrevious(d);
        c.setNext(a);
        d.setPrevious(b);
        Parent pa = pb.previous;
        Parent pc = pd.next;
        pa.next = pd;
        pc.previous = pb;
        if (pb.next == pd) {
            pb.next = pc;
            pb.previous = pd;
            pd.previous = pa;
            pd.next = pb;
        } else {
            pd.next = pd.previous;
            pTemp = pd.next;
            while (!pTemp.equals(pb)) {
                pTemp.next = pTemp.previous;
                pTemp = pTemp.previous;
            }
            pb.next = pc;
            pd.previous = pa;
            pTemp = pd;
            while (!pTemp.equals(pb)) {
                pTemp.next.previous = pTemp;
                pTemp = pTemp.next;
            }
        }
        pd.id = pb.id;
        pd.reverse = !pd.reverse;
        pTemp = pd.next;
        while (pTemp != pb) {
            pTemp.reverse = !pTemp.reverse;
            pTemp.id = pTemp.previous.id + 1;
            pTemp = pTemp.next;
        }
        pb.id = pb.previous.id + 1;
        pb.reverse = !pb.reverse;
    }

    private void flipContiguousSegments2(Parent pb, Parent pd) {
        Parent pTemp;
        Node b = pb.returnStart();
        Node c = pd.returnEnd();
        Node a = this.prev(b);
        Node d = this.next(c);
        a.setNext(c);
        b.setPrevious(d);
        c.setNext(a);
        d.setPrevious(b);
        Parent pa = pb.previous;
        Parent pc = pd.next;
        pa.next = pd;
        pc.previous = pb;
        if (pb.next == pd) {
            pb.next = pc;
            pb.previous = pd;
            pd.previous = pa;
            pd.next = pb;
        } else {
            pb.previous = pb.next;
            pTemp = pb.next;
            while (!pTemp.equals(pd)) {
                pTemp.previous = pTemp.next;
                pTemp = pTemp.previous;
            }
            pd.previous = pa;
            pb.next = pc;
            pTemp = pb;
            while (!pTemp.equals(pd)) {
                pTemp.previous.next = pTemp;
                pTemp = pTemp.previous;
            }
        }
        this.updateParentRanks();
        pTemp = pb;
        pTemp.reverse = !pTemp.reverse;
        while (pTemp != pd) {
            pTemp.reverse = !(pTemp = pTemp.previous).reverse;
        }
    }

    private void updateParentRanks() {
        Parent start = this.list[0].parent;
        int count = 0;
        start.id = count;
        Parent aux = start.next;
        while (aux != start) {
            aux.id = ++count;
            aux = aux.next;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void splitAFirst(Node a) {
        block12: {
            block14: {
                block13: {
                    block9: {
                        block11: {
                            block10: {
                                if (Math.abs(Node.access$5(Parent.access$5(Node.access$1(a))) - Node.access$5(a)) > Math.abs(Node.access$5(Parent.access$6(Node.access$1(a))) - Node.access$5(a)) + 1) break block9;
                                aux = Parent.access$5(Node.access$1(a));
                                pTemp = Parent.access$13(Node.access$1(aux));
                                aux2 = Parent.access$6(pTemp);
                                if (!Parent.access$0(Node.access$1(aux))) break block10;
                                if (Parent.access$0(Node.access$1(aux)) != Parent.access$0(pTemp)) ** GOTO lbl17
                                while (aux != a) {
                                    Node.access$0(aux, pTemp);
                                    aux = Node.access$3(aux);
                                }
                                break block11;
lbl-1000:
                                // 1 sources

                                {
                                    Node.access$0(aux, pTemp);
                                    aux3 = Node.access$2(aux);
                                    Node.access$9(aux, Node.access$3(aux));
                                    Node.access$8(aux, aux3);
                                    aux = Node.access$2(aux);
lbl17:
                                    // 2 sources

                                    ** while (aux != a)
                                }
lbl18:
                                // 1 sources

                                break block11;
                            }
                            if (Parent.access$0(Node.access$1(aux)) != Parent.access$0(pTemp)) ** GOTO lbl31
                            while (aux != a) {
                                Node.access$0(aux, pTemp);
                                aux = Node.access$2(aux);
                            }
                            break block11;
lbl-1000:
                            // 1 sources

                            {
                                Node.access$0(aux, pTemp);
                                aux3 = Node.access$2(aux);
                                Node.access$9(aux, Node.access$3(aux));
                                Node.access$8(aux, aux3);
                                aux = Node.access$3(aux);
lbl31:
                                // 2 sources

                                ** while (aux != a)
                            }
                        }
                        pTemp.setEnd(this.prev(aux));
                        Parent.access$15(Node.access$1(a), a);
                        this.updateRanksForw(aux2);
                        break block12;
                    }
                    aux = Parent.access$6(Node.access$1(a));
                    pTemp = Parent.access$4(Node.access$1(aux));
                    aux2 = Parent.access$5(pTemp);
                    if (!Parent.access$0(Node.access$1(aux))) break block13;
                    if (Parent.access$0(Node.access$1(aux)) != Parent.access$0(pTemp)) ** GOTO lbl53
                    while (aux != a) {
                        Node.access$0(aux, pTemp);
                        aux = Node.access$2(aux);
                    }
                    break block14;
lbl-1000:
                    // 1 sources

                    {
                        Node.access$0(aux, pTemp);
                        aux3 = Node.access$2(aux);
                        Node.access$9(aux, Node.access$3(aux));
                        Node.access$8(aux, aux3);
                        aux = Node.access$3(aux);
lbl53:
                        // 2 sources

                        ** while (aux != a)
                    }
lbl54:
                    // 1 sources

                    break block14;
                }
                if (Parent.access$0(Node.access$1(aux)) != Parent.access$0(pTemp)) ** GOTO lbl67
                while (aux != a) {
                    Node.access$0(aux, pTemp);
                    aux = Node.access$3(aux);
                }
                break block14;
lbl-1000:
                // 1 sources

                {
                    Node.access$0(aux, pTemp);
                    aux3 = Node.access$2(aux);
                    Node.access$9(aux, Node.access$3(aux));
                    Node.access$8(aux, aux3);
                    aux = Node.access$2(aux);
lbl67:
                    // 2 sources

                    ** while (aux != a)
                }
            }
            Node.access$1(a).setEnd(this.prev(a));
            if (Parent.access$0(Node.access$1(a)) != Parent.access$0(pTemp)) {
                aux = Node.access$2(a);
                Node.access$9(a, Node.access$3(a));
                Node.access$8(a, aux);
            }
            Node.access$0(a, pTemp);
            Parent.access$15(Node.access$1(a), a);
            this.updateRanksBack(aux2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void splitALast(Node a) {
        block12: {
            block14: {
                block13: {
                    block9: {
                        block11: {
                            block10: {
                                if (Math.abs(Node.access$5(Parent.access$5(Node.access$1(a))) - Node.access$5(a)) + 1 > Math.abs(Node.access$5(Parent.access$6(Node.access$1(a))) - Node.access$5(a))) break block9;
                                aux = Parent.access$5(Node.access$1(a));
                                pTemp = Parent.access$13(Node.access$1(aux));
                                aux2 = Parent.access$6(pTemp);
                                if (!Parent.access$0(Node.access$1(aux))) break block10;
                                if (Parent.access$0(Node.access$1(aux)) != Parent.access$0(pTemp)) ** GOTO lbl17
                                while (aux != a) {
                                    Node.access$0(aux, pTemp);
                                    aux = Node.access$3(aux);
                                }
                                break block11;
lbl-1000:
                                // 1 sources

                                {
                                    Node.access$0(aux, pTemp);
                                    aux3 = Node.access$2(aux);
                                    Node.access$9(aux, Node.access$3(aux));
                                    Node.access$8(aux, aux3);
                                    aux = Node.access$2(aux);
lbl17:
                                    // 2 sources

                                    ** while (aux != a)
                                }
lbl18:
                                // 1 sources

                                break block11;
                            }
                            if (Parent.access$0(Node.access$1(aux)) != Parent.access$0(pTemp)) ** GOTO lbl31
                            while (aux != a) {
                                Node.access$0(aux, pTemp);
                                aux = Node.access$2(aux);
                            }
                            break block11;
lbl-1000:
                            // 1 sources

                            {
                                Node.access$0(aux, pTemp);
                                aux3 = Node.access$2(aux);
                                Node.access$9(aux, Node.access$3(aux));
                                Node.access$8(aux, aux3);
                                aux = Node.access$3(aux);
lbl31:
                                // 2 sources

                                ** while (aux != a)
                            }
                        }
                        Parent.access$15(Node.access$1(a), this.next(a));
                        if (Parent.access$0(Node.access$1(a)) != Parent.access$0(pTemp)) {
                            aux = Node.access$2(a);
                            Node.access$9(a, Node.access$3(a));
                            Node.access$8(a, aux);
                        }
                        Node.access$0(a, pTemp);
                        pTemp.setEnd(a);
                        this.updateRanksForw(aux2);
                        break block12;
                    }
                    aux = Parent.access$6(Node.access$1(a));
                    pTemp = Parent.access$4(Node.access$1(aux));
                    aux2 = Parent.access$5(pTemp);
                    if (!Parent.access$0(Node.access$1(aux))) break block13;
                    if (Parent.access$0(Node.access$1(aux)) != Parent.access$0(pTemp)) ** GOTO lbl58
                    while (aux != a) {
                        Node.access$0(aux, pTemp);
                        aux = Node.access$2(aux);
                    }
                    break block14;
lbl-1000:
                    // 1 sources

                    {
                        Node.access$0(aux, pTemp);
                        aux3 = Node.access$2(aux);
                        Node.access$9(aux, Node.access$3(aux));
                        Node.access$8(aux, aux3);
                        aux = Node.access$3(aux);
lbl58:
                        // 2 sources

                        ** while (aux != a)
                    }
lbl59:
                    // 1 sources

                    break block14;
                }
                if (Parent.access$0(Node.access$1(aux)) != Parent.access$0(pTemp)) ** GOTO lbl72
                while (aux != a) {
                    Node.access$0(aux, pTemp);
                    aux = Node.access$3(aux);
                }
                break block14;
lbl-1000:
                // 1 sources

                {
                    Node.access$0(aux, pTemp);
                    aux3 = Node.access$2(aux);
                    Node.access$9(aux, Node.access$3(aux));
                    Node.access$8(aux, aux3);
                    aux = Node.access$2(aux);
lbl72:
                    // 2 sources

                    ** while (aux != a)
                }
            }
            Parent.access$15(pTemp, this.next(a));
            Node.access$1(a).setEnd(a);
            this.updateRanksBack(aux2);
        }
    }

    private void updateRanksForw(Node a) {
        if (!a.parent.reverse) {
            Node aux = a;
            Node end = a.parent.endSegment;
            int count = a.id;
            while (aux != end) {
                aux.id = count;
                aux = aux.next;
                ++count;
            }
            end.id = count;
        } else {
            Node aux = a;
            Node end = a.parent.startSegment;
            int count = a.id;
            while (aux != end) {
                aux.id = count;
                aux = aux.previous;
                --count;
            }
            end.id = count;
        }
    }

    private void updateRanksBack(Node a) {
        if (!a.parent.reverse) {
            Node aux = a;
            Node end = a.parent.startSegment;
            int count = a.id;
            while (aux != end) {
                aux.id = count;
                aux = aux.previous;
                --count;
            }
            end.id = count;
        } else {
            Node aux = a;
            Node end = a.parent.endSegment;
            int count = a.id;
            while (aux != end) {
                aux.id = count;
                aux = aux.next;
                ++count;
            }
            end.id = count;
        }
    }

    private void reverseTour() {
        Parent temp;
        int i = 0;
        while (i < this.numbParents) {
            temp = this.parents[i];
            Parent temp2 = temp.previous;
            temp.previous = temp.next;
            temp.next = temp2;
            temp.reverse = !temp.reverse;
            ++i;
        }
        int count = 0;
        this.parents[0].id = count;
        temp = this.parents[0].next;
        while (temp != this.parents[0]) {
            temp.id = ++count;
            temp = temp.next;
        }
    }

    private void updateAllRanks(Parent parent) {
        Node aux = parent.startSegment;
        Node end = parent.endSegment;
        int count = this.numbCities;
        while (aux != end) {
            aux.id = count;
            aux = aux.next;
            ++count;
        }
        end.id = count;
    }

    public int[] getSegmentSizes() {
        int[] segSizes = new int[this.numbParents];
        int i = 0;
        while (i < this.numbParents) {
            segSizes[i] = Math.abs(this.parents[i].startSegment.id - this.parents[i].endSegment.id);
            ++i;
        }
        return segSizes;
    }

    public int getNumbParents() {
        return this.numbParents;
    }

    public boolean verifyEnumeration() {
        int count = 0;
        int count2 = 0;
        int i = 0;
        while (i < this.numbParents) {
            Parent p = this.parents[i];
            count2 = count = p.startSegment.id;
            Node next = p.startSegment.next;
            while (next != p.endSegment && p.startSegment != p.endSegment) {
                if (next.id != ++count && next.id != --count2) {
                    return false;
                }
                next = next.next;
            }
            ++i;
        }
        return true;
    }

    private class Node {
        private int id;
        private int city;
        private Node previous;
        private Node next;
        private Parent parent;

        private Node(int city) {
            this.city = city;
        }

        private void setNext(Node next) {
            if (this.parent.reverse) {
                this.previous = next;
                return;
            }
            this.next = next;
        }

        private void setPrevious(Node previous) {
            if (this.parent.reverse) {
                this.next = previous;
                return;
            }
            this.previous = previous;
        }
    }

    private class Parent {
        private boolean reverse;
        private int id;
        private Parent previous;
        private Parent next;
        private Node startSegment;
        private Node endSegment;

        private Parent(int id) {
            this.id = id;
            this.reverse = false;
        }

        private Node returnStart() {
            if (this.reverse) {
                return this.endSegment;
            }
            return this.startSegment;
        }

        private Node returnEnd() {
            if (this.reverse) {
                return this.startSegment;
            }
            return this.endSegment;
        }

        private void setStart(Node a) {
            if (this.reverse) {
                this.endSegment = a;
            } else {
                this.startSegment = a;
            }
        }

        void setEnd(Node a) {
            if (this.reverse) {
                this.startSegment = a;
            } else {
                this.endSegment = a;
            }
        }

        static /* synthetic */ void access$15(Parent parent, Node node) {
            parent.setStart(node);
        }
    }
}

