/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.ANROM;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;

public class MaxAssignmentsForDayOfWeek
implements SoftConstraint {
    public String Title = "Max shifts for days of the week";
    public String LongTitle = "";
    public int Weight = 0;
    public String ID = "";

    public MaxAssignmentsForDayOfWeek(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        boolean required = false;
        String info = "";
        if (employee.EmployeeDescription.Contract.MaxAssignmentsForAllMondaysIsOn) {
            required = true;
            info = "Max total assignments for all Mondays = " + employee.EmployeeDescription.Contract.MaxAssignmentsForAllMondays;
        }
        if (employee.EmployeeDescription.Contract.MaxAssignmentsForAllTuesdaysIsOn) {
            if (required) {
                info = String.valueOf(info) + "<br/>";
            } else {
                required = true;
            }
            info = String.valueOf(info) + "Max total assignments for all Tuesdays = " + employee.EmployeeDescription.Contract.MaxAssignmentsForAllTuesdays;
        }
        if (employee.EmployeeDescription.Contract.MaxAssignmentsForAllWednesdaysIsOn) {
            if (required) {
                info = String.valueOf(info) + "<br/>";
            } else {
                required = true;
            }
            info = String.valueOf(info) + "Max total assignments for all Wednesdays = " + employee.EmployeeDescription.Contract.MaxAssignmentsForAllWednesdays;
        }
        if (employee.EmployeeDescription.Contract.MaxAssignmentsForAllThursdaysIsOn) {
            if (required) {
                info = String.valueOf(info) + "<br/>";
            } else {
                required = true;
            }
            info = String.valueOf(info) + "Max total assignments for all Thursdays = " + employee.EmployeeDescription.Contract.MaxAssignmentsForAllThursdays;
        }
        if (employee.EmployeeDescription.Contract.MaxAssignmentsForAllFridaysIsOn) {
            if (required) {
                info = String.valueOf(info) + "<br/>";
            } else {
                required = true;
            }
            info = String.valueOf(info) + "Max total assignments for all Fridays = " + employee.EmployeeDescription.Contract.MaxAssignmentsForAllFridays;
        }
        if (employee.EmployeeDescription.Contract.MaxAssignmentsForAllSaturdaysIsOn) {
            if (required) {
                info = String.valueOf(info) + "<br/>";
            } else {
                required = true;
            }
            info = String.valueOf(info) + "Max total assignments for all Saturdays = " + employee.EmployeeDescription.Contract.MaxAssignmentsForAllSaturdays;
        }
        if (employee.EmployeeDescription.Contract.MaxAssignmentsForAllSundaysIsOn) {
            if (required) {
                info = String.valueOf(info) + "<br/>";
            } else {
                required = true;
            }
            info = String.valueOf(info) + "Max total assignments for all Sundays = " + employee.EmployeeDescription.Contract.MaxAssignmentsForAllSundays;
        }
        return info;
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        int day;
        int numDaysInPeriod;
        int pen;
        int max;
        int sun;
        int sat;
        int fri;
        int thu;
        int wed;
        int tue;
        int mon;
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int day1 = 0;
        int day2 = 0;
        int day3 = 0;
        int day4 = 0;
        int day5 = 0;
        int day6 = 0;
        int day7 = 0;
        int numDays = employee.ShiftCountPerDay.length;
        int i = 0;
        while (i < numDays) {
            day1 += employee.ShiftCountPerDay[i];
            if (i + 1 < numDays) {
                day2 += employee.ShiftCountPerDay[i + 1];
            }
            if (i + 2 < numDays) {
                day3 += employee.ShiftCountPerDay[i + 2];
            }
            if (i + 3 < numDays) {
                day4 += employee.ShiftCountPerDay[i + 3];
            }
            if (i + 4 < numDays) {
                day5 += employee.ShiftCountPerDay[i + 4];
            }
            if (i + 5 < numDays) {
                day6 += employee.ShiftCountPerDay[i + 5];
            }
            if (i + 6 < numDays) {
                day7 += employee.ShiftCountPerDay[i + 6];
            }
            i += 7;
        }
        switch (schedulingPeriod.StartDate.getDayOfWeek()) {
            case 2: {
                mon = day1;
                tue = day2;
                wed = day3;
                thu = day4;
                fri = day5;
                sat = day6;
                sun = day7;
                break;
            }
            case 3: {
                mon = day7;
                tue = day1;
                wed = day2;
                thu = day3;
                fri = day4;
                sat = day5;
                sun = day6;
                break;
            }
            case 4: {
                mon = day6;
                tue = day7;
                wed = day1;
                thu = day2;
                fri = day3;
                sat = day4;
                sun = day5;
                break;
            }
            case 5: {
                mon = day5;
                tue = day6;
                wed = day7;
                thu = day1;
                fri = day2;
                sat = day3;
                sun = day4;
                break;
            }
            case 6: {
                mon = day4;
                tue = day5;
                wed = day6;
                thu = day7;
                fri = day1;
                sat = day2;
                sun = day3;
                break;
            }
            case 7: {
                mon = day3;
                tue = day4;
                wed = day5;
                thu = day6;
                fri = day7;
                sat = day1;
                sun = day2;
                break;
            }
            case 1: {
                mon = day2;
                tue = day3;
                wed = day4;
                thu = day5;
                fri = day6;
                sat = day7;
                sun = day1;
                break;
            }
            default: {
                mon = day1;
                tue = day2;
                wed = day3;
                thu = day4;
                fri = day5;
                sat = day6;
                sun = day7;
            }
        }
        if (employee.EmployeeDescription.Contract.MaxAssignmentsForAllMondaysIsOn && mon > (max = employee.EmployeeDescription.Contract.MaxAssignmentsForAllMondays)) {
            pen = this.Weight * (mon - max);
            penalty += pen;
            numDaysInPeriod = schedulingPeriod.NumDaysInPeriod;
            day = schedulingPeriod.FirstMonday;
            while (day > 0 && day < numDaysInPeriod) {
                if (employee.DayType[day] == 1) {
                    int n = day;
                    employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                    if (SoftConstraints.UpdateViolationDescriptions) {
                        int n2 = day;
                        employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Too many assignments for all Mondays (requests max " + max + ", receives " + mon + "). " + System.getProperty("line.separator");
                    }
                }
                day += 7;
            }
        }
        if (employee.EmployeeDescription.Contract.MaxAssignmentsForAllTuesdaysIsOn && tue > (max = employee.EmployeeDescription.Contract.MaxAssignmentsForAllTuesdays)) {
            pen = this.Weight * (tue - max);
            penalty += pen;
            numDaysInPeriod = schedulingPeriod.NumDaysInPeriod;
            day = schedulingPeriod.FirstTuesday;
            while (day > 0 && day < numDaysInPeriod) {
                if (employee.DayType[day] == 1) {
                    int n = day;
                    employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                    if (SoftConstraints.UpdateViolationDescriptions) {
                        int n3 = day;
                        employee.ViolationDescriptions[n3] = String.valueOf(employee.ViolationDescriptions[n3]) + "Too many assignments for all Tuesdays (requests max " + max + ", receives " + tue + "). " + System.getProperty("line.separator");
                    }
                }
                day += 7;
            }
        }
        if (employee.EmployeeDescription.Contract.MaxAssignmentsForAllWednesdaysIsOn && wed > (max = employee.EmployeeDescription.Contract.MaxAssignmentsForAllWednesdays)) {
            pen = this.Weight * (wed - max);
            penalty += pen;
            numDaysInPeriod = schedulingPeriod.NumDaysInPeriod;
            day = schedulingPeriod.FirstWednesday;
            while (day > 0 && day < numDaysInPeriod) {
                if (employee.DayType[day] == 1) {
                    int n = day;
                    employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                    if (SoftConstraints.UpdateViolationDescriptions) {
                        int n4 = day;
                        employee.ViolationDescriptions[n4] = String.valueOf(employee.ViolationDescriptions[n4]) + "Too many assignments for all Wednesdays (requests max " + max + ", receives " + wed + "). " + System.getProperty("line.separator");
                    }
                }
                day += 7;
            }
        }
        if (employee.EmployeeDescription.Contract.MaxAssignmentsForAllThursdaysIsOn && thu > (max = employee.EmployeeDescription.Contract.MaxAssignmentsForAllThursdays)) {
            pen = this.Weight * (thu - max);
            penalty += pen;
            numDaysInPeriod = schedulingPeriod.NumDaysInPeriod;
            day = schedulingPeriod.FirstThursday;
            while (day > 0 && day < numDaysInPeriod) {
                if (employee.DayType[day] == 1) {
                    int n = day;
                    employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                    if (SoftConstraints.UpdateViolationDescriptions) {
                        int n5 = day;
                        employee.ViolationDescriptions[n5] = String.valueOf(employee.ViolationDescriptions[n5]) + "Too many assignments for all Thursdays (requests max " + max + ", receives " + thu + "). " + System.getProperty("line.separator");
                    }
                }
                day += 7;
            }
        }
        if (employee.EmployeeDescription.Contract.MaxAssignmentsForAllFridaysIsOn && fri > (max = employee.EmployeeDescription.Contract.MaxAssignmentsForAllFridays)) {
            pen = this.Weight * (fri - max);
            penalty += pen;
            numDaysInPeriod = schedulingPeriod.NumDaysInPeriod;
            day = schedulingPeriod.FirstFriday;
            while (day > 0 && day < numDaysInPeriod) {
                if (employee.DayType[day] == 1) {
                    int n = day;
                    employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                    if (SoftConstraints.UpdateViolationDescriptions) {
                        int n6 = day;
                        employee.ViolationDescriptions[n6] = String.valueOf(employee.ViolationDescriptions[n6]) + "Too many assignments for all Fridays (requests max " + max + ", receives " + fri + "). " + System.getProperty("line.separator");
                    }
                }
                day += 7;
            }
        }
        if (employee.EmployeeDescription.Contract.MaxAssignmentsForAllSaturdaysIsOn && sat > (max = employee.EmployeeDescription.Contract.MaxAssignmentsForAllSaturdays)) {
            pen = this.Weight * (sat - max);
            penalty += pen;
            numDaysInPeriod = schedulingPeriod.NumDaysInPeriod;
            day = schedulingPeriod.FirstSaturday;
            while (day > 0 && day < numDaysInPeriod) {
                if (employee.DayType[day] == 1) {
                    int n = day;
                    employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                    if (SoftConstraints.UpdateViolationDescriptions) {
                        int n7 = day;
                        employee.ViolationDescriptions[n7] = String.valueOf(employee.ViolationDescriptions[n7]) + "Too many assignments for all Saturdays (requests max " + max + ", receives " + sat + "). " + System.getProperty("line.separator");
                    }
                }
                day += 7;
            }
        }
        if (employee.EmployeeDescription.Contract.MaxAssignmentsForAllSundaysIsOn && sun > (max = employee.EmployeeDescription.Contract.MaxAssignmentsForAllSundays)) {
            pen = this.Weight * (sun - max);
            penalty += pen;
            numDaysInPeriod = schedulingPeriod.NumDaysInPeriod;
            day = schedulingPeriod.FirstSunday;
            while (day > 0 && day < numDaysInPeriod) {
                if (employee.DayType[day] == 1) {
                    int n = day;
                    employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                    if (SoftConstraints.UpdateViolationDescriptions) {
                        int n8 = day;
                        employee.ViolationDescriptions[n8] = String.valueOf(employee.ViolationDescriptions[n8]) + "Too many assignments for all Sundays (requests max " + max + ", receives " + sun + "). " + System.getProperty("line.separator");
                    }
                }
                day += 7;
            }
        }
        return penalty;
    }
}

