/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.ANROM;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;

public class MaxNumAssignments
implements SoftConstraint {
    public String Title = "Max number of shifts";
    public String LongTitle = "Maximum number of shifts that may be assigned in this scheduling period";
    public int Weight = 0;
    public String ID = "ANROM.MaxNumAssignments";

    public MaxNumAssignments(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
        employee.Contract.MaxNumAssignmentsIsOn = false;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "<MaxNumAssignments Weight=\"" + this.Weight + "\">" + employee.Contract.MaxNumAssignments + "</MaxNumAssignments>" + System.getProperty("line.separator");
    }

    @Override
    public String GetDescription(Employee employee) {
        return "Requests max " + employee.EmployeeDescription.Contract.MaxNumAssignments + " shifts, receives " + employee.ShiftsCount;
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int maxPermitted = employee.EmployeeDescription.Contract.MaxNumAssignments;
        int numAssignments = employee.ShiftsCount;
        int numDaysInPlanningPeriod = schedulingPeriod.NumDaysInPeriod;
        int numAbsenceDays = 0;
        if (numAssignments > (maxPermitted *= (numDaysInPlanningPeriod - numAbsenceDays) / numDaysInPlanningPeriod)) {
            penalty = (numAssignments - maxPermitted) * this.Weight;
            int day = 0;
            while (day < numDaysInPlanningPeriod) {
                if (employee.ShiftCountPerDay[day] > 0) {
                    int n = day;
                    employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + penalty;
                    if (SoftConstraints.UpdateViolationDescriptions) {
                        int n2 = day;
                        employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Too many shifts (max " + maxPermitted + "). " + System.getProperty("line.separator");
                    }
                }
                ++day;
            }
        }
        return penalty;
    }
}

