/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.ANROM;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;

public class MinConsecutiveWorkingDays
implements SoftConstraint {
    public String Title = "Min consecutive working days";
    public String LongTitle = "Minimum number of consecutive working days";
    public int Weight = 0;
    public String ID = "ANROM.MinConsecutiveWorkingDays";

    public MinConsecutiveWorkingDays(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
        employee.Contract.MinConsecutiveWorkingDaysIsOn = false;
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "<MinConsecutiveWorkingDays Weight=\"" + this.Weight + "\">" + employee.Contract.MinConsecutiveWorkingDays + "</MinConsecutiveWorkingDays>" + System.getProperty("line.separator");
    }

    @Override
    public String GetDescription(Employee employee) {
        return "Requests min " + employee.EmployeeDescription.Contract.MinConsecutiveWorkingDays + " consecutive working days.";
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int minConsecutiveWorkingDays = employee.EmployeeDescription.Contract.MinConsecutiveWorkingDays;
        int consecutiveWorkingDays = employee.EmployeeDescription.SchedulingHistory.PreviousConsecutiveWorkingDays;
        int numDaysInPeriod = schedulingPeriod.NumDaysInPeriod;
        int i = 0;
        while (i < numDaysInPeriod) {
            if (employee.DayType[i] != 1 && !employee.EmployeeDescription.DayOffRequestIsWork[i]) {
                if (consecutiveWorkingDays != 0 && consecutiveWorkingDays < minConsecutiveWorkingDays) {
                    int end;
                    int extra = minConsecutiveWorkingDays - consecutiveWorkingDays;
                    int pen = this.Weight * extra;
                    penalty += pen;
                    int j = end = i - 1 + extra;
                    while (j >= 0 && j > end - (consecutiveWorkingDays + extra + extra)) {
                        if (j < numDaysInPeriod) {
                            int n = j;
                            employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                            if (SoftConstraints.UpdateViolationDescriptions) {
                                int n2 = j;
                                employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Too few consecutive working days (min " + minConsecutiveWorkingDays + "). " + System.getProperty("line.separator");
                            }
                        }
                        --j;
                    }
                }
                consecutiveWorkingDays = 0;
            } else {
                ++consecutiveWorkingDays;
            }
            ++i;
        }
        return penalty;
    }
}

