/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.ANROM;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;

public class MinHoursWorked
implements SoftConstraint {
    public String Title = "Min hours worked";
    public String LongTitle = "Minimum number of hours the employee can work";
    public int Weight = 0;
    public String ID = "ANROM.MinHoursWorked";

    public MinHoursWorked(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
        employee.Contract.MinHoursWorkedIsOn = false;
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        return "Requests min " + employee.EmployeeDescription.Contract.MinHoursWorked + " hours.";
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        int penalty = 0;
        double standardPeformance = employee.EmployeeDescription.Contract.StandardPerformance;
        int numDaysOff = employee.HolidayDaysOffGranted;
        double x = employee.EmployeeDescription.Contract.MinHoursWorked - standardPeformance * (double)numDaysOff;
        double previousHoursWorked = employee.EmployeeDescription.SchedulingHistory.PreviousOvertime;
        double y = previousHoursWorked + employee.HoursWorked;
        double diff = x - y;
        if (diff > employee.EmployeeDescription.Contract.MinHoursWorkedThreshold) {
            penalty = this.Weight * (int)diff;
        }
        return penalty;
    }
}

