/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.ANROM;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;

public class NumConsecutiveShiftTypes
implements SoftConstraint {
    public String Title = "Number of consecutive shift types";
    public String LongTitle = "";
    public int Weight = 0;
    public String ID = "";

    public NumConsecutiveShiftTypes(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        String info = "Valid lengths of sequences of consecutive shift types:";
        int shiftIndex = 0;
        while (shiftIndex < employee.Roster.SchedulingPeriod.ShiftTypesCount) {
            String ShiftTypeID = employee.Roster.SchedulingPeriod.GetShiftType((int)shiftIndex).ID;
            info = String.valueOf(info) + "<br/>" + ShiftTypeID + " : ";
            int i = 0;
            while (i < employee.EmployeeDescription.Contract.ValidNumConsecutiveShiftTypes[shiftIndex].length) {
                int j = i + 1;
                if (employee.EmployeeDescription.Contract.ValidNumConsecutiveShiftTypes[shiftIndex][i]) {
                    info = String.valueOf(info) + j + ", ";
                }
                ++i;
            }
            ++shiftIndex;
        }
        return info;
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int shiftTypeCount = schedulingPeriod.ShiftTypesCount;
        int previousConsecutiveDaysOff = employee.EmployeeDescription.SchedulingHistory.PreviousConsecutiveHolidayDaysOff;
        int shiftIndex = 0;
        while (shiftIndex < schedulingPeriod.ShiftTypesCount) {
            int consDays = employee.EmployeeDescription.SchedulingHistory.PreviousConsecutiveShifts[shiftIndex];
            int consDaysOff = previousConsecutiveDaysOff;
            int numDaysInPeriod = schedulingPeriod.NumDaysInPeriod;
            int i = 0;
            while (i < numDaysInPeriod) {
                int index = shiftTypeCount * i + shiftIndex;
                if (employee.ShiftAssignments[index]) {
                    ++consDays;
                } else if (employee.DayType[i] == 2) {
                    ++consDaysOff;
                } else {
                    boolean permitted = false;
                    int j = consDays;
                    while (j <= consDays + consDaysOff && j <= employee.EmployeeDescription.Contract.ValidNumConsecutiveShiftTypes[shiftIndex].length && j > 0) {
                        if (employee.EmployeeDescription.Contract.ValidNumConsecutiveShiftTypes[shiftIndex][j - 1]) {
                            permitted = true;
                            break;
                        }
                        ++j;
                    }
                    if (!permitted && consDays != 0) {
                        penalty += this.Weight;
                        int k = i - 1;
                        while (k >= 0 && k >= i - consDays + consDaysOff) {
                            int n = k;
                            employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + this.Weight;
                            if (SoftConstraints.UpdateViolationDescriptions) {
                                String ID = schedulingPeriod.GetShiftType((int)shiftIndex).ID;
                                int n2 = k;
                                employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Invalid length of consecutive '" + ID + "' shifts. " + System.getProperty("line.separator");
                            }
                            --k;
                        }
                    }
                    consDays = 0;
                    consDaysOff = 0;
                }
                ++i;
            }
            ++shiftIndex;
        }
        return penalty;
    }
}

