/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.Azaiez;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;

public class MaxWeekendDays
implements SoftConstraint {
    public String Title = "Max weekend days on";
    public String LongTitle = "Max weekend days on";
    public int Weight = 0;
    public String ID = "Azaiez.MaxWeekendDays";

    public MaxWeekendDays(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        return "Requests max " + employee.EmployeeDescription.Contract.MaxWeekendDays + " weekend days (Sat and Sun) on";
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        int sun;
        int sat;
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int day1 = 0;
        int day2 = 0;
        int day3 = 0;
        int day4 = 0;
        int day5 = 0;
        int day6 = 0;
        int day7 = 0;
        int numDays = employee.ShiftCountPerDay.length;
        int i = 0;
        while (i < numDays) {
            day1 += employee.ShiftCountPerDay[i];
            if (i + 1 < numDays) {
                day2 += employee.ShiftCountPerDay[i + 1];
            }
            if (i + 2 < numDays) {
                day3 += employee.ShiftCountPerDay[i + 2];
            }
            if (i + 3 < numDays) {
                day4 += employee.ShiftCountPerDay[i + 3];
            }
            if (i + 4 < numDays) {
                day5 += employee.ShiftCountPerDay[i + 4];
            }
            if (i + 5 < numDays) {
                day6 += employee.ShiftCountPerDay[i + 5];
            }
            if (i + 6 < numDays) {
                day7 += employee.ShiftCountPerDay[i + 6];
            }
            i += 7;
        }
        switch (schedulingPeriod.StartDate.getDayOfWeek()) {
            case 2: {
                sat = day6;
                sun = day7;
                break;
            }
            case 3: {
                sat = day5;
                sun = day6;
                break;
            }
            case 4: {
                sat = day4;
                sun = day5;
                break;
            }
            case 5: {
                sat = day3;
                sun = day4;
                break;
            }
            case 6: {
                sat = day2;
                sun = day3;
                break;
            }
            case 7: {
                sat = day1;
                sun = day2;
                break;
            }
            case 1: {
                sat = day7;
                sun = day1;
                break;
            }
            default: {
                sat = day6;
                sun = day7;
            }
        }
        int max = employee.EmployeeDescription.Contract.MaxWeekendDays;
        int tot = sat + sun;
        if (tot > max) {
            int pen = this.Weight * (tot - max);
            penalty += pen;
            int numDaysInPeriod = schedulingPeriod.NumDaysInPeriod;
            int day = schedulingPeriod.FirstSaturday;
            while (day > 0 && day < numDaysInPeriod) {
                if (employee.DayType[day] == 1) {
                    int n = day;
                    employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                    if (SoftConstraints.UpdateViolationDescriptions) {
                        int n2 = day;
                        employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Too many assignments on weekend days (requests max " + max + ", receives " + tot + "). \n";
                    }
                }
                day += 7;
            }
            day = schedulingPeriod.FirstSunday;
            while (day > 0 && day < numDaysInPeriod) {
                if (employee.DayType[day] == 1) {
                    int n = day;
                    employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                    if (SoftConstraints.UpdateViolationDescriptions) {
                        int n3 = day;
                        employee.ViolationDescriptions[n3] = String.valueOf(employee.ViolationDescriptions[n3]) + "Too many assignments on weekend days (requests max " + max + ", receives " + tot + "). \n";
                    }
                }
                day += 7;
            }
        }
        return penalty;
    }
}

