/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.GPost;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;

public class MaxShiftsPerDay
implements SoftConstraint {
    public String Title = "Max shifts per day";
    public String LongTitle = "Maximum number of shifts per day";
    public int Weight = 0;
    public String ID = "GPost.MaxShiftsPerDay";

    public MaxShiftsPerDay(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
        employee.Contract.MaxShiftsPerDayIsOn = false;
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "<MaxShiftsPerDay Weight=\"" + this.Weight + "\">" + employee.Contract.MaxShiftsPerDay + "</MaxShiftsPerDay>" + System.getProperty("line.separator");
    }

    @Override
    public String GetDescription(Employee employee) {
        return "Requests max " + employee.EmployeeDescription.Contract.MaxShiftsPerDay + " shifts a day.";
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int numDaysInPeriod = schedulingPeriod.NumDaysInPeriod;
        int max = employee.EmployeeDescription.Contract.MaxShiftsPerDay;
        int i = 0;
        while (i < numDaysInPeriod) {
            if (employee.ShiftCountPerDay[i] > max) {
                int pen = this.Weight * (employee.ShiftCountPerDay[i] - max);
                penalty += pen;
                int n = i;
                employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                if (SoftConstraints.UpdateViolationDescriptions) {
                    int n2 = i;
                    employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Too many shifts on this day (max " + max + "). " + System.getProperty("line.separator");
                }
            }
            ++i;
        }
        return penalty;
    }
}

