/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.GPost;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;

public class MinShiftsPerWeek
implements SoftConstraint {
    public String Title = "Min shifts per week";
    public String LongTitle = "Minimum number of shifts per week";
    public int Weight = 0;
    public String ID = "GPost.MinShiftsPerWeek";

    public MinShiftsPerWeek(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
        employee.Contract.MinShiftsPerWeekIsOn = false;
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "<MinShiftsPerWeek Weight=\"" + this.Weight + "\">" + employee.Contract.MinShiftsPerWeek + "</MinShiftsPerWeek>" + System.getProperty("line.separator");
    }

    @Override
    public String GetDescription(Employee employee) {
        return "Requests min " + employee.EmployeeDescription.Contract.MinShiftsPerWeek + " shifts per week.";
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int min = employee.EmployeeDescription.Contract.MinShiftsPerWeek;
        int i = 0;
        while (i < schedulingPeriod.NumDaysInPeriod) {
            int tot = 0;
            int j = 0;
            while (j < 7 && j + i < schedulingPeriod.NumDaysInPeriod) {
                tot += employee.ShiftCountPerDay[j + i];
                ++j;
            }
            if (tot < min) {
                int pen = this.Weight * ((min - tot) * (min - tot));
                penalty += pen;
                int j2 = 0;
                while (j2 < 7 && j2 + i < schedulingPeriod.NumDaysInPeriod) {
                    if (employee.ShiftCountPerDay[j2 + i] == 0) {
                        int n = j2 + i;
                        employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                        if (SoftConstraints.UpdateViolationDescriptions) {
                            int n2 = j2 + i;
                            employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Too few shifts this week. Requests min " + min + " shifts per week (works " + tot + " shifts this week). " + System.getProperty("line.separator");
                        }
                    }
                    ++j2;
                }
            }
            i += 7;
        }
        return penalty;
    }
}

