/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.Ikegami;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;
import ASAP.NRP.Core.ShiftType;

public class MaxDaysBetweenShiftSeries
implements SoftConstraint {
    public String Title = "Max days between shift series";
    public String LongTitle = "";
    public int Weight = 0;
    public String ID = "";

    public MaxDaysBetweenShiftSeries(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        String info = "Max days between series of shifts";
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int x = 0;
        while (x < schedulingPeriod.ShiftTypesCount) {
            ShiftType shiftType = schedulingPeriod.GetShiftType(x);
            String ID = shiftType.ID;
            int i = shiftType.Index;
            int max = employee.EmployeeDescription.Contract.MaxDaysBetweenShiftSeries[i];
            if (max > 0) {
                info = String.valueOf(info) + "<br/>Requests max " + max + " days between two series of '" + ID + "' shifts";
            }
            ++x;
        }
        return info;
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int shiftTypeCount = schedulingPeriod.ShiftTypesCount;
        int numDaysInPeriod = schedulingPeriod.NumDaysInPeriod;
        int shiftIndex = 0;
        while (shiftIndex < shiftTypeCount) {
            int max = employee.EmployeeDescription.Contract.MaxDaysBetweenShiftSeries[shiftIndex];
            if (max > 0) {
                int gap = employee.EmployeeDescription.SchedulingHistory.DaysSinceShiftType[shiftIndex];
                if (gap < 0 || gap > max) {
                    gap = 0;
                }
                int startDay = 0;
                int i = 0;
                while (i < numDaysInPeriod) {
                    boolean lastDay;
                    boolean shiftWorked = employee.ShiftAssignments[i * shiftTypeCount + shiftIndex];
                    boolean bl = lastDay = i == numDaysInPeriod - 1;
                    if (lastDay && !shiftWorked) {
                        ++gap;
                    }
                    if (shiftWorked || lastDay) {
                        if (gap > 0 && gap > max) {
                            int pen = (gap - max) * this.Weight;
                            penalty += pen;
                            int end = i;
                            if (i == numDaysInPeriod - 1) {
                                end = i + 1;
                            }
                            int day = startDay;
                            while (day < end) {
                                int n = day;
                                employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                                if (SoftConstraints.UpdateViolationDescriptions) {
                                    String label = schedulingPeriod.GetShiftType((int)shiftIndex).Label;
                                    int n2 = day;
                                    employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Max " + max + " days between '" + label + "' shifts required." + System.getProperty("line.separator");
                                }
                                ++day;
                            }
                        }
                        gap = 0;
                        startDay = i + 1;
                    } else {
                        ++gap;
                    }
                    ++i;
                }
            }
            ++shiftIndex;
        }
        return penalty;
    }
}

