/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.Ikegami;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;

public class MaxWeekendsOff
implements SoftConstraint {
    public String Title = "Max non-working weekends";
    public String LongTitle = "Maximum number of non-working weekends";
    public int Weight = 0;
    public String ID = "Ikegami.MaxWeekendsOff";

    public MaxWeekendsOff(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
        employee.Contract.MaxWeekendsOffIsOn = false;
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "<MaxWeekendsOff Weight=\"" + this.Weight + "\">" + employee.Contract.MaxWeekendsOff + "</MaxWeekendsOff>" + System.getProperty("line.separator");
    }

    @Override
    public String GetDescription(Employee employee) {
        return "Requests max " + employee.EmployeeDescription.Contract.MaxWeekendsOff + "  weekends off.";
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        int sat;
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int maxWeekendsOff = employee.EmployeeDescription.Contract.MaxWeekendsOff;
        int numWeekendsInPeriod = schedulingPeriod.NumWeekendsInPeriod;
        int weekendsOff = 0;
        int saturdayIndex = schedulingPeriod.FirstSaturday;
        if (!(saturdayIndex != 6 || employee.DayType[0] == 1 || employee.EmployeeDescription.DayOffRequestIsWork[0] || employee.EmployeeDescription.SchedulingHistory.PreviousSaturdayWorked || employee.EmployeeDescription.SchedulingHistory.NightShiftFriday)) {
            ++weekendsOff;
        }
        int week = 0;
        while (week < numWeekendsInPeriod) {
            sat = schedulingPeriod.FirstSaturday + week * 7;
            if (sat + 1 >= schedulingPeriod.NumDaysInPeriod) break;
            if (sat == 0) {
                if (!(employee.DayType[sat] == 1 || employee.EmployeeDescription.DayOffRequestIsWork[sat] || employee.DayType[sat + 1] == 1 || employee.EmployeeDescription.DayOffRequestIsWork[sat + 1] || employee.EmployeeDescription.SchedulingHistory.NightShiftFriday)) {
                    ++weekendsOff;
                }
            } else if (!(employee.DayType[sat] == 1 || employee.EmployeeDescription.DayOffRequestIsWork[sat] || employee.DayType[sat + 1] == 1 || employee.EmployeeDescription.DayOffRequestIsWork[sat + 1] || employee.NightShifts[sat - 1])) {
                ++weekendsOff;
            }
            ++week;
        }
        if (weekendsOff > maxWeekendsOff) {
            penalty = this.Weight * (weekendsOff - maxWeekendsOff);
            if (!(schedulingPeriod.FirstSaturday != 6 || employee.DayType[0] == 1 || employee.EmployeeDescription.DayOffRequestIsWork[0] || employee.EmployeeDescription.SchedulingHistory.PreviousSaturdayWorked || employee.EmployeeDescription.SchedulingHistory.NightShiftFriday)) {
                employee.ConstraintViolationPenalties[0] = employee.ConstraintViolationPenalties[0] + penalty;
                if (SoftConstraints.UpdateViolationDescriptions) {
                    employee.ViolationDescriptions[0] = String.valueOf(employee.ViolationDescriptions[0]) + "Too many weekends off, (max " + maxWeekendsOff + "). " + System.getProperty("line.separator");
                }
            }
            week = 0;
            while (week < numWeekendsInPeriod) {
                sat = schedulingPeriod.FirstSaturday + week * 7;
                if (sat + 1 >= schedulingPeriod.NumDaysInPeriod) break;
                if (sat == 0) {
                    if (!(employee.DayType[sat] == 1 || employee.EmployeeDescription.DayOffRequestIsWork[sat] || employee.DayType[sat + 1] == 1 || employee.EmployeeDescription.DayOffRequestIsWork[sat + 1] || employee.EmployeeDescription.SchedulingHistory.NightShiftFriday)) {
                        int n = sat;
                        employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + penalty;
                        int n2 = sat + 1;
                        employee.ConstraintViolationPenalties[n2] = employee.ConstraintViolationPenalties[n2] + penalty;
                        if (SoftConstraints.UpdateViolationDescriptions) {
                            int n3 = sat;
                            employee.ViolationDescriptions[n3] = String.valueOf(employee.ViolationDescriptions[n3]) + "Too many weekends off, (max " + maxWeekendsOff + "). " + System.getProperty("line.separator");
                            int n4 = sat + 1;
                            employee.ViolationDescriptions[n4] = String.valueOf(employee.ViolationDescriptions[n4]) + "Too many weekends off, (max " + maxWeekendsOff + "). " + System.getProperty("line.separator");
                        }
                    }
                } else if (!(employee.DayType[sat] == 1 || employee.EmployeeDescription.DayOffRequestIsWork[sat] || employee.DayType[sat + 1] == 1 || employee.EmployeeDescription.DayOffRequestIsWork[sat + 1] || employee.NightShifts[sat - 1])) {
                    int n = sat;
                    employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + penalty;
                    int n5 = sat + 1;
                    employee.ConstraintViolationPenalties[n5] = employee.ConstraintViolationPenalties[n5] + penalty;
                    if (SoftConstraints.UpdateViolationDescriptions) {
                        int n6 = sat;
                        employee.ViolationDescriptions[n6] = String.valueOf(employee.ViolationDescriptions[n6]) + "Too many weekends off, (max " + maxWeekendsOff + "). " + System.getProperty("line.separator");
                        int n7 = sat + 1;
                        employee.ViolationDescriptions[n7] = String.valueOf(employee.ViolationDescriptions[n7]) + "Too many weekends off, (max " + maxWeekendsOff + "). " + System.getProperty("line.separator");
                    }
                }
                ++week;
            }
        }
        return penalty;
    }
}

