/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.Ikegami;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;

public class MaxWorkingDaysPerWeek
implements SoftConstraint {
    public String Title = "Max working days per week";
    public String LongTitle = "Maximum number of working days per week";
    public int Weight = 0;
    public String ID = "Ikegami.MaxWorkingDaysPerWeek";

    public MaxWorkingDaysPerWeek(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
        employee.Contract.MaxWorkingDaysPerWeekIsOn = false;
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "<MaxWorkingDaysPerWeek Weight=\"" + this.Weight + "\">" + employee.Contract.MaxWorkingDaysPerWeek + "</MaxWorkingDaysPerWeek>" + System.getProperty("line.separator");
    }

    @Override
    public String GetDescription(Employee employee) {
        return "Requests max " + employee.EmployeeDescription.Contract.MaxWorkingDaysPerWeek + " working days per week.";
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int max = employee.EmployeeDescription.Contract.MaxWorkingDaysPerWeek;
        int i = 0;
        while (i < schedulingPeriod.NumDaysInPeriod) {
            int tot = 0;
            int j = 0;
            while (j < 7 && j + i < schedulingPeriod.NumDaysInPeriod) {
                int day = j + i;
                if (employee.DayType[day] == 1 || employee.EmployeeDescription.DayOffRequestIsWork[day]) {
                    ++tot;
                }
                ++j;
            }
            if (tot > max) {
                int pen = this.Weight * (tot - max);
                penalty += pen;
                int j2 = 0;
                while (j2 < 7 && j2 + i < schedulingPeriod.NumDaysInPeriod) {
                    if (employee.ShiftCountPerDay[j2 + i] > 0) {
                        int n = j2 + i;
                        employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                        if (SoftConstraints.UpdateViolationDescriptions) {
                            int n2 = j2 + i;
                            employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Too many working days this week. Requests max " + max + " working days per week (works " + tot + " days this week). " + System.getProperty("line.separator");
                        }
                    }
                    ++j2;
                }
            }
            i += 7;
        }
        return penalty;
    }
}

