/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.Montreal;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;

public class MaxConsecutiveFreeWeekends
implements SoftConstraint {
    public String Title = "Max consecutive free weekends";
    public String LongTitle = "";
    public int Weight = 0;
    public String ID = "";

    public MaxConsecutiveFreeWeekends(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        return "Requests max " + employee.EmployeeDescription.Contract.MaxConsecutiveFreeWeekends + " consecutive non-working weekends.";
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int max = employee.EmployeeDescription.Contract.MaxConsecutiveFreeWeekends;
        int consecutive = 0;
        int saturdayIndex = schedulingPeriod.FirstSaturday;
        if (saturdayIndex == 6) {
            if (employee.EmployeeDescription.SchedulingHistory.LastDayType == 0 && employee.DayType[0] == 0) {
                consecutive = 1;
            }
        } else if (saturdayIndex < 0) {
            if (consecutive > max) {
                penalty += this.Weight * (consecutive - max);
            }
            return penalty;
        }
        int numDaysInPeriod = schedulingPeriod.NumDaysInPeriod;
        while (saturdayIndex < numDaysInPeriod) {
            boolean free = false;
            if (employee.DayType[saturdayIndex] == 0 && saturdayIndex + 1 < employee.DayType.length && employee.DayType[saturdayIndex + 1] == 0) {
                ++consecutive;
                free = true;
            }
            if (!free || saturdayIndex + 7 >= numDaysInPeriod) {
                if (consecutive > max) {
                    int pen = this.Weight * (consecutive - max);
                    penalty += pen;
                    int lastSat = free ? saturdayIndex : saturdayIndex - 7;
                    int i = consecutive;
                    while (i > 0) {
                        if (lastSat >= 0 && employee.DayType[lastSat] == 0) {
                            int n = lastSat;
                            employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                            if (SoftConstraints.UpdateViolationDescriptions) {
                                int n2 = lastSat;
                                employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Too many consecutive free weekends. " + System.getProperty("line.separator");
                            }
                        }
                        if (lastSat + 1 >= 0 && lastSat + 1 < numDaysInPeriod && employee.DayType[lastSat + 1] == 0) {
                            int n = lastSat + 1;
                            employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                            if (SoftConstraints.UpdateViolationDescriptions) {
                                int n3 = lastSat + 1;
                                employee.ViolationDescriptions[n3] = String.valueOf(employee.ViolationDescriptions[n3]) + "Too many consecutive free weekends. " + System.getProperty("line.separator");
                            }
                        }
                        if ((lastSat -= 7) + 1 < 0) break;
                        --i;
                    }
                }
                consecutive = 0;
            }
            saturdayIndex += 7;
        }
        return penalty;
    }
}

