/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.Montreal;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;
import ASAP.NRP.Core.ShiftGroup;

public class MinConsecutiveShiftGroups
implements SoftConstraint {
    public String Title = "Min consecutive shifts from a group";
    public String LongTitle = "";
    public int Weight = 0;
    public String ID = "";

    public MinConsecutiveShiftGroups(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        String info = "Min consecutive shifts from a group";
        SchedulingPeriod sp = employee.Roster.SchedulingPeriod;
        int x = 0;
        while (x < sp.ShiftGroupsCount) {
            ShiftGroup sg = sp.GetShiftGroup(x);
            String ID = sg.Label;
            int i = sg.Index;
            int min = employee.EmployeeDescription.Contract.MinConsecutiveShiftGroups[i];
            if (min > 1) {
                info = String.valueOf(info) + "<br/>Requests min " + min + " consecutive shifts from group '" + ID + "'";
            }
            ++x;
        }
        return info;
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int shiftGroupCount = schedulingPeriod.ShiftGroupsCount;
        int shiftTypeCount = schedulingPeriod.ShiftTypesCount;
        int numDaysInPeriod = schedulingPeriod.NumDaysInPeriod;
        int index = 0;
        while (index < shiftGroupCount) {
            int min = employee.EmployeeDescription.Contract.MinConsecutiveShiftGroups[index];
            if (min > 1) {
                ShiftGroup group = schedulingPeriod.GetShiftGroup(index);
                int consDays = 0;
                int day = 0;
                while (day < numDaysInPeriod) {
                    boolean shiftWorked = false;
                    int i = 0;
                    while (i < group.Group.length) {
                        if (employee.ShiftAssignments[day * shiftTypeCount + group.Group[i].Index]) {
                            shiftWorked = true;
                            break;
                        }
                        ++i;
                    }
                    if (shiftWorked) {
                        ++consDays;
                    } else if (consDays != 0 && consDays < min) {
                        int start;
                        int diff = min - consDays;
                        int pen = this.Weight * diff;
                        penalty += pen;
                        int k = start = day - consDays - diff;
                        while (k < day + diff && k < numDaysInPeriod) {
                            if (k >= 0) {
                                int n = k;
                                employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                                if (SoftConstraints.UpdateViolationDescriptions) {
                                    String label = group.Label;
                                    int n2 = k;
                                    employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Min " + min + " consecutive shifts from shift group '" + label + "' required." + System.getProperty("line.separator");
                                }
                            }
                            ++k;
                        }
                        consDays = 0;
                    } else {
                        consDays = 0;
                    }
                    ++day;
                }
            }
            ++index;
        }
        return penalty;
    }
}

