/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.Montreal;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;
import ASAP.NRP.Core.ShiftType;

public class MinConsecutiveShiftTypes
implements SoftConstraint {
    public String Title = "Min consecutive shift types";
    public String LongTitle = "Minimum number of consecutive shifts of a particular type";
    public int Weight = 0;
    public String ID = "Montreal.MinConsecutiveShiftTypes";

    public MinConsecutiveShiftTypes(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
        int i = 0;
        while (i < employee.Contract.MinConsecutiveShiftTypes.length) {
            employee.Contract.MinConsecutiveShiftTypes[i] = -1;
            ++i;
        }
        employee.Contract.MinConsecutiveShiftTypesAL.clear();
        employee.Contract.MinConsecutiveShiftTypesUsed = false;
        employee.Contract.MinConsecutiveShiftTypesIsOn = false;
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        String info = "";
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        boolean first = true;
        int x = 0;
        while (x < schedulingPeriod.ShiftTypesCount) {
            ShiftType shiftType = schedulingPeriod.GetShiftType(x);
            String label = shiftType.Label;
            int i = shiftType.Index;
            int min = employee.EmployeeDescription.Contract.MinConsecutiveShiftTypes[i];
            if (min > 1) {
                if (!first) {
                    info = String.valueOf(info) + "<br/>";
                }
                first = false;
                info = String.valueOf(info) + "Requests min " + min + " consecutive '" + label + "' shifts";
            }
            ++x;
        }
        return info;
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int shiftTypeCount = schedulingPeriod.ShiftTypesCount;
        int numDaysInPeriod = schedulingPeriod.NumDaysInPeriod;
        int shiftIndex = 0;
        while (shiftIndex < shiftTypeCount) {
            int min = employee.EmployeeDescription.Contract.MinConsecutiveShiftTypes[shiftIndex];
            if (min > 1) {
                int consDays = employee.EmployeeDescription.SchedulingHistory.PreviousConsecutiveShifts[shiftIndex];
                int i = 0;
                while (i < numDaysInPeriod) {
                    if (employee.ShiftAssignments[i * shiftTypeCount + shiftIndex]) {
                        ++consDays;
                    } else if (consDays != 0 && consDays < min) {
                        int start;
                        int diff = min - consDays;
                        int pen = this.Weight * diff;
                        penalty += pen;
                        int k = start = i - consDays - diff;
                        while (k < i + diff && k < numDaysInPeriod) {
                            if (k >= 0) {
                                int n = k;
                                employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                                if (SoftConstraints.UpdateViolationDescriptions) {
                                    String label = schedulingPeriod.GetShiftType((int)shiftIndex).Label;
                                    int n2 = k;
                                    employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Min " + min + " consecutive '" + label + "' shifts required." + System.getProperty("line.separator");
                                }
                            }
                            ++k;
                        }
                        consDays = 0;
                    } else {
                        consDays = 0;
                    }
                    ++i;
                }
            }
            ++shiftIndex;
        }
        return penalty;
    }
}

