/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.Montreal;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;

public class MinHoursWorkedBetweenDates
implements SoftConstraint {
    public String Title = "Min hours worked between two dates";
    public String LongTitle = "";
    public int Weight = 0;
    public String ID = "";

    public MinHoursWorkedBetweenDates(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        if (employee.EmployeeDescription.Contract.MinHoursWorkedBetweenDates == null) {
            return "";
        }
        String str = "";
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int i = 0;
        while (i < employee.EmployeeDescription.Contract.MinHoursWorkedBetweenDates.length) {
            int start = employee.EmployeeDescription.Contract.MinHoursWorkedBetweenDates[i].StartDay;
            int end = employee.EmployeeDescription.Contract.MinHoursWorkedBetweenDates[i].EndDay;
            int min = employee.EmployeeDescription.Contract.MinHoursWorkedBetweenDates[i].Hours;
            str = String.valueOf(str) + "Requests min " + min + " hours between " + schedulingPeriod.ConvertRosterDayToDate(start).ToString("yyyy-MM-dd") + " and " + schedulingPeriod.ConvertRosterDayToDate(end).ToString("yyyy-MM-dd") + "<br/> " + System.getProperty("line.separator");
            ++i;
        }
        return str;
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        if (employee.EmployeeDescription.Contract.MinHoursWorkedBetweenDates == null) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int shiftTypesCount = schedulingPeriod.ShiftTypesCount;
        int penalty = 0;
        int i = 0;
        while (i < employee.EmployeeDescription.Contract.MinHoursWorkedBetweenDates.length) {
            int start = employee.EmployeeDescription.Contract.MinHoursWorkedBetweenDates[i].StartDay;
            int end = employee.EmployeeDescription.Contract.MinHoursWorkedBetweenDates[i].EndDay;
            int min = employee.EmployeeDescription.Contract.MinHoursWorkedBetweenDates[i].Hours;
            double totHours = 0.0;
            int j = start;
            while (j <= end) {
                int k = 0;
                while (k < shiftTypesCount) {
                    if (employee.ShiftAssignments[j * shiftTypesCount + k]) {
                        totHours += schedulingPeriod.GetShiftType((int)k).HoursWorked;
                    }
                    ++k;
                }
                ++j;
            }
            int tot = (int)totHours;
            if (tot < min) {
                int pen = (min - tot) * this.Weight;
                penalty += pen;
                int j2 = start;
                while (j2 <= end) {
                    int n = j2;
                    employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                    if (SoftConstraints.UpdateViolationDescriptions) {
                        int n2 = j2;
                        employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Too few hours worked between days " + schedulingPeriod.ConvertRosterDayToDate(start).ToString("yyyy-MM-dd") + " and " + schedulingPeriod.ConvertRosterDayToDate(end).ToString("yyyy-MM-dd") + ". Requests min " + min + " hours (works " + tot + "). " + System.getProperty("line.separator");
                    }
                    ++j2;
                }
            }
            ++i;
        }
        return penalty;
    }
}

