/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.Montreal;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;
import ASAP.NRP.Core.ShiftGroup;

public class MinShiftGroupRatios
implements SoftConstraint {
    public String Title = "Min shift group ratios";
    public String LongTitle = "";
    public int Weight = 0;
    public String ID = "";

    public MinShiftGroupRatios(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        String info = "Min shift group ratios";
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int totShifts = employee.ShiftsCount;
        int x = 0;
        while (x < schedulingPeriod.ShiftGroupsCount) {
            ShiftGroup shiftGroup = schedulingPeriod.GetShiftGroup(x);
            String ID = shiftGroup.ID;
            int i = shiftGroup.Index;
            if (employee.EmployeeDescription.Contract.MinShiftGroupRatios[i] >= 0) {
                int ratio = 0;
                if (totShifts != 0) {
                    ratio = (int)((float)employee.ShiftGroupCount[i] / (float)totShifts * 100.0f);
                }
                info = String.valueOf(info) + "<br/>Requests min " + employee.EmployeeDescription.Contract.MinShiftGroupRatios[i] + "% shifts from group '" + ID + "' (" + shiftGroup.Label + "), receives " + ratio + "%";
            }
            ++x;
        }
        return info;
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int shiftCount = schedulingPeriod.ShiftGroupsCount;
        int totShifts = employee.ShiftsCount;
        int i = 0;
        while (i < shiftCount) {
            int min = employee.EmployeeDescription.Contract.MinShiftGroupRatios[i];
            int ratio = 0;
            if (totShifts != 0) {
                ratio = (int)((float)employee.ShiftGroupCount[i] / (float)totShifts * 100.0f);
            }
            if (min >= 0 && ratio < min) {
                int pen = this.Weight * (min - ratio);
                penalty += pen;
            }
            ++i;
        }
        return penalty;
    }
}

