/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.SINTEF;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;

public class MaxHoursPerWeek
implements SoftConstraint {
    public String Title = "Max hours per week";
    public String LongTitle = "Maximum number of hours worked each week";
    public int Weight = 0;
    public String ID = "SINTEF.MaxHoursPerWeek";

    public MaxHoursPerWeek(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
        employee.Contract.MaxHoursPerWeekIsOn = false;
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "<MaxHoursPerWeek Weight=\"" + this.Weight + "\">" + employee.Contract.MaxHoursPerWeek + "</MaxHoursPerWeek>" + System.getProperty("line.separator");
    }

    @Override
    public String GetDescription(Employee employee) {
        return "Requests max " + employee.EmployeeDescription.Contract.MaxHoursPerWeek + " hours per week";
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        double max = employee.EmployeeDescription.Contract.MaxHoursPerWeek;
        int i = 0;
        while (i < schedulingPeriod.NumWeeksInPeriod) {
            double hours = employee.HoursWorkedPerWeek[i];
            if (hours > max) {
                int pen = (int)((double)this.Weight * (hours - max));
                penalty += pen;
                int k = i * 7;
                while (k < (i + 1) * 7 && k < schedulingPeriod.NumDaysInPeriod) {
                    if (employee.DayType[k] == 1) {
                        int n = k;
                        employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                        if (SoftConstraints.UpdateViolationDescriptions) {
                            int n2 = k;
                            employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Too many hours worked this week. Requests max " + max + " hours per week (works " + hours + " hours this week). " + System.getProperty("line.separator");
                        }
                    }
                    ++k;
                }
            }
            ++i;
        }
        return penalty;
    }
}

