/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core;

import ASAP.NRP.Core.CSharpConversionHelper;
import ASAP.NRP.Core.Constraints.ANROM.AlternativeSkillCategory;
import ASAP.NRP.Core.Constraints.ANROM.CompleteWeekends;
import ASAP.NRP.Core.Constraints.ANROM.IdenticalShiftTypesDuringWeekend;
import ASAP.NRP.Core.Constraints.ANROM.MaxAssignmentsForDayOfWeek;
import ASAP.NRP.Core.Constraints.ANROM.MaxConsecutiveFreeDays;
import ASAP.NRP.Core.Constraints.ANROM.MaxConsecutiveWorkingDays;
import ASAP.NRP.Core.Constraints.ANROM.MaxConsecutiveWorkingWeekends;
import ASAP.NRP.Core.Constraints.ANROM.MaxHoursWorked;
import ASAP.NRP.Core.Constraints.ANROM.MaxNumAssignments;
import ASAP.NRP.Core.Constraints.ANROM.MaxShiftTypes;
import ASAP.NRP.Core.Constraints.ANROM.MaxShiftTypesPerWeek;
import ASAP.NRP.Core.Constraints.ANROM.MaxWorkingBankHolidays;
import ASAP.NRP.Core.Constraints.ANROM.MaxWorkingWeekendsInFourWeeks;
import ASAP.NRP.Core.Constraints.ANROM.MinConsecutiveFreeDays;
import ASAP.NRP.Core.Constraints.ANROM.MinConsecutiveWorkingDays;
import ASAP.NRP.Core.Constraints.ANROM.MinHoursWorked;
import ASAP.NRP.Core.Constraints.ANROM.MinTimeBetweenShifts;
import ASAP.NRP.Core.Constraints.ANROM.NoNightShiftBeforeFreeWeekend;
import ASAP.NRP.Core.Constraints.ANROM.NumConsecutiveShiftGroups;
import ASAP.NRP.Core.Constraints.ANROM.NumConsecutiveShiftTypes;
import ASAP.NRP.Core.Constraints.ANROM.RequestedDaysOff;
import ASAP.NRP.Core.Constraints.ANROM.RequestedDaysOn;
import ASAP.NRP.Core.Constraints.ANROM.RequestedShiftsOff;
import ASAP.NRP.Core.Constraints.ANROM.RequestedShiftsOn;
import ASAP.NRP.Core.Constraints.ANROM.ShiftTypeSuccessions;
import ASAP.NRP.Core.Constraints.ANROM.Tutorship;
import ASAP.NRP.Core.Constraints.ANROM.TwoFreeDaysAfterNightShifts;
import ASAP.NRP.Core.Constraints.ANROM.WorkSeparately;
import ASAP.NRP.Core.Constraints.Azaiez.MaxWeekendDays;
import ASAP.NRP.Core.Constraints.GPost.MaxShiftsPerDay;
import ASAP.NRP.Core.Constraints.GPost.MaxShiftsPerWeek;
import ASAP.NRP.Core.Constraints.GPost.MinShiftsPerWeek;
import ASAP.NRP.Core.Constraints.Ikegami.MaxDaysBetweenShiftSeries;
import ASAP.NRP.Core.Constraints.Ikegami.MaxDaysOff;
import ASAP.NRP.Core.Constraints.Ikegami.MaxWeekendsOff;
import ASAP.NRP.Core.Constraints.Ikegami.MaxWorkingDaysPerWeek;
import ASAP.NRP.Core.Constraints.Ikegami.MinDaysBetweenShiftSeries;
import ASAP.NRP.Core.Constraints.Ikegami.MinDaysOff;
import ASAP.NRP.Core.Constraints.Millar.MaxWorkingWeekends;
import ASAP.NRP.Core.Constraints.Montreal.DaysOffRequestsBetweenDates;
import ASAP.NRP.Core.Constraints.Montreal.MaxConsecutiveFreeWeekends;
import ASAP.NRP.Core.Constraints.Montreal.MaxConsecutiveShiftGroups;
import ASAP.NRP.Core.Constraints.Montreal.MaxConsecutiveShiftTypes;
import ASAP.NRP.Core.Constraints.Montreal.MaxHoursWorkedBetweenDates;
import ASAP.NRP.Core.Constraints.Montreal.MaxShiftGroupRatios;
import ASAP.NRP.Core.Constraints.Montreal.MaxShiftTypeRatios;
import ASAP.NRP.Core.Constraints.Montreal.MinConsecutiveFreeWeekends;
import ASAP.NRP.Core.Constraints.Montreal.MinConsecutiveShiftGroups;
import ASAP.NRP.Core.Constraints.Montreal.MinConsecutiveShiftTypes;
import ASAP.NRP.Core.Constraints.Montreal.MinConsecutiveWorkingWeekends;
import ASAP.NRP.Core.Constraints.Montreal.MinHoursWorkedBetweenDates;
import ASAP.NRP.Core.Constraints.Montreal.MinShiftGroupRatios;
import ASAP.NRP.Core.Constraints.Montreal.MinShiftTypeRatios;
import ASAP.NRP.Core.Constraints.ORTEC01.MaxShiftsPerWeekStartMon;
import ASAP.NRP.Core.Constraints.ORTEC01.MaxWorkingWeekendsIncFriNight;
import ASAP.NRP.Core.Constraints.ORTEC01.MinShiftsPerWeekStartMon;
import ASAP.NRP.Core.Constraints.QMC.MaxHoursPerFortnight;
import ASAP.NRP.Core.Constraints.QMC.RequestedShiftGroupsOn;
import ASAP.NRP.Core.Constraints.QMC.ShiftGroupRequest;
import ASAP.NRP.Core.Constraints.SINTEF.MaxHoursPerWeek;
import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.TEC.BadPatterns;
import ASAP.NRP.Core.Constraints.TEC.EmployeeAvailability;
import ASAP.NRP.Core.Constraints.TEC.GoodPatterns;
import ASAP.NRP.Core.Constraints.TEC.MaxShiftGroups;
import ASAP.NRP.Core.Constraints.TEC.MinShiftGroups;
import ASAP.NRP.Core.Constraints.TEC.MinShiftTypes;
import ASAP.NRP.Core.Constraints.TEC.SkilledShifts;
import ASAP.NRP.Core.Contract;
import ASAP.NRP.Core.DateTime;
import ASAP.NRP.Core.DayOffRequest;
import ASAP.NRP.Core.DayOnRequest;
import ASAP.NRP.Core.DaysOffRequestBetweenDates;
import ASAP.NRP.Core.SchedulingHistory;
import ASAP.NRP.Core.SchedulingPeriod;
import ASAP.NRP.Core.ShiftRequest;
import ASAP.NRP.Core.Skill;
import java.util.ArrayList;
import java.util.Hashtable;

public class EmployeeDescription {
    public boolean AvailableDuringEntirePeriod = true;
    public boolean[] AvailableOn;
    public String ID = "";
    public String FirstName = "";
    public String LastName = "";
    public String EmailAddress = "";
    public String PhoneNumber = "";
    public int IndexID = 0;
    public int TutorCount = 0;
    public int AvoidPartnershipsCount = 0;
    public int VerticallyRelatedEmployeesCount = 0;
    public String SkillsDescription = "";
    public Contract Contract = null;
    DateTime employmentStartDate = new DateTime();
    DateTime employmentEndDate = new DateTime();
    public Hashtable<String, SkillType> Skills = new Hashtable();
    public ArrayList<EmployeeDescription> Tutors = new ArrayList();
    public ArrayList<EmployeeDescription> AvoidPartnership = new ArrayList();
    public ArrayList<EmployeeDescription> VerticallyRelatedEmployees = new ArrayList();
    public SchedulingPeriod SchedulingPeriod;
    public SchedulingHistory SchedulingHistory;
    public int[] DayOffRequests;
    public boolean[] DayOffRequestIsHoliday;
    public boolean[] DayOffRequestIsWork;
    public int[] DayOnRequests;
    public int[] ShiftOffRequests;
    public int[] ShiftOnRequests;
    public boolean[] PreAssignments;
    public ArrayList<DayOffRequest> DayOffRequestObjs = new ArrayList();
    public ArrayList<DayOnRequest> DayOnRequestObjs = new ArrayList();
    public ArrayList<ShiftRequest> ShiftOffRequestObjs = new ArrayList();
    public ArrayList<ShiftRequest> ShiftOnRequestObjs = new ArrayList();
    public int DayOffRequestCount = 0;
    public int DayOnRequestCount = 0;
    public int ShiftOffRequestCount = 0;
    public int ShiftOnRequestCount = 0;
    public int DaysOffRequestBetweenDatesCount = 0;
    public SoftConstraint[] AllSoftConstraints = new SoftConstraint[0];
    public ShiftGroupRequest[] ShiftGroupOnRequests = new ShiftGroupRequest[0];
    public DaysOffRequestBetweenDates[] DaysOffRequestsBetweenDates = new DaysOffRequestBetweenDates[0];
    public BadPatterns BadPatternConstraint = null;
    public boolean[] FrozenDay;
    public boolean UsesConstraintANROMRequestedShiftsOff = false;
    public boolean UsesConstraintANROMRequestedDaysOff = false;
    public boolean UsesConstraintANROMRequestedDaysOn = false;
    public boolean UsesConstraintANROMRequestedShiftsOn = false;
    public boolean UsesConstraintQMCRequestedShiftGroupsOn = false;
    public boolean InRoster = true;

    public EmployeeDescription(String employeeID, SchedulingPeriod schedulingPeriod) {
        this.ID = employeeID;
        this.SchedulingPeriod = schedulingPeriod;
        this.SchedulingHistory = new SchedulingHistory(schedulingPeriod);
        this.DayOffRequests = new int[schedulingPeriod.NumDaysInPeriod];
        int i = 0;
        while (i < this.DayOffRequests.length) {
            this.DayOffRequests[i] = 0;
            ++i;
        }
        this.DayOffRequestIsHoliday = new boolean[schedulingPeriod.NumDaysInPeriod];
        this.DayOffRequestIsWork = new boolean[schedulingPeriod.NumDaysInPeriod];
        this.DayOnRequests = new int[schedulingPeriod.NumDaysInPeriod];
        i = 0;
        while (i < this.DayOnRequests.length) {
            this.DayOnRequests[i] = 0;
            ++i;
        }
        this.ShiftOffRequests = new int[schedulingPeriod.NumDaysInPeriod * schedulingPeriod.ShiftTypesCount];
        i = 0;
        while (i < this.ShiftOffRequests.length) {
            this.ShiftOffRequests[i] = 0;
            ++i;
        }
        this.ShiftOnRequests = new int[schedulingPeriod.NumDaysInPeriod * schedulingPeriod.ShiftTypesCount];
        i = 0;
        while (i < this.ShiftOnRequests.length) {
            this.ShiftOnRequests[i] = 0;
            ++i;
        }
        this.AvailableOn = new boolean[schedulingPeriod.NumDaysInPeriod];
        i = 0;
        while (i < this.AvailableOn.length) {
            this.AvailableOn[i] = true;
            ++i;
        }
        this.PreAssignments = new boolean[schedulingPeriod.NumDaysInPeriod * schedulingPeriod.ShiftTypesCount];
        this.FrozenDay = new boolean[schedulingPeriod.NumDaysInPeriod];
    }

    public String getName() {
        String name = this.LastName;
        if (!this.FirstName.equalsIgnoreCase("")) {
            name = name.equalsIgnoreCase("") ? this.FirstName : String.valueOf(name) + ", " + this.FirstName;
        }
        return name;
    }

    public String getSkillsLabel() {
        String skillsLabel = "";
        return skillsLabel;
    }

    public DateTime getEmploymentStartDate() {
        return this.employmentStartDate;
    }

    public void setEmploymentStartDate(DateTime value) {
        this.employmentStartDate = value;
        this.AvailableDuringEntirePeriod = this.employmentEndDate != null && this.employmentEndDate.isLessThan(this.SchedulingPeriod.EndDate) ? false : !this.employmentStartDate.isGreaterThan(this.SchedulingPeriod.StartDate);
        if (this.employmentStartDate.isGreaterThan(this.SchedulingPeriod.StartDate)) {
            DateTime tempDate = this.SchedulingPeriod.StartDate;
            int i = 0;
            while (i < this.SchedulingPeriod.NumDaysInPeriod) {
                if (tempDate.isLessThan(this.employmentStartDate)) {
                    this.AvailableOn[i] = false;
                }
                tempDate = tempDate.AddDays(1);
                ++i;
            }
        }
    }

    public DateTime getEmploymentEndDate() {
        return this.employmentEndDate;
    }

    public void setEmploymentEndDate(DateTime value) {
        this.employmentEndDate = value;
        this.AvailableDuringEntirePeriod = this.employmentStartDate != null && this.employmentStartDate.isGreaterThan(this.SchedulingPeriod.StartDate) ? false : !this.employmentEndDate.isLessThan(this.SchedulingPeriod.EndDate);
        if (this.employmentEndDate.isLessThan(this.SchedulingPeriod.EndDate)) {
            DateTime tempDate = this.SchedulingPeriod.EndDate;
            int i = this.SchedulingPeriod.NumDaysInPeriod - 1;
            while (i >= 0) {
                if (tempDate.isGreaterThan(this.employmentEndDate)) {
                    this.AvailableOn[i] = false;
                }
                tempDate = tempDate.AddDays(-1);
                --i;
            }
        }
    }

    public boolean AddSkill(String skillID, String type) {
        if (this.Skills.containsKey(skillID)) {
            System.out.println("Unable to Add Skill : " + skillID + " to Employee : " + this.getName() + " as already has this skill.");
            return false;
        }
        if (type.equalsIgnoreCase("Primary")) {
            this.Skills.put(skillID, SkillType.Primary);
        } else if (type.equalsIgnoreCase("Secondary")) {
            this.Skills.put(skillID, SkillType.Secondary);
        } else {
            System.out.println("Unable to Add Skill : " + skillID + " to Employee : " + this.getName() + " as skill type " + type + " is an unknown skill type");
            return false;
        }
        this.UpdateSkillsDescription();
        return true;
    }

    public void DeleteSkill(Skill skill) {
        this.Skills.remove(skill.ID);
        this.UpdateSkillsDescription();
    }

    public void ClearSkills() {
        this.Skills.clear();
        this.UpdateSkillsDescription();
    }

    private void UpdateSkillsDescription() {
        this.SkillsDescription = "";
    }

    public boolean HasSkillType(String skillID, SkillType type) {
        if (this.Skills.containsKey(skillID)) {
            return this.Skills.get(skillID) == type;
        }
        return false;
    }

    public boolean HasSkillType(Skill skill) {
        return this.Skills.containsKey(skill.ID);
    }

    public String GetSkillsDescription() {
        return this.SkillsDescription;
    }

    public boolean AddTutor(EmployeeDescription employee) {
        if (this.Tutors.contains(employee)) {
            return false;
        }
        this.Tutors.add(employee);
        ++this.TutorCount;
        employee.AddVerticallyRelatedEmployee(this);
        return true;
    }

    public EmployeeDescription GetTutor(int index) {
        return this.Tutors.get(index);
    }

    public boolean AvoidPartnership(EmployeeDescription employee) {
        if (this.AvoidPartnership.contains(employee)) {
            return false;
        }
        this.AvoidPartnership.add(employee);
        ++this.AvoidPartnershipsCount;
        employee.AddVerticallyRelatedEmployee(this);
        return true;
    }

    public EmployeeDescription GetAvoidPartnership(int index) {
        return this.AvoidPartnership.get(index);
    }

    public boolean AddVerticallyRelatedEmployee(EmployeeDescription employee) {
        if (this.VerticallyRelatedEmployees.contains(employee)) {
            return false;
        }
        this.VerticallyRelatedEmployees.add(employee);
        ++this.VerticallyRelatedEmployeesCount;
        return true;
    }

    public EmployeeDescription GetVerticallyRelatedEmployee(int index) {
        return this.VerticallyRelatedEmployees.get(index);
    }

    public boolean AvailableOnDay(int rosterDay) {
        return this.AvailableOn[rosterDay];
    }

    public void AddShiftGroupOnRequest(ShiftGroupRequest request) {
        this.ShiftGroupOnRequests = CSharpConversionHelper.ArrayResize(this.ShiftGroupOnRequests, this.ShiftGroupOnRequests.length + 1);
        this.ShiftGroupOnRequests[this.ShiftGroupOnRequests.length - 1] = request;
    }

    public void AddDaysOffRequestBetweenDates(DaysOffRequestBetweenDates request) {
        this.DaysOffRequestsBetweenDates = CSharpConversionHelper.ArrayResize(this.DaysOffRequestsBetweenDates, this.DaysOffRequestsBetweenDates.length + 1);
        this.DaysOffRequestsBetweenDates[this.DaysOffRequestsBetweenDates.length - 1] = request;
        ++this.DaysOffRequestBetweenDatesCount;
    }

    public void CreateSoftConstraints() {
        int weight;
        if (this.Contract == null) {
            return;
        }
        ArrayList<SoftConstraint> array = new ArrayList<SoftConstraint>();
        if (this.Contract.MaxShiftTypesIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MaxShiftTypes;
            if (this.Contract.MaxShiftTypesWeight > -1) {
                weight = this.Contract.MaxShiftTypesWeight;
            }
            if (this.Contract.MaxShiftTypesUsed) {
                array.add(new MaxShiftTypes(weight));
            }
            if (this.Contract.MaxShiftGroupsUsed) {
                array.add(new MaxShiftGroups(weight));
            }
        }
        if (this.Contract.MinShiftTypesIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MinShiftTypes;
            if (this.Contract.MinShiftTypesWeight > -1) {
                weight = this.Contract.MinShiftTypesWeight;
            }
            if (this.Contract.MinShiftTypesUsed) {
                array.add(new MinShiftTypes(weight));
            }
            if (this.Contract.MinShiftGroupsUsed) {
                array.add(new MinShiftGroups(weight));
            }
        }
        if (this.Contract.MaxNumAssignmentsIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MaxNumAssignments;
            if (this.Contract.MaxNumAssignmentsWeight > -1) {
                weight = this.Contract.MaxNumAssignmentsWeight;
            }
            array.add(new MaxNumAssignments(weight));
        }
        if (this.Contract.MaxConsecutiveWorkingWeekendsIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MaxConsecutiveWorkingWeekends;
            if (this.Contract.MaxConsecutiveWorkingWeekendsWeight > -1) {
                weight = this.Contract.MaxConsecutiveWorkingWeekendsWeight;
            }
            array.add(new MaxConsecutiveWorkingWeekends(weight));
        }
        if (this.Contract.MinConsecutiveWorkingWeekendsIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MinConsecutiveWorkingWeekends;
            if (this.Contract.MinConsecutiveWorkingWeekendsWeight > -1) {
                weight = this.Contract.MinConsecutiveWorkingWeekendsWeight;
            }
            array.add(new MinConsecutiveWorkingWeekends(weight));
        }
        if (this.Contract.MaxConsecutiveFreeWeekendsIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MaxConsecutiveFreeWeekends;
            if (this.Contract.MaxConsecutiveFreeWeekendsWeight > -1) {
                weight = this.Contract.MaxConsecutiveFreeWeekendsWeight;
            }
            array.add(new MaxConsecutiveFreeWeekends(weight));
        }
        if (this.Contract.MinConsecutiveFreeWeekendsIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MinConsecutiveFreeWeekends;
            if (this.Contract.MinConsecutiveFreeWeekendsWeight > -1) {
                weight = this.Contract.MinConsecutiveFreeWeekendsWeight;
            }
            array.add(new MinConsecutiveFreeWeekends(weight));
        }
        if (this.Contract.MaxWorkingWeekendsInFourWeeksIsOn) {
            weight = this.Contract.MaxWorkingWeekendsInFourWeeksWeight > -1 ? this.Contract.MaxWorkingWeekendsInFourWeeksWeight : this.SchedulingPeriod.MasterWeights.MaxWorkingWeekendsInFourWeeks;
            array.add(new MaxWorkingWeekendsInFourWeeks(weight));
        }
        if (this.Contract.MaxWorkingWeekendsIncFriNightIsOn) {
            weight = this.Contract.MaxWorkingWeekendsIncFriNightWeight > -1 ? this.Contract.MaxWorkingWeekendsIncFriNightWeight : this.SchedulingPeriod.MasterWeights.MaxWorkingWeekendsIncFriNight;
            array.add(new MaxWorkingWeekendsIncFriNight(weight));
        }
        if (this.Contract.MaxWeekendsOffIsOn) {
            weight = this.Contract.MaxWeekendsOffWeight > -1 ? this.Contract.MaxWeekendsOffWeight : this.SchedulingPeriod.MasterWeights.MaxWeekendsOff;
            array.add(new MaxWeekendsOff(weight));
        }
        if (this.Contract.MaxWorkingWeekendsIsOn) {
            weight = this.Contract.MaxWorkingWeekendsWeight > -1 ? this.Contract.MaxWorkingWeekendsWeight : this.SchedulingPeriod.MasterWeights.MaxWorkingWeekends;
            array.add(new MaxWorkingWeekends(weight));
        }
        if (this.SchedulingPeriod.MasterWeights.MinTimeBetweenShifts > 0) {
            weight = this.SchedulingPeriod.MasterWeights.MinTimeBetweenShifts;
            array.add(new MinTimeBetweenShifts(weight));
        }
        if (this.Contract.MaxDaysOffIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MaxDaysOff;
            if (this.Contract.MaxDaysOffWeight > -1) {
                weight = this.Contract.MaxDaysOffWeight;
            }
            array.add(new MaxDaysOff(weight));
        }
        if (this.Contract.MinDaysOffIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MinDaysOff;
            if (this.Contract.MinDaysOffWeight > -1) {
                weight = this.Contract.MinDaysOffWeight;
            }
            array.add(new MinDaysOff(weight));
        }
        if (this.Contract.MaxShiftsPerDayIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MaxShiftsPerDay;
            if (this.Contract.MaxShiftsPerDayWeight > -1) {
                weight = this.Contract.MaxShiftsPerDayWeight;
            }
            array.add(new MaxShiftsPerDay(weight));
        }
        if (this.Contract.MinShiftsPerWeekIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MinShiftsPerWeek;
            if (this.Contract.MinShiftsPerWeekWeight > -1) {
                weight = this.Contract.MinShiftsPerWeekWeight;
            }
            array.add(new MinShiftsPerWeek(weight));
        }
        if (this.Contract.MaxShiftsPerWeekIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MaxShiftsPerWeek;
            if (this.Contract.MaxShiftsPerWeekWeight > -1) {
                weight = this.Contract.MaxShiftsPerWeekWeight;
            }
            array.add(new MaxShiftsPerWeek(weight));
        }
        if (this.Contract.MaxWorkingDaysPerWeekIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MaxWorkingDaysPerWeek;
            if (this.Contract.MaxWorkingDaysPerWeekWeight > -1) {
                weight = this.Contract.MaxWorkingDaysPerWeekWeight;
            }
            array.add(new MaxWorkingDaysPerWeek(weight));
        }
        if (this.Contract.MaxConsecutiveWorkingDaysIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MaxConsecutiveWorkingDays;
            if (this.Contract.MaxConsecutiveWorkingDaysWeight > -1) {
                weight = this.Contract.MaxConsecutiveWorkingDaysWeight;
            }
            array.add(new MaxConsecutiveWorkingDays(weight));
        }
        if (this.Contract.MinConsecutiveWorkingDaysIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MinConsecutiveWorkingDays;
            if (this.Contract.MinConsecutiveWorkingDaysWeight > -1) {
                weight = this.Contract.MinConsecutiveWorkingDaysWeight;
            }
            array.add(new MinConsecutiveWorkingDays(weight));
        }
        if (this.Contract.MinDaysBetweenShiftSeriesIsOn) {
            weight = this.Contract.MinDaysBetweenShiftSeriesWeight > -1 ? this.Contract.MinDaysBetweenShiftSeriesWeight : this.SchedulingPeriod.MasterWeights.MinDaysBetweenShiftSeries;
            array.add(new MinDaysBetweenShiftSeries(weight));
        }
        if (this.Contract.MaxDaysBetweenShiftSeriesIsOn) {
            weight = this.Contract.MaxDaysBetweenShiftSeriesWeight > -1 ? this.Contract.MaxDaysBetweenShiftSeriesWeight : this.SchedulingPeriod.MasterWeights.MaxDaysBetweenShiftSeries;
            array.add(new MaxDaysBetweenShiftSeries(weight));
        }
        if (this.Contract.MinConsecutiveShiftTypesIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MinConsecutiveShiftTypes;
            if (this.Contract.MinConsecutiveShiftTypesWeight > -1) {
                weight = this.Contract.MinConsecutiveShiftTypesWeight;
            }
            if (this.Contract.MinConsecutiveShiftTypesUsed) {
                array.add(new MinConsecutiveShiftTypes(weight));
            }
            if (this.Contract.MinConsecutiveShiftGroupsUsed) {
                array.add(new MinConsecutiveShiftGroups(weight));
            }
        }
        if (this.Contract.MaxConsecutiveShiftTypesIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MaxConsecutiveShiftTypes;
            if (this.Contract.MaxConsecutiveShiftTypesWeight > -1) {
                weight = this.Contract.MaxConsecutiveShiftTypesWeight;
            }
            if (this.Contract.MaxConsecutiveShiftTypesUsed) {
                array.add(new MaxConsecutiveShiftTypes(weight));
            }
            if (this.Contract.MaxConsecutiveShiftGroupsUsed) {
                array.add(new MaxConsecutiveShiftGroups(weight));
            }
        }
        if (this.Contract.MinHoursWorkedBetweenDatesIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MinHoursWorkedBetweenDates;
            if (this.Contract.MinHoursWorkedBetweenDatesWeight > -1) {
                weight = this.Contract.MinHoursWorkedBetweenDatesWeight;
            }
            array.add(new MinHoursWorkedBetweenDates(weight));
        }
        if (this.Contract.MaxHoursWorkedBetweenDatesIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MaxHoursWorkedBetweenDates;
            if (this.Contract.MaxHoursWorkedBetweenDatesWeight > -1) {
                weight = this.Contract.MaxHoursWorkedBetweenDatesWeight;
            }
            array.add(new MaxHoursWorkedBetweenDates(weight));
        }
        if (this.Contract.ValidShiftTypeSuccessionsIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.ValidShiftTypeSuccessions;
            if (this.Contract.ValidShiftTypeSuccessionsWeight > -1) {
                weight = this.Contract.ValidShiftTypeSuccessionsWeight;
            }
            array.add(new ShiftTypeSuccessions(weight));
        }
        if (this.Contract.MaxShiftTypeRatiosIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MaxShiftTypeRatios;
            if (this.Contract.MaxShiftTypeRatiosWeight > -1) {
                weight = this.Contract.MaxShiftTypeRatiosWeight;
            }
            if (this.Contract.MaxShiftTypeRatiosUsed) {
                array.add(new MaxShiftTypeRatios(weight));
            }
            if (this.Contract.MaxShiftGroupRatiosUsed) {
                array.add(new MaxShiftGroupRatios(weight));
            }
        }
        if (this.Contract.MinShiftTypeRatiosIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MinShiftTypeRatios;
            if (this.Contract.MinShiftTypeRatiosWeight > -1) {
                weight = this.Contract.MinShiftTypeRatiosWeight;
            }
            if (this.Contract.MinShiftTypeRatiosUsed) {
                array.add(new MinShiftTypeRatios(weight));
            }
            if (this.Contract.MinShiftGroupRatiosUsed) {
                array.add(new MinShiftGroupRatios(weight));
            }
        }
        if (this.Contract.MaxWorkingBankHolidaysIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MaxWorkingBankHolidays;
            if (this.Contract.MaxWorkingBankHolidaysWeight > -1) {
                weight = this.Contract.MaxWorkingBankHolidaysWeight;
            }
            array.add(new MaxWorkingBankHolidays(weight));
        }
        if (this.Contract.MaxConsecutiveFreeDaysIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MaxConsecutiveFreeDays;
            if (this.Contract.MaxConsecutiveFreeDaysWeight > -1) {
                weight = this.Contract.MaxConsecutiveFreeDaysWeight;
            }
            array.add(new MaxConsecutiveFreeDays(weight));
        }
        if (this.Contract.MinConsecutiveFreeDaysIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MinConsecutiveFreeDays;
            if (this.Contract.MinConsecutiveFreeDaysWeight > -1) {
                weight = this.Contract.MinConsecutiveFreeDaysWeight;
            }
            array.add(new MinConsecutiveFreeDays(weight));
        }
        if (this.Contract.CompleteWeekends) {
            weight = this.SchedulingPeriod.MasterWeights.CompleteWeekends;
            if (this.Contract.CompleteWeekendsWeight > -1) {
                weight = this.Contract.CompleteWeekendsWeight;
            }
            array.add(new CompleteWeekends(weight));
        }
        if (this.Contract.IdenticalShiftTypesDuringWeekend) {
            weight = this.SchedulingPeriod.MasterWeights.IdenticalShiftTypesDuringWeekend;
            if (this.Contract.IdenticalShiftTypesDuringWeekendWeight > -1) {
                weight = this.Contract.IdenticalShiftTypesDuringWeekendWeight;
            }
            array.add(new IdenticalShiftTypesDuringWeekend(weight));
        }
        if (this.Contract.NoNightShiftBeforeFreeWeekend) {
            weight = this.SchedulingPeriod.MasterWeights.NoNightShiftBeforeFreeWeekend;
            if (this.Contract.NoNightShiftBeforeFreeWeekendWeight > -1) {
                weight = this.Contract.NoNightShiftBeforeFreeWeekendWeight;
            }
            array.add(new NoNightShiftBeforeFreeWeekend(weight));
        }
        if (this.Contract.TwoFreeDaysAfterNightShifts) {
            weight = this.SchedulingPeriod.MasterWeights.TwoFreeDaysAfterNightShifts;
            if (this.Contract.TwoFreeDaysAfterNightShiftsWeight > -1) {
                weight = this.Contract.TwoFreeDaysAfterNightShiftsWeight;
            }
            array.add(new TwoFreeDaysAfterNightShifts(weight));
        }
        if (this.Contract.MaxAssignmentsForDayOfWeekIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MaxAssignmentsForDayOfWeek;
            if (this.Contract.MaxAssignmentsForDayOfWeekWeight > -1) {
                weight = this.Contract.MaxAssignmentsForDayOfWeekWeight;
            }
            array.add(new MaxAssignmentsForDayOfWeek(weight));
        }
        if (this.Contract.ValidNumConsecutiveShiftTypesIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.ValidNumConsecutiveShiftTypes;
            if (this.Contract.ValidNumConsecutiveShiftTypesWeight > -1) {
                weight = this.Contract.ValidNumConsecutiveShiftTypesWeight;
            }
            array.add(new NumConsecutiveShiftTypes(weight));
        }
        if (this.Contract.ValidNumConsecutiveShiftGroupsIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.ValidNumConsecutiveShiftGroups;
            if (this.Contract.ValidNumConsecutiveShiftGroupsWeight > -1) {
                weight = this.Contract.ValidNumConsecutiveShiftGroupsWeight;
            }
            array.add(new NumConsecutiveShiftGroups(weight));
        }
        if (this.Contract.MaxShiftTypesPerWeekIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MaxShiftTypesPerWeek;
            if (this.Contract.MaxShiftTypesPerWeekWeight > -1) {
                weight = this.Contract.MaxShiftTypesPerWeekWeight;
            }
            array.add(new MaxShiftTypesPerWeek(weight));
        }
        if (this.Contract.MaxHoursWorkedIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MaxHoursWorked;
            if (this.Contract.MaxHoursWorkedWeight > -1) {
                weight = this.Contract.MaxHoursWorkedWeight;
            }
            array.add(new MaxHoursWorked(weight));
        }
        if (this.Contract.MinHoursWorkedIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MinHoursWorked;
            if (this.Contract.MinHoursWorkedWeight > -1) {
                weight = this.Contract.MinHoursWorkedWeight;
            }
            array.add(new MinHoursWorked(weight));
        }
        if (this.Contract.AlternativeSkillCategory) {
            weight = this.SchedulingPeriod.MasterWeights.AlternativeSkillCategory;
            if (this.Contract.AlternativeSkillCategoryWeight > -1) {
                weight = this.Contract.AlternativeSkillCategoryWeight;
            }
            array.add(new AlternativeSkillCategory(weight));
        }
        if (this.TutorCount > 0 && this.SchedulingPeriod.MasterWeights.Tutorship > 0) {
            weight = this.SchedulingPeriod.MasterWeights.Tutorship;
            array.add(new Tutorship(weight));
        }
        if (this.AvoidPartnershipsCount > 0 && this.SchedulingPeriod.MasterWeights.WorkSeparately > 0) {
            weight = this.SchedulingPeriod.MasterWeights.WorkSeparately;
            array.add(new WorkSeparately(weight));
        }
        if (this.DaysOffRequestBetweenDatesCount > 0) {
            array.add(new DaysOffRequestsBetweenDates());
        }
        if (this.SchedulingPeriod.ShiftsRequireSkills && this.SchedulingPeriod.MasterWeights.SkilledShifts > 0) {
            array.add(new SkilledShifts(this.SchedulingPeriod.MasterWeights.SkilledShifts));
        }
        if (!this.AvailableDuringEntirePeriod && this.SchedulingPeriod.MasterWeights.EmployeeAvailability > 0) {
            array.add(new EmployeeAvailability(this.SchedulingPeriod.MasterWeights.EmployeeAvailability));
        }
        if (this.Contract.MaxShiftsPerWeekStartMonIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MaxShiftsPerWeekStartMon;
            if (this.Contract.MaxShiftsPerWeekStartMonWeight > -1) {
                weight = this.Contract.MaxShiftsPerWeekStartMonWeight;
            }
            array.add(new MaxShiftsPerWeekStartMon(weight));
        }
        if (this.Contract.MinShiftsPerWeekStartMonIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MinShiftsPerWeekStartMon;
            if (this.Contract.MinShiftsPerWeekStartMonWeight > -1) {
                weight = this.Contract.MinShiftsPerWeekStartMonWeight;
            }
            array.add(new MinShiftsPerWeekStartMon(weight));
        }
        if (this.Contract.MaxHoursPerWeekIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MaxHoursPerWeek;
            if (this.Contract.MaxHoursPerWeekWeight > -1) {
                weight = this.Contract.MaxHoursPerWeekWeight;
            }
            array.add(new MaxHoursPerWeek(weight));
        }
        if (this.Contract.MaxHoursPerFortnightIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MaxHoursPerFortnight;
            if (this.Contract.MaxHoursPerFortnightWeight > -1) {
                weight = this.Contract.MaxHoursPerFortnightWeight;
            }
            array.add(new MaxHoursPerFortnight(weight));
        }
        if (this.Contract.MaxWeekendDaysIsOn) {
            weight = this.SchedulingPeriod.MasterWeights.MaxWeekendDays;
            if (this.Contract.MaxWeekendDaysWeight > -1) {
                weight = this.Contract.MaxWeekendDaysWeight;
            }
            array.add(new MaxWeekendDays(weight));
        }
        if (this.Contract.BadPatternsIsOn) {
            this.BadPatternConstraint = new BadPatterns(this);
            array.add(this.BadPatternConstraint);
        }
        if (this.Contract.GoodPatternsIsOn) {
            array.add(new GoodPatterns());
        }
        if (this.DayOffRequestCount > 0) {
            array.add(new RequestedDaysOff());
            this.UsesConstraintANROMRequestedDaysOff = true;
        }
        if (this.DayOnRequestCount > 0) {
            array.add(new RequestedDaysOn());
            this.UsesConstraintANROMRequestedDaysOn = true;
        }
        if (this.ShiftOffRequestCount > 0) {
            array.add(new RequestedShiftsOff());
            this.UsesConstraintANROMRequestedShiftsOff = true;
        }
        if (this.ShiftOnRequestCount > 0) {
            array.add(new RequestedShiftsOn());
            this.UsesConstraintANROMRequestedShiftsOn = true;
        }
        if (this.ShiftGroupOnRequests != null && this.ShiftGroupOnRequests.length > 0) {
            array.add(new RequestedShiftGroupsOn());
            this.UsesConstraintQMCRequestedShiftGroupsOn = true;
        }
        this.AllSoftConstraints = array.toArray(this.AllSoftConstraints);
    }

    public String toString() {
        return this.getName();
    }

    public static enum SkillType {
        Primary,
        Secondary;

    }
}

