/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Parsers;

import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.Parsers.ParsedShiftAssignment;
import ASAP.NRP.Core.Roster;
import ASAP.NRP.Core.SchedulingPeriod;
import ASAP.NRP.Core.Shift;
import java.util.ArrayList;

public class ParsedRoster {
    public String OrganisationID = null;
    public String Penalty = null;
    public String TimeStamp = null;
    public String Algorithm = null;
    public String CpuTime = null;
    public String Evaluations = null;
    public String CPU = null;
    public String system = null;
    public String FoundBy = null;
    public String DateFound = null;
    public String SchedulingPeriodID;
    public Roster Roster = null;
    public ArrayList<ParsedShiftAssignment> ParsedShiftAssignments;

    public ParsedRoster(String schedulingPeriodID) {
        this.SchedulingPeriodID = schedulingPeriodID;
        this.ParsedShiftAssignments = new ArrayList();
    }

    public boolean AddParsedShiftAssignment(ParsedShiftAssignment parsedShiftAssignment) {
        this.ParsedShiftAssignments.add(parsedShiftAssignment);
        return true;
    }

    public void CreateRoster(SchedulingPeriod schedulingPeriod) {
        this.Roster = new Roster(schedulingPeriod);
        for (ParsedShiftAssignment sa : this.ParsedShiftAssignments) {
            if (ParsedRoster.AssignShift(this.Roster, sa)) continue;
            System.out.println("Error creating roster from file. Unable to assign a shift... ");
        }
        this.Roster.RecalculateAllPenalties();
    }

    public static boolean AssignShift(Roster roster, ParsedShiftAssignment sa) {
        Employee employee = roster.GetEmployee(sa.EmployeeID);
        if (employee == null) {
            return false;
        }
        Shift shift = new Shift(roster.SchedulingPeriod.GetShiftType(sa.ShiftTypeID), sa.Date, roster.SchedulingPeriod);
        int violationCount = employee.ViolationsForAssigningShift(shift);
        if (violationCount == -1) {
            return false;
        }
        roster.AssignShift(employee, shift);
        return true;
    }
}

