/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core;

import ASAP.NRP.Core.BankHoliday;
import ASAP.NRP.Core.CSharpConversionHelper;
import ASAP.NRP.Core.Constraints.QMC.ShiftGroupRequest;
import ASAP.NRP.Core.CoverRequirement;
import ASAP.NRP.Core.CoverRequirements;
import ASAP.NRP.Core.DateTime;
import ASAP.NRP.Core.DayOffRequest;
import ASAP.NRP.Core.DayOnRequest;
import ASAP.NRP.Core.DayPeriod;
import ASAP.NRP.Core.DaysOffRequestBetweenDates;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.MasterWeights;
import ASAP.NRP.Core.Parsers.Cover;
import ASAP.NRP.Core.Parsers.CoverSpecification;
import ASAP.NRP.Core.Period;
import ASAP.NRP.Core.ShiftGroup;
import ASAP.NRP.Core.ShiftRequest;
import ASAP.NRP.Core.ShiftType;
import ASAP.NRP.Core.Skill;
import ASAP.NRP.Core.SkillGroup;
import ASAP.NRP.Core.TimeSpan;
import java.util.ArrayList;
import java.util.Hashtable;

public class SchedulingPeriod {
    ShiftType[] ShiftTypes = new ShiftType[0];
    EmployeeDescription[] EmployeeDescriptions = new EmployeeDescription[0];
    ShiftGroup[] ShiftGroups = new ShiftGroup[0];
    SkillGroup[] SkillGroups = new SkillGroup[0];
    DayPeriod[] DayPeriods = new DayPeriod[0];
    Hashtable<String, EmployeeDescription> EmployeeDescriptionsHash = new Hashtable();
    Hashtable<String, ShiftType> ShiftTypesHash = new Hashtable();
    Hashtable<String, ShiftGroup> ShiftGroupsHash = new Hashtable();
    Hashtable<String, SkillGroup> SkillGroupsHash = new Hashtable();
    Hashtable<String, BankHoliday> BankHolidaysHash = new Hashtable();
    Hashtable<String, Skill> SkillsHash = new Hashtable();
    ArrayList<ShiftType> ShiftTypesArrayList = new ArrayList();
    ArrayList<Skill> SkillsArrayList = new ArrayList();
    public String OrganisationID = "";
    public String DepartmentID = null;
    public String FilePath = null;
    public DateTime StartDate;
    public DateTime EndDate;
    public MasterWeights MasterWeights = null;
    public int NumDaysInPeriod = 0;
    public int FirstSunday = -1;
    public int FirstMonday = -1;
    public int FirstTuesday = -1;
    public int FirstWednesday = -1;
    public int FirstThursday = -1;
    public int FirstFriday = -1;
    public int FirstSaturday = -1;
    public int EmployeesCount = 0;
    public int NumWeekendsInPeriod = 0;
    public int ShiftTypesCount = 0;
    public int ShiftGroupsCount = 0;
    public int SkillGroupsCount = 0;
    public int NumWeeksInPeriod = 0;
    public int SkillsCount = 0;
    public int MondayPatternIndex;
    public int TuesdayPatternIndex;
    public int WednesdayPatternIndex;
    public int ThursdayPatternIndex;
    public int FridayPatternIndex;
    public int SaturdayPatternIndex;
    public int SundayPatternIndex;
    public boolean[] BankHolidayArray;
    int[][] sameDayOverlappingMinutes;
    int[][] overlappingMinutes;
    boolean[][] employeeHasSkillsForShiftType;
    boolean[][] employeeUsesSecondarySkillForShiftType;
    boolean[][] employeeHasSkillForCover;
    public CoverRequirements CoverRequirements;
    int[][] shiftGroupsContainingShift;
    boolean[][] shiftGroupContainsShiftType;
    public boolean ShiftsRequireSkills = false;
    public boolean ContainsInitialAssignments = false;
    public String SchedulingPeriodID = "";
    public boolean HistoryLoadedFromSchedulingPeriodFile = false;

    public SchedulingPeriod(DateTime startDate, DateTime endDate) {
        this.StartDate = startDate;
        this.EndDate = endDate;
        this.MasterWeights = new MasterWeights();
        this.CoverRequirements = new CoverRequirements(this);
        this.CalculateNumDaysInPeriod();
        this.BankHolidayArray = new boolean[this.NumDaysInPeriod];
        this.CalculateFirstDays();
        this.CalculateNumWeekendsInPeriod();
        this.CalculateNumWeeksInPeriod();
        this.CalculatePatternDays();
    }

    public int getBankHolidayCount() {
        return this.BankHolidaysHash.size();
    }

    public int getDayPeriodsCount() {
        return this.DayPeriods.length;
    }

    public boolean AddBankHoliday(BankHoliday bankHoliday) {
        String ID = bankHoliday.ID;
        if (this.BankHolidaysHash.containsKey(ID)) {
            System.out.println("Unable to add BankHoliday : " + ID + " as BankHoliday with same ID already exists.");
            return false;
        }
        if (!this.IsDateWithinSchedulingPeriod(bankHoliday.Date)) {
            System.out.println("Unable to add BankHoliday : " + ID + " as the BankHoliday's date is not within the schedulingPeriod's range.");
            return false;
        }
        this.BankHolidaysHash.put(ID, bankHoliday);
        int day = this.ConvertDateToRosterDay(bankHoliday.Date);
        if (this.BankHolidayArray[day]) {
            System.out.println("Warning: There appears to be more than one bank holiday defined for day: " + bankHoliday.Date);
        } else {
            this.BankHolidayArray[day] = true;
        }
        return true;
    }

    public boolean AddEmployeeDescription(EmployeeDescription employeeDescription) {
        String employeeDescriptionID = employeeDescription.ID;
        if (this.EmployeeDescriptionsHash.containsKey(employeeDescriptionID)) {
            System.out.println("Unable to add Employee : " + employeeDescriptionID + " as employeeDescription with same ID already exists.");
            return false;
        }
        this.EmployeeDescriptionsHash.put(employeeDescriptionID, employeeDescription);
        employeeDescription.IndexID = this.EmployeeDescriptionsHash.size() - 1;
        this.EmployeesCount = this.EmployeeDescriptionsHash.size();
        this.EmployeeDescriptions = CSharpConversionHelper.ArrayResize(this.EmployeeDescriptions, this.EmployeeDescriptions.length + 1);
        this.EmployeeDescriptions[this.EmployeeDescriptions.length - 1] = employeeDescription;
        return true;
    }

    public String GetNewSkillID() {
        int i = 0;
        while (i < 100000) {
            String key = Integer.toString(i);
            if (!this.SkillsHash.containsKey(key)) {
                return key;
            }
            ++i;
        }
        System.out.println("Warning : Unable to generate new Skill ID");
        return "";
    }

    public void DeleteShiftType(ShiftType shiftType) {
        if (shiftType == null) {
            return;
        }
        String shiftTypeID = shiftType.ID;
        if (!this.ShiftTypesHash.contains(shiftTypeID)) {
            return;
        }
        --this.ShiftTypesCount;
        this.ShiftTypesHash.remove(shiftTypeID);
        this.ShiftTypesArrayList.remove(shiftType);
        this.ShiftTypesChanged();
    }

    public void DeleteSkill(Skill skill) {
        if (skill == null || !this.SkillsHash.contains(skill.ID)) {
            return;
        }
        this.SkillsArrayList.remove(skill);
        this.SkillsHash.remove(skill.ID);
        --this.SkillsCount;
        EmployeeDescription[] employeeDescriptionArray = this.EmployeeDescriptions;
        int n = this.EmployeeDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            EmployeeDescription employee = employeeDescriptionArray[n2];
            employee.DeleteSkill(skill);
            ++n2;
        }
        boolean skillsRequired = false;
        ShiftType[] shiftTypeArray = this.ShiftTypes;
        int n3 = this.ShiftTypes.length;
        n = 0;
        while (n < n3) {
            ShiftType shiftType = shiftTypeArray[n];
            int count = shiftType.DeleteSkill(skill);
            if (count > 0) {
                skillsRequired = true;
            }
            ++n;
        }
        this.ShiftsRequireSkills = skillsRequired;
    }

    public EmployeeDescription GetEmployeeDescription(String employeeDescriptionID) {
        EmployeeDescription obj = this.EmployeeDescriptionsHash.get(employeeDescriptionID);
        if (obj == null) {
            return null;
        }
        return obj;
    }

    public EmployeeDescription GetEmployeeDescription(int index) {
        return this.EmployeeDescriptions[index];
    }

    public boolean AddShiftType(ShiftType shiftType) {
        String shiftTypeID = shiftType.ID;
        if (this.ShiftTypesHash.containsKey(shiftTypeID)) {
            System.out.println("Unable to add ShiftType : " + shiftTypeID + " as shift with same ID already exists.");
            return false;
        }
        shiftType.Index = this.ShiftTypesCount++;
        this.ShiftTypesHash.put(shiftTypeID, shiftType);
        this.ShiftTypesArrayList.add(shiftType);
        this.ShiftTypesChanged();
        return true;
    }

    private void ShiftTypesChanged() {
        this.SortShiftTypes();
        this.ShiftTypes = this.ShiftTypesArrayList.toArray(this.ShiftTypes);
        this.sameDayOverlappingMinutes = new int[this.ShiftTypesCount][this.ShiftTypesCount];
        this.overlappingMinutes = new int[this.ShiftTypesCount][this.ShiftTypesCount];
        int i = 0;
        while (i < this.ShiftTypesCount) {
            int j = 0;
            while (j < this.ShiftTypesCount) {
                this.sameDayOverlappingMinutes[i][j] = ShiftType.OverlappingMinutes(this.ShiftTypes[i], this.ShiftTypes[j], true);
                this.overlappingMinutes[i][j] = ShiftType.OverlappingMinutes(this.ShiftTypes[i], this.ShiftTypes[j], false);
                ++j;
            }
            ++i;
        }
    }

    public boolean AddShiftGroup(ShiftGroup shiftGroup) {
        String ID = shiftGroup.ID;
        if (this.ShiftGroupsHash.containsKey(ID)) {
            System.out.println("Unable to add ShiftGroup : " + ID + " as a ShiftGroup with the same ID already exists.");
            return false;
        }
        shiftGroup.Index = this.ShiftGroupsCount++;
        this.ShiftGroupsHash.put(ID, shiftGroup);
        this.ShiftGroups = CSharpConversionHelper.ArrayResize(this.ShiftGroups, this.ShiftGroups.length + 1);
        this.ShiftGroups[this.ShiftGroups.length - 1] = shiftGroup;
        return true;
    }

    public boolean AddSkill(Skill skill) {
        for (Skill skill2 : this.SkillsArrayList) {
            if (!skill.ID.equals(skill2.ID)) continue;
            System.out.println("Unable to add Skill : " + skill.ID + " as a Skill with the same ID already exists.");
            return false;
        }
        ++this.SkillsCount;
        this.SkillsHash.put(skill.ID, skill);
        this.SkillsArrayList.add(skill);
        return true;
    }

    public boolean AddSkillGroup(SkillGroup skillGroup) {
        String ID = skillGroup.ID;
        if (this.SkillGroupsHash.containsKey(ID)) {
            System.out.println("Unable to add SkillGroup : " + ID + " as a SkillGroup with the same ID already exists.");
            return false;
        }
        skillGroup.Index = this.SkillGroupsCount++;
        this.SkillGroupsHash.put(ID, skillGroup);
        this.SkillGroups = CSharpConversionHelper.ArrayResize(this.SkillGroups, this.SkillGroups.length + 1);
        this.SkillGroups[this.SkillGroups.length - 1] = skillGroup;
        return true;
    }

    private void SortShiftTypes() {
        int i = 0;
        while (i < this.ShiftTypesCount) {
            int j = 1;
            while (j < this.ShiftTypesCount - i) {
                ShiftType type1 = this.ShiftTypesArrayList.get(j - 1);
                ShiftType type2 = this.ShiftTypesArrayList.get(j);
                if (type2.getStartTime().isLessThan(type1.getStartTime()) || type2.getStartTime().getTicks() == type1.getStartTime().getTicks() && type2.getDuration() < type1.getDuration()) {
                    this.ShiftTypesArrayList.set(j, type1);
                    this.ShiftTypesArrayList.set(j - 1, type2);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.ShiftTypesCount) {
            this.ShiftTypesArrayList.get((int)i).Index = i;
            ++i;
        }
    }

    public ShiftType GetShiftType(String shiftTypeID) {
        ShiftType obj = this.ShiftTypesHash.get(shiftTypeID);
        if (obj == null) {
            return null;
        }
        return obj;
    }

    public ShiftType GetShiftType(int index) {
        return this.ShiftTypes[index];
    }

    public ShiftType GetShiftTypeByLabel(String label) {
        ShiftType[] shiftTypeArray = this.ShiftTypes;
        int n = this.ShiftTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ShiftType st = shiftTypeArray[n2];
            if (st.Label == label) {
                return st;
            }
            ++n2;
        }
        return null;
    }

    public ShiftGroup GetShiftGroup(String ID) {
        return this.ShiftGroupsHash.get(ID);
    }

    public ShiftGroup GetShiftGroup(int index) {
        return this.ShiftGroups[index];
    }

    public ShiftGroup GetShiftGroup(ShiftType[] shifts) {
        int i = 0;
        while (i < this.ShiftGroups.length) {
            ShiftGroup grp = this.ShiftGroups[i];
            if (grp.Group.length == shifts.length) {
                boolean match = true;
                int j = 0;
                while (j < shifts.length) {
                    if (!grp.Contains(shifts[j].ID)) {
                        match = false;
                        break;
                    }
                    ++j;
                }
                if (match) {
                    return grp;
                }
            }
            ++i;
        }
        return null;
    }

    public Skill GetSkill(String ID) {
        return this.SkillsHash.get(ID);
    }

    public SkillGroup GetSkillGroup(String ID) {
        return this.SkillGroupsHash.get(ID);
    }

    public SkillGroup GetSkillGroup(int index) {
        return this.SkillGroups[index];
    }

    public DayPeriod GetDayPeriod(Period period) {
        int i = 0;
        while (i < this.DayPeriods.length) {
            if (this.DayPeriods[i].Period.equals(period)) {
                return this.DayPeriods[i];
            }
            ++i;
        }
        return null;
    }

    public DayPeriod GetDayPeriod(int index) {
        return this.DayPeriods[index];
    }

    public Skill GetSkill(int index) {
        return this.SkillsArrayList.get(index);
    }

    public int OverlappingMinutes(ShiftType shiftType1, ShiftType shiftType2, boolean sameDay) {
        if (sameDay) {
            return this.sameDayOverlappingMinutes[shiftType1.Index][shiftType2.Index];
        }
        return this.overlappingMinutes[shiftType1.Index][shiftType2.Index];
    }

    private void CalculatePatternDays() {
        switch (this.StartDate.getDayOfWeek()) {
            case 2: {
                this.MondayPatternIndex = 0;
                this.TuesdayPatternIndex = 1;
                this.WednesdayPatternIndex = 2;
                this.ThursdayPatternIndex = 3;
                this.FridayPatternIndex = 4;
                this.SaturdayPatternIndex = 5;
                this.SundayPatternIndex = 6;
                break;
            }
            case 3: {
                this.MondayPatternIndex = 6;
                this.TuesdayPatternIndex = 0;
                this.WednesdayPatternIndex = 1;
                this.ThursdayPatternIndex = 2;
                this.FridayPatternIndex = 3;
                this.SaturdayPatternIndex = 4;
                this.SundayPatternIndex = 5;
                break;
            }
            case 4: {
                this.MondayPatternIndex = 5;
                this.TuesdayPatternIndex = 6;
                this.WednesdayPatternIndex = 0;
                this.ThursdayPatternIndex = 1;
                this.FridayPatternIndex = 2;
                this.SaturdayPatternIndex = 3;
                this.SundayPatternIndex = 4;
                break;
            }
            case 5: {
                this.MondayPatternIndex = 4;
                this.TuesdayPatternIndex = 5;
                this.WednesdayPatternIndex = 6;
                this.ThursdayPatternIndex = 0;
                this.FridayPatternIndex = 1;
                this.SaturdayPatternIndex = 2;
                this.SundayPatternIndex = 3;
                break;
            }
            case 6: {
                this.MondayPatternIndex = 3;
                this.TuesdayPatternIndex = 4;
                this.WednesdayPatternIndex = 5;
                this.ThursdayPatternIndex = 6;
                this.FridayPatternIndex = 0;
                this.SaturdayPatternIndex = 1;
                this.SundayPatternIndex = 2;
                break;
            }
            case 7: {
                this.MondayPatternIndex = 2;
                this.TuesdayPatternIndex = 3;
                this.WednesdayPatternIndex = 4;
                this.ThursdayPatternIndex = 5;
                this.FridayPatternIndex = 6;
                this.SaturdayPatternIndex = 0;
                this.SundayPatternIndex = 1;
                break;
            }
            case 1: {
                this.MondayPatternIndex = 1;
                this.TuesdayPatternIndex = 2;
                this.WednesdayPatternIndex = 3;
                this.ThursdayPatternIndex = 4;
                this.FridayPatternIndex = 5;
                this.SaturdayPatternIndex = 6;
                this.SundayPatternIndex = 0;
                break;
            }
            default: {
                this.MondayPatternIndex = 0;
                this.TuesdayPatternIndex = 1;
                this.WednesdayPatternIndex = 2;
                this.ThursdayPatternIndex = 3;
                this.FridayPatternIndex = 4;
                this.SaturdayPatternIndex = 5;
                this.SundayPatternIndex = 6;
            }
        }
    }

    private void CalculateFirstDays() {
        this.FirstSunday = -1;
        this.FirstMonday = -1;
        this.FirstTuesday = -1;
        this.FirstWednesday = -1;
        this.FirstThursday = -1;
        this.FirstFriday = -1;
        this.FirstSaturday = -1;
        int i = 0;
        while (i < 7 && i < this.NumDaysInPeriod) {
            switch (this.StartDate.AddDays(i).getDayOfWeek()) {
                case 2: {
                    this.FirstMonday = i;
                    break;
                }
                case 3: {
                    this.FirstTuesday = i;
                    break;
                }
                case 4: {
                    this.FirstWednesday = i;
                    break;
                }
                case 5: {
                    this.FirstThursday = i;
                    break;
                }
                case 6: {
                    this.FirstFriday = i;
                    break;
                }
                case 7: {
                    this.FirstSaturday = i;
                    break;
                }
                case 1: {
                    this.FirstSunday = i;
                    break;
                }
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void CalculateNumWeekendsInPeriod() {
        this.CalculateFirstDays();
        this.NumWeekendsInPeriod = 0;
        saturdayIndex = this.FirstSaturday;
        if (saturdayIndex >= 0) ** GOTO lbl8
        return;
lbl-1000:
        // 1 sources

        {
            saturdayIndex += 7;
            ++this.NumWeekendsInPeriod;
lbl8:
            // 2 sources

            ** while (saturdayIndex < this.NumDaysInPeriod)
        }
lbl9:
        // 1 sources

    }

    private void CalculateNumWeeksInPeriod() {
        double num = (double)this.NumDaysInPeriod / 7.0;
        this.NumWeeksInPeriod = (int)Math.ceil(num);
    }

    private void CalculateNumDaysInPeriod() {
        TimeSpan diff = this.EndDate.subtract(this.StartDate);
        this.NumDaysInPeriod = (int)Math.ceil(diff.TotalDays);
    }

    public boolean IsDateWithinSchedulingPeriod(DateTime date) {
        if (DateTime.compare(this.StartDate, date) > 0L) {
            return false;
        }
        return DateTime.compare(date, this.EndDate.AddHours(-24)) <= 0L;
    }

    public boolean IsDayWithinSchedulingPeriod(int day) {
        return day >= 0 && day < this.NumDaysInPeriod;
    }

    public int ConvertDateToRosterDay(DateTime date) {
        TimeSpan diff = date.subtract(this.StartDate);
        int day = (int)Math.floor(diff.TotalDays);
        return day;
    }

    public double TestConvertDateToRosterDay(DateTime date) {
        TimeSpan diff = date.subtract(this.StartDate);
        return diff.TotalDays;
    }

    public int ConvertDateToWeek(DateTime date) {
        TimeSpan diff = date.subtract(this.StartDate);
        if (diff.TotalDays <= 0.0) {
            return 1;
        }
        double week = diff.TotalDays / 7.0;
        int w = (int)Math.floor(week);
        return w + 1;
    }

    public DateTime ConvertRosterDayToDate(int day) {
        return this.StartDate.AddDays(day);
    }

    public boolean RequestDaysOffBetweenDates(String employeeID, int weight, DateTime StartDate, DateTime EndDate, int MinimumDaysOff, int MaximumDaysOff, boolean holiday) {
        if (weight <= 0) {
            return false;
        }
        EmployeeDescription employee = this.GetEmployeeDescription(employeeID);
        if (employee == null) {
            System.out.println("Unable to request days off. Unknown employee: " + employeeID);
            return false;
        }
        if (!this.IsDateWithinSchedulingPeriod(StartDate)) {
            System.out.println("Unable to request days off. Date : " + StartDate + " out of scheduling range.");
            return false;
        }
        if (!this.IsDateWithinSchedulingPeriod(EndDate)) {
            System.out.println("Unable to request days off. Date : " + EndDate + " out of scheduling range.");
            return false;
        }
        int start = this.ConvertDateToRosterDay(StartDate);
        int end = this.ConvertDateToRosterDay(EndDate);
        DaysOffRequestBetweenDates request = new DaysOffRequestBetweenDates(start, end, MinimumDaysOff, MaximumDaysOff, weight);
        employee.AddDaysOffRequestBetweenDates(request);
        return true;
    }

    public boolean RequestDayOff(String employeeID, int day, DateTime date, int weight, boolean holiday, boolean working) {
        if (weight <= 0) {
            return false;
        }
        EmployeeDescription employee = this.GetEmployeeDescription(employeeID);
        if (employee == null) {
            System.out.println("Unable to request day off. Unknown employee: " + employeeID);
            return false;
        }
        if (employee.DayOffRequests[day] == 0 && weight > 0) {
            employee.DayOffRequestObjs.add(new DayOffRequest(date, weight, working, holiday));
            ++employee.DayOffRequestCount;
        }
        employee.DayOffRequests[day] = weight;
        employee.DayOffRequestIsHoliday[day] = holiday;
        employee.DayOffRequestIsWork[day] = working;
        return true;
    }

    public boolean RequestDayOn(String employeeID, int day, DateTime date, int weight) {
        if (weight <= 0) {
            return false;
        }
        EmployeeDescription employee = this.GetEmployeeDescription(employeeID);
        if (employee == null) {
            System.out.println("Unable to request day on. Unknown employee: " + employeeID);
            return false;
        }
        if (employee.DayOnRequests[day] == 0 && weight > 0) {
            ++employee.DayOnRequestCount;
            employee.DayOnRequestObjs.add(new DayOnRequest(date, weight));
        }
        employee.DayOnRequests[day] = weight;
        return true;
    }

    public boolean RequestShiftOff(String employeeID, String shiftTypeID, int day, DateTime date, int weight) {
        if (weight <= 0) {
            return false;
        }
        EmployeeDescription employee = this.GetEmployeeDescription(employeeID);
        if (employee == null) {
            System.out.println("Unable to request shift off. Unknown Employee: " + employeeID);
            return false;
        }
        ShiftType shiftType = this.GetShiftType(shiftTypeID);
        if (shiftType == null) {
            System.out.println("Unable to request shift off. Unknown ShiftType: " + shiftTypeID);
            return false;
        }
        int index = day * this.ShiftTypesCount + shiftType.Index;
        if (employee.ShiftOffRequests[index] == 0 && weight > 0) {
            ++employee.ShiftOffRequestCount;
            employee.ShiftOffRequestObjs.add(new ShiftRequest(date, shiftType, weight));
        }
        employee.ShiftOffRequests[index] = weight;
        return true;
    }

    public boolean RequestShiftOn(String employeeID, String shiftTypeID, int day, DateTime date, int weight) {
        if (weight <= 0) {
            return false;
        }
        EmployeeDescription employee = this.GetEmployeeDescription(employeeID);
        if (employee == null) {
            System.out.println("Unable to request shift on. Unknown Employee: " + employeeID);
            return false;
        }
        ShiftType shiftType = this.GetShiftType(shiftTypeID);
        if (shiftType == null) {
            System.out.println("Unable to request shift on. Unknown ShiftType: " + shiftTypeID);
            return false;
        }
        int index = day * this.ShiftTypesCount + shiftType.Index;
        if (employee.ShiftOnRequests[index] == 0 && weight > 0) {
            ++employee.ShiftOnRequestCount;
            employee.ShiftOnRequestObjs.add(new ShiftRequest(date, shiftType, weight));
        }
        employee.ShiftOnRequests[index] = weight;
        return true;
    }

    public boolean RequestShiftGroupOn(String employeeID, String shiftGroupID, int day, DateTime date, int weight) {
        EmployeeDescription employee = this.GetEmployeeDescription(employeeID);
        if (employee == null) {
            System.out.println("Unable to request shift group on. Unknown Employee: " + employeeID);
            return false;
        }
        ShiftGroup shiftGroup = this.GetShiftGroup(shiftGroupID);
        if (shiftGroup == null) {
            System.out.println("Unable to request shift group on. Unknown ShiftGroup: " + shiftGroupID);
            return false;
        }
        ShiftGroupRequest request = new ShiftGroupRequest(shiftGroup, day, date, weight);
        employee.AddShiftGroupOnRequest(request);
        return true;
    }

    public boolean RequestShiftGroupOn(String employeeID, ArrayList<ShiftType> shifts, int day, DateTime date, int weight) {
        if (shifts.size() == 0) {
            return false;
        }
        EmployeeDescription employee = this.GetEmployeeDescription(employeeID);
        if (employee == null) {
            System.out.println("Unable to request shift group on. Unknown Employee: " + employeeID);
            return false;
        }
        ShiftGroup shiftGroup = new ShiftGroup("");
        for (ShiftType s : shifts) {
            shiftGroup.AddShiftType(s, false);
        }
        ShiftGroupRequest request = new ShiftGroupRequest(shiftGroup, day, date, weight);
        this.RequestShiftGroupOn(employee, request);
        return true;
    }

    public void RequestShiftGroupOn(EmployeeDescription employee, ShiftGroupRequest request) {
        employee.AddShiftGroupOnRequest(request);
    }

    public boolean RequestCollaboration(String employee1ID, String employee2ID) {
        EmployeeDescription employee1 = this.GetEmployeeDescription(employee1ID);
        EmployeeDescription employee2 = this.GetEmployeeDescription(employee2ID);
        if (employee1 == null) {
            System.out.println("Unable to request collaboration. Unknown Employee: " + employee1ID);
            return false;
        }
        if (employee2 == null) {
            System.out.println("Unable to request collaboration. Unknown Employee: " + employee2ID);
            return false;
        }
        employee2.AddTutor(employee1);
        return true;
    }

    public boolean RequestSeparation(String employee1ID, String employee2ID) {
        EmployeeDescription employee1 = this.GetEmployeeDescription(employee1ID);
        EmployeeDescription employee2 = this.GetEmployeeDescription(employee2ID);
        if (employee1 == null) {
            System.out.println("Unable to request collaboration. Unknown Employee: " + employee1ID);
            return false;
        }
        if (employee2 == null) {
            System.out.println("Unable to request collaboration. Unknown Employee: " + employee2ID);
            return false;
        }
        employee1.AvoidPartnership(employee2);
        return true;
    }

    public void ParsingFinished() {
        EmployeeDescription employeeDescription;
        ShiftType shiftType;
        ShiftType[] shiftTypeArray = this.ShiftTypes;
        int n = this.ShiftTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ShiftType shiftType2 = shiftTypeArray[n2];
            if (shiftType2.RequiresSkills) {
                this.ShiftsRequireSkills = true;
                break;
            }
            ++n2;
        }
        ArrayList<Period> periods = new ArrayList<Period>();
        for (CoverSpecification spec : this.CoverRequirements.GetCoverSpecifications()) {
            for (Cover cover : spec.CoverRequirements) {
                if (cover.Type != Cover.CoverType.Period || periods.contains(cover.Period)) continue;
                periods.add(cover.Period);
            }
        }
        boolean splitFound = true;
        block3: while (splitFound) {
            splitFound = false;
            int i = 0;
            while (i < this.ShiftTypesCount) {
                ShiftType s = this.GetShiftType(i);
                int removeIndex = -1;
                int j = 0;
                while (j < periods.size()) {
                    Period p3;
                    Period p2;
                    Period p1;
                    Period p = (Period)periods.get(j);
                    DateTime pStartTime = p.getStartTime();
                    DateTime pEndTime = p.getEndTime();
                    if (s.getStartTime().isLessThanOrEqual(pStartTime) && s.getEndTime().isGreaterThan(pStartTime) && s.getEndTime().isLessThan(pEndTime)) {
                        p1 = new Period(pStartTime, s.getEndTime());
                        p2 = new Period(s.getEndTime(), pEndTime);
                        if (!periods.contains(p1)) {
                            periods.add(p1);
                        }
                        if (!periods.contains(p2)) {
                            periods.add(p2);
                        }
                        removeIndex = j;
                        splitFound = true;
                        break;
                    }
                    if (s.getStartTime().isGreaterThan(pStartTime) && s.getStartTime().isLessThan(pEndTime) && s.getEndTime().isGreaterThanOrEqual(pEndTime)) {
                        p1 = new Period(pStartTime, s.getStartTime());
                        p2 = new Period(s.getStartTime(), pEndTime);
                        if (!periods.contains(p1)) {
                            periods.add(p1);
                        }
                        if (!periods.contains(p2)) {
                            periods.add(p2);
                        }
                        removeIndex = j;
                        splitFound = true;
                        break;
                    }
                    if (s.getStartTime().isGreaterThan(pStartTime) && s.getStartTime().isLessThan(pEndTime) && s.getEndTime().isLessThan(pEndTime)) {
                        p1 = new Period(pStartTime, s.getStartTime());
                        p2 = new Period(s.getStartTime(), s.getEndTime());
                        p3 = new Period(s.getEndTime(), pEndTime);
                        if (!periods.contains(p1)) {
                            periods.add(p1);
                        }
                        if (!periods.contains(p2)) {
                            periods.add(p2);
                        }
                        if (!periods.contains(p3)) {
                            periods.add(p3);
                        }
                        removeIndex = j;
                        splitFound = true;
                        break;
                    }
                    if (s.getSpansMidnight()) {
                        pStartTime = p.getStartTime().AddHours(24);
                        pEndTime = p.getEndTime().AddHours(24);
                        if (s.getStartTime().isLessThanOrEqual(pStartTime) && s.getEndTime().isGreaterThan(pStartTime) && s.getEndTime().isLessThan(pEndTime)) {
                            p1 = new Period(pStartTime, s.getEndTime());
                            p2 = new Period(s.getEndTime(), pEndTime);
                            if (!periods.contains(p1)) {
                                periods.add(p1);
                            }
                            if (!periods.contains(p2)) {
                                periods.add(p2);
                            }
                            removeIndex = j;
                            splitFound = true;
                            break;
                        }
                        if (s.getStartTime().isGreaterThan(pStartTime) && s.getStartTime().isLessThan(pEndTime) && s.getEndTime().isGreaterThanOrEqual(pEndTime)) {
                            p1 = new Period(pStartTime, s.getStartTime());
                            p2 = new Period(s.getStartTime(), pEndTime);
                            if (!periods.contains(p1)) {
                                periods.add(p1);
                            }
                            if (!periods.contains(p2)) {
                                periods.add(p2);
                            }
                            removeIndex = j;
                            splitFound = true;
                            break;
                        }
                        if (s.getStartTime().isGreaterThan(pStartTime) && s.getStartTime().isLessThan(pEndTime) && s.getEndTime().isLessThan(pEndTime)) {
                            p1 = new Period(pStartTime, s.getStartTime());
                            p2 = new Period(s.getStartTime(), s.getEndTime());
                            p3 = new Period(s.getEndTime(), pEndTime);
                            if (!periods.contains(p1)) {
                                periods.add(p1);
                            }
                            if (!periods.contains(p2)) {
                                periods.add(p2);
                            }
                            if (!periods.contains(p3)) {
                                periods.add(p3);
                            }
                            removeIndex = j;
                            splitFound = true;
                            break;
                        }
                    }
                    ++j;
                }
                if (splitFound) {
                    periods.remove(removeIndex);
                    continue block3;
                }
                ++i;
            }
        }
        for (CoverSpecification spec : this.CoverRequirements.GetCoverSpecifications()) {
            ArrayList<Cover> oldArray = spec.CoverRequirements;
            ArrayList<Cover> newArray = new ArrayList<Cover>();
            int i = 0;
            while (i < oldArray.size()) {
                Cover cover = oldArray.get(i);
                if (cover.Type == Cover.CoverType.Period) {
                    boolean match = false;
                    for (Period p : periods) {
                        Cover cover2;
                        if (p.getStartTime().isGreaterThanOrEqual(cover.Period.getStartTime()) && p.getEndTime().isLessThanOrEqual(cover.Period.getEndTime())) {
                            cover2 = (Cover)cover.Clone();
                            cover2.Period = p;
                            newArray.add(cover2);
                            match = true;
                            continue;
                        }
                        if (!cover.Period.SpansMidnight || !p.getStartTime().AddHours(24).isGreaterThanOrEqual(cover.Period.getStartTime()) || !p.getEndTime().AddHours(24).isLessThanOrEqual(cover.Period.getEndTime())) continue;
                        cover2 = (Cover)cover.Clone();
                        cover2.Period = p;
                        newArray.add(cover2);
                        match = true;
                    }
                    if (!match) {
                        newArray.add(cover);
                    }
                } else {
                    newArray.add(cover);
                }
                ++i;
            }
            spec.CoverRequirements.clear();
            spec.CoverRequirements.addAll(newArray);
        }
        this.DayPeriods = new DayPeriod[periods.size()];
        int i = 0;
        while (i < periods.size()) {
            Period period = (Period)periods.get(i);
            this.DayPeriods[i] = new DayPeriod(i, period);
            ++i;
        }
        i = 0;
        while (i < this.ShiftTypesCount) {
            shiftType = this.GetShiftType(i);
            int j = 0;
            while (j < this.DayPeriods.length) {
                DayPeriod period = this.DayPeriods[j];
                if (period.getStart().isGreaterThanOrEqual(shiftType.getStartTime()) && period.getEnd().isLessThanOrEqual(shiftType.getEndTime())) {
                    shiftType.AddPeriod(j);
                }
                if (shiftType.getSpansMidnight() && period.getStart().AddHours(24).isGreaterThanOrEqual(shiftType.getStartTime()) && period.getEnd().AddHours(24).isLessThanOrEqual(shiftType.getEndTime())) {
                    shiftType.AddNextDayPeriod(j);
                }
                ++j;
            }
            ++i;
        }
        this.CoverRequirements.UpdateCoverRequirementArrays();
        this.employeeHasSkillsForShiftType = new boolean[this.EmployeesCount][this.ShiftTypesCount];
        this.employeeUsesSecondarySkillForShiftType = new boolean[this.EmployeesCount][this.ShiftTypesCount];
        this.employeeHasSkillForCover = new boolean[this.EmployeesCount][this.CoverRequirements.Requirements.length];
        this.shiftGroupsContainingShift = new int[this.ShiftTypesCount][];
        this.shiftGroupContainsShiftType = new boolean[this.ShiftGroupsCount][this.ShiftTypesCount];
        int x = 0;
        while (x < this.EmployeesCount) {
            employeeDescription = this.GetEmployeeDescription(x);
            int i2 = 0;
            while (i2 < this.ShiftTypes.length) {
                ShiftType shiftType3 = this.ShiftTypes[i2];
                if (shiftType3.RequiresSkills) {
                    boolean hasSkills = true;
                    for (String str : shiftType3.GetSkills()) {
                        if (employeeDescription.HasSkillType(str, EmployeeDescription.SkillType.Primary) || employeeDescription.HasSkillType(str, EmployeeDescription.SkillType.Secondary)) continue;
                        hasSkills = false;
                        break;
                    }
                    this.employeeHasSkillsForShiftType[employeeDescription.IndexID][shiftType3.Index] = hasSkills;
                } else {
                    this.employeeHasSkillsForShiftType[employeeDescription.IndexID][shiftType3.Index] = true;
                }
                ++i2;
            }
            ++x;
        }
        x = 0;
        while (x < this.EmployeesCount) {
            employeeDescription = this.GetEmployeeDescription(x);
            int i3 = 0;
            while (i3 < this.ShiftTypes.length) {
                ShiftType shiftType4 = this.ShiftTypes[i3];
                if (shiftType4.RequiresSkills) {
                    boolean usesSecSkill = false;
                    for (String str : shiftType4.GetSkills()) {
                        if (!employeeDescription.HasSkillType(str, EmployeeDescription.SkillType.Secondary)) continue;
                        usesSecSkill = true;
                        break;
                    }
                    this.employeeUsesSecondarySkillForShiftType[employeeDescription.IndexID][shiftType4.Index] = usesSecSkill;
                } else {
                    this.employeeUsesSecondarySkillForShiftType[employeeDescription.IndexID][shiftType4.Index] = false;
                }
                ++i3;
            }
            ++x;
        }
        x = 0;
        while (x < this.EmployeesCount) {
            employeeDescription = this.GetEmployeeDescription(x);
            int i4 = 0;
            while (i4 < this.CoverRequirements.Requirements.length) {
                CoverRequirement req = this.CoverRequirements.Requirements[i4];
                if (req.SkillType == CoverRequirement.SkillTypes.AnySkill) {
                    this.employeeHasSkillForCover[employeeDescription.IndexID][req.Index] = true;
                } else if (req.SkillType == CoverRequirement.SkillTypes.SingleSkill) {
                    if (employeeDescription.HasSkillType(req.SkillID, EmployeeDescription.SkillType.Primary) || employeeDescription.HasSkillType(req.SkillID, EmployeeDescription.SkillType.Secondary)) {
                        this.employeeHasSkillForCover[employeeDescription.IndexID][req.Index] = true;
                    }
                } else if (req.SkillType == CoverRequirement.SkillTypes.SkillGroup) {
                    SkillGroup grp = this.GetSkillGroup(req.SkillID);
                    int j = 0;
                    while (j < grp.Skills.length) {
                        String skillID = grp.Skills[j].ID;
                        if (employeeDescription.HasSkillType(skillID, EmployeeDescription.SkillType.Primary) || employeeDescription.HasSkillType(skillID, EmployeeDescription.SkillType.Secondary)) {
                            this.employeeHasSkillForCover[employeeDescription.IndexID][req.Index] = true;
                            break;
                        }
                        ++j;
                    }
                }
                ++i4;
            }
            ++x;
        }
        x = 0;
        while (x < this.ShiftTypesCount) {
            shiftType = this.ShiftTypes[x];
            ArrayList<Integer> grps = new ArrayList<Integer>();
            int y = 0;
            while (y < this.ShiftGroupsCount) {
                ShiftGroup shiftGroup = this.ShiftGroups[y];
                int i5 = 0;
                while (i5 < shiftGroup.Group.length) {
                    if (shiftType.Index == shiftGroup.Group[i5].Index) {
                        grps.add(new Integer(shiftGroup.Index));
                        break;
                    }
                    ++i5;
                }
                ++y;
            }
            this.shiftGroupsContainingShift[shiftType.Index] = new int[grps.size()];
            int i6 = 0;
            while (i6 < grps.size()) {
                this.shiftGroupsContainingShift[shiftType.Index][i6] = (Integer)grps.get(i6);
                ++i6;
            }
            ++x;
        }
        i = 0;
        while (i < this.ShiftGroupsCount) {
            ShiftGroup grp = this.ShiftGroups[i];
            int j = 0;
            while (j < grp.Group.length) {
                ShiftType st = grp.Group[j];
                this.shiftGroupContainsShiftType[i][st.Index] = true;
                ++j;
            }
            ++i;
        }
        x = 0;
        while (x < this.EmployeesCount) {
            employeeDescription = this.GetEmployeeDescription(x);
            employeeDescription.CreateSoftConstraints();
            ++x;
        }
    }

    public boolean EmployeeHasSkillsForShiftType(EmployeeDescription employeeDescription, int shiftTypeIndex) {
        return this.employeeHasSkillsForShiftType[employeeDescription.IndexID][shiftTypeIndex];
    }

    public boolean EmployeeUsesSecondarySkillForShiftType(EmployeeDescription employeeDescription, int shiftTypeIndex) {
        return this.employeeUsesSecondarySkillForShiftType[employeeDescription.IndexID][shiftTypeIndex];
    }

    public boolean EmployeeHasSkillForCover(EmployeeDescription employeeDescription, CoverRequirement req) {
        return this.employeeHasSkillForCover[employeeDescription.IndexID][req.Index];
    }

    public int[] GetShiftGroupsContainingShift(int shiftIndex) {
        return this.shiftGroupsContainingShift[shiftIndex];
    }

    public boolean ShiftGroupContainsShiftType(int groupIndex, int shiftIndex) {
        return this.shiftGroupContainsShiftType[groupIndex][shiftIndex];
    }
}

