/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Solvers.VariableDepthSearch;

import ASAP.NRP.Core.DateTime;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.Roster;
import ASAP.NRP.Core.Shift;
import ASAP.NRP.Solvers.VariableDepthSearch.TestShiftDB;
import java.util.Random;

public class Vrt2Emp1Swp_M {
    public boolean Stopped = true;
    public String Author = "T";
    public String Title = "Vrt2Emp1Swp";
    public long TotalEvaluations = 0L;
    public int RandomSeed = 1;
    boolean finished;
    int lastImprovementEmployee1;
    int lastImprovementEmployee2;
    int lastImprovementDay;
    int lastImprovementBlockSize;
    public int[] BlockSizeMovesCount;
    int iterationCount = 0;
    int[] employeeLastChanged;
    int[] dayLastChanged;
    TestShiftDB shiftsDB;
    public boolean TIME_LIMIT = false;
    public boolean VERBOSE = true;
    public int MAX_BLOCK_SIZE = 2;
    public double MAX_RUN_TIME = 10.0;
    public boolean[] TRY_BLOCK_SIZE;
    public int VIOLATION_HEURISTIC_THRESHOLD = 0;
    boolean cacheViolationPens = false;
    DateTime FinishTime;
    Random rand;
    boolean randSet = false;

    public Vrt2Emp1Swp_M(TestShiftDB shiftsDB) {
        this.shiftsDB = shiftsDB;
        this.UpdateTitle();
        this.TRY_BLOCK_SIZE = new boolean[this.MAX_BLOCK_SIZE];
        int i = 0;
        while (i < this.TRY_BLOCK_SIZE.length) {
            this.TRY_BLOCK_SIZE[i] = true;
            ++i;
        }
    }

    public void setRNG(Random rand) {
        this.rand = rand;
        this.randSet = true;
    }

    public void Solve(Roster roster) {
        if (this.TIME_LIMIT) {
            this.FinishTime = DateTime.getNow().AddSeconds(this.MAX_RUN_TIME);
        }
        if (!this.randSet) {
            this.rand = new Random(this.RandomSeed);
        }
        this.ShuffleEmployees(roster);
        this.UpdateTitle();
        this.Stopped = false;
        this.TotalEvaluations = 0L;
        this.Search(roster);
        if (this.VERBOSE) {
            System.out.println("Search finished. Total moves tested=" + this.TotalEvaluations);
        }
    }

    private void Search(Roster roster) {
        int i;
        this.cacheViolationPens = this.VIOLATION_HEURISTIC_THRESHOLD > 0;
        this.finished = false;
        this.lastImprovementEmployee1 = -1;
        this.lastImprovementEmployee2 = -1;
        this.lastImprovementDay = -1;
        this.lastImprovementBlockSize = -1;
        int totalImprovingMoves = 0;
        int noImprovement = 0;
        boolean repeat = true;
        this.iterationCount = 0;
        this.employeeLastChanged = new int[roster.Employees.length];
        this.dayLastChanged = new int[roster.SchedulingPeriod.NumDaysInPeriod];
        this.BlockSizeMovesCount = new int[this.MAX_BLOCK_SIZE];
        if (this.MAX_BLOCK_SIZE > this.TRY_BLOCK_SIZE.length) {
            boolean[] tempArr = new boolean[this.MAX_BLOCK_SIZE];
            i = 0;
            while (i < this.TRY_BLOCK_SIZE.length) {
                tempArr[i] = this.TRY_BLOCK_SIZE[i];
                ++i;
            }
            i = this.TRY_BLOCK_SIZE.length;
            while (i < this.MAX_BLOCK_SIZE) {
                tempArr[i] = true;
                ++i;
            }
            this.TRY_BLOCK_SIZE = tempArr;
        }
        int blockSizesToTry = 0;
        i = 0;
        while (i < this.TRY_BLOCK_SIZE.length) {
            if (this.TRY_BLOCK_SIZE[i]) {
                ++blockSizesToTry;
            }
            ++i;
        }
        while (blockSizesToTry > 0 && repeat) {
            int movesCount = 0;
            if (this.TIME_LIMIT && DateTime.getNow().isGreaterThan(this.FinishTime)) break;
            int i2 = 1;
            while (i2 <= this.MAX_BLOCK_SIZE) {
                ++this.iterationCount;
                if (this.TRY_BLOCK_SIZE[i2 - 1]) {
                    movesCount = this.SwapShiftsDepthOne(roster, i2);
                    totalImprovingMoves += movesCount;
                    if (this.VERBOSE) {
                        System.out.println("After SwapShiftsDepthOne (blockSize=" + i2 + ") (" + movesCount + " moves), roster.Penalty = " + roster.getTotalPenalty());
                    }
                    noImprovement = movesCount == 0 ? ++noImprovement : 0;
                    if (this.finished || noImprovement == blockSizesToTry) {
                        repeat = false;
                        break;
                    }
                }
                ++i2;
            }
            if (!this.VERBOSE) continue;
            System.out.println("Total moves tested=" + this.TotalEvaluations + ", totalImprovingMoves=" + totalImprovingMoves);
        }
        if (this.VERBOSE) {
            System.out.println("Variable depth search finished. Total moves tested=" + this.TotalEvaluations + ", totalImprovingMoves=" + totalImprovingMoves);
        }
    }

    private int SwapShiftsDepthOne(Roster roster, int blockSize) {
        int movesCount = 0;
        if (blockSize < 1 || blockSize > roster.SchedulingPeriod.NumDaysInPeriod) {
            return 0;
        }
        int i = 0;
        while (i < roster.Employees.length) {
            Employee employee1 = roster.Employees[i];
            int day = 0;
            while (day < roster.SchedulingPeriod.NumDaysInPeriod - blockSize + 1) {
                block48: {
                    block49: {
                        int x;
                        block47: {
                            if (this.VERBOSE) {
                                System.out.println("V/2E/1S: Swap..D1: BlockSize=" + blockSize + " E1=" + employee1.EmployeeDescription.getName() + " Day=" + day + " Evals=" + this.TotalEvaluations + " Pen=" + roster.getTotalPenalty());
                            }
                            if (!this.shiftsDB.getSchedulingPeriodContainsNonAutoAssignShifts()) break block47;
                            boolean fixedShift = false;
                            x = 0;
                            while (x < blockSize) {
                                Shift s = employee1.GetShift(day + x);
                                if (s != null && s.isFixed()) {
                                    fixedShift = true;
                                    break;
                                }
                                ++x;
                            }
                            if (fixedShift) break block48;
                        }
                        if (!this.shiftsDB.getEmployeeDescriptionHasFrozenDays()[employee1.EmployeeDescription.IndexID]) break block49;
                        boolean frozen = false;
                        x = 0;
                        while (x < blockSize) {
                            if (employee1.EmployeeDescription.FrozenDay[day + x]) {
                                frozen = true;
                                break;
                            }
                            ++x;
                        }
                        if (frozen) break block48;
                    }
                    boolean moveMade = false;
                    int originalPenalty = roster.getTotalPenalty();
                    Shift[] shifts1 = new Shift[blockSize];
                    roster.CacheEmployeePenalties(0, this.cacheViolationPens);
                    boolean employee1Violations = false;
                    boolean dayChanged = false;
                    int x = 0;
                    while (x < blockSize) {
                        shifts1[x] = employee1.GetShift(day + x);
                        roster.UnAssignShift(shifts1[x]);
                        if (employee1.ConstraintViolationPenalties[day + x] >= this.VIOLATION_HEURISTIC_THRESHOLD) {
                            employee1Violations = true;
                        }
                        if (this.iterationCount - this.dayLastChanged[day + x] <= this.MAX_BLOCK_SIZE) {
                            dayChanged = true;
                        }
                        ++x;
                    }
                    roster.CoverPenalty += roster.UpdateCoverPens(shifts1);
                    int j = 0;
                    while (j < roster.Employees.length) {
                        block50: {
                            int x2;
                            Shift[] shifts2;
                            Employee employee2;
                            block52: {
                                block51: {
                                    if (i == j) break block50;
                                    employee2 = roster.Employees[j];
                                    if (!dayChanged && this.iterationCount - this.employeeLastChanged[employee1.Index] > this.MAX_BLOCK_SIZE && this.iterationCount - this.employeeLastChanged[employee2.Index] > this.MAX_BLOCK_SIZE) break block50;
                                    if (!this.shiftsDB.getEmployeeDescriptionHasFrozenDays()[employee2.EmployeeDescription.IndexID]) break block51;
                                    boolean frozen = false;
                                    int x3 = 0;
                                    while (x3 < blockSize) {
                                        if (employee2.EmployeeDescription.FrozenDay[day + x3]) {
                                            frozen = true;
                                            break;
                                        }
                                        ++x3;
                                    }
                                    if (frozen) break block50;
                                }
                                shifts2 = new Shift[blockSize];
                                boolean employee2Violations = false;
                                int x4 = 0;
                                while (x4 < blockSize) {
                                    shifts2[x4] = employee2.GetShift(day + x4);
                                    if (employee2.ConstraintViolationPenalties[day + x4] >= this.VIOLATION_HEURISTIC_THRESHOLD) {
                                        employee2Violations = true;
                                    }
                                    ++x4;
                                }
                                if (!employee1Violations && !employee2Violations) break block50;
                                if (!this.shiftsDB.getSchedulingPeriodContainsNonAutoAssignShifts()) break block52;
                                boolean fixedShifts = false;
                                x2 = 0;
                                while (x2 < blockSize) {
                                    if (shifts2[x2] != null && shifts2[x2].isFixed()) {
                                        fixedShifts = true;
                                        break;
                                    }
                                    ++x2;
                                }
                                if (fixedShifts) break block50;
                            }
                            if (!(shifts1[0] == null && shifts2[0] == null || shifts1[blockSize - 1] == null && shifts2[blockSize - 1] == null)) {
                                boolean different = false;
                                x2 = 0;
                                while (x2 < blockSize) {
                                    if (shifts1[x2] != null && shifts2[x2] != null) {
                                        if (shifts1[x2].ShiftType != shifts2[x2].ShiftType) {
                                            different = true;
                                            break;
                                        }
                                    } else if (shifts1[x2] != null || shifts2[x2] != null) {
                                        different = true;
                                        break;
                                    }
                                    ++x2;
                                }
                                if (different) {
                                    x2 = 0;
                                    while (x2 < blockSize) {
                                        roster.UnAssignShift(shifts2[x2]);
                                        ++x2;
                                    }
                                    roster.CoverPenalty += roster.UpdateCoverPens(shifts2);
                                    boolean valid = true;
                                    int x5 = 0;
                                    while (x5 < blockSize) {
                                        if (employee2.ViolationsForAssigningShift(shifts1[x5]) == -1 || employee1.ViolationsForAssigningShift(shifts2[x5]) == -1) {
                                            valid = false;
                                            break;
                                        }
                                        ++x5;
                                    }
                                    if (valid) {
                                        roster.CacheEmployeePenalties(1, this.cacheViolationPens);
                                        x5 = 0;
                                        while (x5 < blockSize) {
                                            roster.AssignShift(employee2, shifts1[x5]);
                                            roster.AssignShift(employee1, shifts2[x5]);
                                            ++x5;
                                        }
                                        employee1.Roster.CoverPenalty += employee1.Roster.UpdateCoverPens(shifts2);
                                        employee2.Roster.CoverPenalty += employee2.Roster.UpdateCoverPens(shifts1);
                                        employee1.RecalculatePenalty(originalPenalty + employee2.Penalty, day, day + blockSize - 1, true);
                                        employee2.RecalculatePenalty(originalPenalty, day, day + blockSize - 1, true);
                                        ++this.TotalEvaluations;
                                        moveMade = roster.getTotalPenalty() < originalPenalty;
                                        if (moveMade) {
                                            int n = blockSize - 1;
                                            this.BlockSizeMovesCount[n] = this.BlockSizeMovesCount[n] + 1;
                                            this.lastImprovementEmployee1 = employee1.Index;
                                            this.lastImprovementEmployee2 = employee2.Index;
                                            this.lastImprovementBlockSize = blockSize;
                                            this.lastImprovementDay = day;
                                            this.employeeLastChanged[employee1.Index] = this.iterationCount;
                                            this.employeeLastChanged[employee2.Index] = this.iterationCount;
                                            x5 = 0;
                                            while (x5 < blockSize) {
                                                if (shifts1[x5] != null && shifts2[x5] != null) {
                                                    if (shifts1[x5].ShiftType != shifts2[x5].ShiftType) {
                                                        this.dayLastChanged[day + x5] = this.iterationCount;
                                                    }
                                                } else if (shifts1[x5] != null || shifts2[x5] != null) {
                                                    this.dayLastChanged[day + x5] = this.iterationCount;
                                                }
                                                ++x5;
                                            }
                                            break;
                                        }
                                        x5 = 0;
                                        while (x5 < blockSize) {
                                            roster.UnAssignShift(shifts1[x5]);
                                            roster.UnAssignShift(shifts2[x5]);
                                            ++x5;
                                        }
                                        roster.CoverPenalty += roster.UpdateCoverPens(shifts1);
                                        roster.CoverPenalty += roster.UpdateCoverPens(shifts2);
                                        roster.RestoreEmployeePenalties(1, this.cacheViolationPens);
                                    }
                                    x5 = 0;
                                    while (x5 < blockSize) {
                                        roster.AssignShift(employee2, shifts2[x5]);
                                        ++x5;
                                    }
                                    roster.CoverPenalty += roster.UpdateCoverPens(shifts2);
                                    if (employee2.EmployeeDescription.Contract != null && employee2.EmployeeDescription.Contract.BadPatternsIsOn && employee2.EmployeeDescription.BadPatternConstraint != null) {
                                        employee2.EmployeeDescription.BadPatternConstraint.Calculate(employee2, day, day + blockSize - 1);
                                    }
                                    if (this.lastImprovementEmployee1 == employee1.Index && this.lastImprovementEmployee2 == employee2.Index && this.lastImprovementDay == day && this.lastImprovementBlockSize == blockSize) {
                                        this.finished = true;
                                        break;
                                    }
                                }
                            }
                        }
                        ++j;
                    }
                    if (moveMade) {
                        ++movesCount;
                    } else {
                        x = 0;
                        while (x < blockSize) {
                            roster.AssignShift(employee1, shifts1[x]);
                            ++x;
                        }
                        roster.CoverPenalty += roster.UpdateCoverPens(shifts1);
                        roster.RestoreEmployeePenalties(0, this.cacheViolationPens);
                        if (employee1.EmployeeDescription.Contract != null && employee1.EmployeeDescription.Contract.BadPatternsIsOn && employee1.EmployeeDescription.BadPatternConstraint != null) {
                            employee1.EmployeeDescription.BadPatternConstraint.Calculate(employee1, day, day + blockSize - 1);
                        }
                    }
                    if (this.Stopped || this.finished || this.TIME_LIMIT && DateTime.getNow().isGreaterThan(this.FinishTime)) {
                        return movesCount;
                    }
                }
                ++day;
            }
            ++i;
        }
        return movesCount;
    }

    private void UpdateTitle() {
        this.Title = "Vrt2Emp1Swp ";
        this.Title = String.valueOf(this.Title) + ", MAX_BLOCK_SIZE=" + this.MAX_BLOCK_SIZE;
        if (this.TIME_LIMIT) {
            this.Title = String.valueOf(this.Title) + ", Max time limit ";
        }
        this.Title = String.valueOf(this.Title) + ", VIOLATION_HEURISTIC_THRESHOLD=" + this.VIOLATION_HEURISTIC_THRESHOLD;
    }

    private void ShuffleEmployees(Roster roster) {
        int i = 0;
        while (i < roster.Employees.length * 3) {
            int index1 = this.rand.nextInt(roster.Employees.length);
            int index2 = this.rand.nextInt(roster.Employees.length);
            Employee temp = roster.Employees[index1];
            roster.Employees[index1] = roster.Employees[index2];
            roster.Employees[index2].Index = index1;
            roster.Employees[index2] = temp;
            temp.Index = index2;
            ++i;
        }
    }
}

