/*
 * Decompiled with CFR 0.152.
 */
package AbstractClasses;

import AbstractClasses.ProblemDomain;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Random;

public abstract class HyperHeuristic {
    protected Random rng;
    private long timeLimit = 0L;
    private long initialTime;
    private ThreadMXBean bean;
    private ProblemDomain problem;
    private double printfraction;
    private double printlimit;
    private int lastprint;
    private boolean initialprint;
    private double lastbestsolution = -1.0;
    private double[] trace;
    private static final int tracecheckpoints = 101;
    private static boolean timelimitset;

    public HyperHeuristic(long seed) {
        this.rng = new Random(seed);
        timelimitset = false;
    }

    public HyperHeuristic() {
        this.rng = new Random();
        timelimitset = false;
    }

    public void setTimeLimit(long time_in_milliseconds) {
        if (!timelimitset) {
            this.timeLimit = time_in_milliseconds * 1000000L;
            this.printlimit = this.printfraction = (double)(time_in_milliseconds * 10000L);
            this.initialprint = false;
            this.lastprint = 0;
            timelimitset = true;
        } else {
            System.err.println("The time limit cannot be set twice. " + this.toString());
            System.exit(-1);
        }
    }

    public long getTimeLimit() {
        return this.timeLimit / 1000000L;
    }

    public long getElapsedTime() {
        if (this.bean == null) {
            return 0L;
        }
        return (long)((double)(this.bean.getCurrentThreadCpuTime() - this.initialTime) / 1000000.0);
    }

    public final double getBestSolutionValue() {
        if (this.lastbestsolution == -1.0) {
            System.err.println("The hasTimeExpired() method has not been called yet. It must be called at least once before a call to getBestSolutionValue()");
            System.exit(1);
        }
        return this.lastbestsolution;
    }

    public double[] getFitnessTrace() {
        return this.trace;
    }

    protected boolean hasTimeExpired() {
        long time = this.bean.getCurrentThreadCpuTime() - this.initialTime;
        if (!this.initialprint) {
            double res;
            this.initialprint = true;
            this.trace[0] = res = this.problem.getBestSolutionValue();
            this.lastbestsolution = res;
        } else if ((double)time >= this.printlimit) {
            int thisprint = (int)((double)time / this.printfraction);
            if (thisprint > 100) {
                thisprint = 100;
            }
            int x = 0;
            while (x < thisprint - this.lastprint) {
                if (time <= this.timeLimit) {
                    double res;
                    this.trace[this.lastprint + x + 1] = res = this.problem.getBestSolutionValue();
                    this.lastbestsolution = res;
                } else {
                    this.trace[this.lastprint + x + 1] = this.lastbestsolution;
                }
                this.printlimit += this.printfraction;
                ++x;
            }
            this.lastprint = thisprint;
        }
        if (time >= this.timeLimit) {
            return true;
        }
        this.lastbestsolution = this.problem.getBestSolutionValue();
        return false;
    }

    public void loadProblemDomain(ProblemDomain problemdomain) {
        if (this.timeLimit == 0L) {
            System.err.println("No problem instance has been loaded in the ProblemDomain object with problem.loadInstance()");
            System.exit(1);
        }
        this.problem = problemdomain;
    }

    public void run() {
        if (this.problem == null) {
            System.err.println("No problem domain has been loaded with loadProblemDomain()");
            System.exit(1);
        }
        if (this.timeLimit == 0L) {
            System.err.println("No time limit has been set with setTimeLimit()");
            System.exit(1);
        }
        this.trace = new double[101];
        this.bean = ManagementFactory.getThreadMXBean();
        this.initialTime = this.bean.getCurrentThreadCpuTime();
        this.solve(this.problem);
    }

    protected abstract void solve(ProblemDomain var1);

    public abstract String toString();
}

