/*
 * Decompiled with CFR 0.152.
 */
package AbstractClasses;

import java.util.Random;

public abstract class ProblemDomain {
    protected Random rng;
    protected double depthOfSearch = 0.2;
    protected double intensityOfMutation = 0.2;
    protected int[] heuristicCallRecord = new int[this.getNumberOfHeuristics()];
    protected int[] heuristicCallTimeRecord = new int[this.getNumberOfHeuristics()];

    public ProblemDomain(long seed) {
        this.rng = seed == -1L ? new Random() : new Random(seed);
        this.setMemorySize(2);
        this.setDepthOfSearch(this.depthOfSearch);
        this.setIntensityOfMutation(this.intensityOfMutation);
    }

    public int[] getHeuristicCallRecord() {
        return this.heuristicCallRecord;
    }

    public int[] getheuristicCallTimeRecord() {
        return this.heuristicCallTimeRecord;
    }

    public void setDepthOfSearch(double depthOfSearch) {
        this.depthOfSearch = depthOfSearch;
        if (this.depthOfSearch < 0.0) {
            this.depthOfSearch = 0.0;
        } else if (this.depthOfSearch > 1.0) {
            this.depthOfSearch = 1.0;
        }
    }

    public void setIntensityOfMutation(double intensityOfMutation) {
        this.intensityOfMutation = intensityOfMutation;
        if (this.intensityOfMutation < 0.0) {
            this.intensityOfMutation = 0.0;
        } else if (this.intensityOfMutation > 1.0) {
            this.intensityOfMutation = 1.0;
        }
    }

    public double getDepthOfSearch() {
        return this.depthOfSearch;
    }

    public double getIntensityOfMutation() {
        return this.intensityOfMutation;
    }

    public abstract int[] getHeuristicsOfType(HeuristicType var1);

    public abstract int[] getHeuristicsThatUseIntensityOfMutation();

    public abstract int[] getHeuristicsThatUseDepthOfSearch();

    public abstract void loadInstance(int var1);

    public abstract void setMemorySize(int var1);

    public abstract void initialiseSolution(int var1);

    public abstract int getNumberOfHeuristics();

    public abstract double applyHeuristic(int var1, int var2, int var3);

    public abstract double applyHeuristic(int var1, int var2, int var3, int var4);

    public abstract void copySolution(int var1, int var2);

    public abstract String toString();

    public abstract int getNumberOfInstances();

    public abstract String bestSolutionToString();

    public abstract double getBestSolutionValue();

    public abstract String solutionToString(int var1);

    public abstract double getFunctionValue(int var1);

    public abstract boolean compareSolutions(int var1, int var2);

    public static enum HeuristicType {
        MUTATION,
        CROSSOVER,
        RUIN_RECREATE,
        LOCAL_SEARCH,
        OTHER;

    }
}

