/*
 * Decompiled with CFR 0.152.
 */
package BinPacking;

import BinPacking.Piece;
import java.util.ListIterator;
import java.util.Vector;

class Bin
implements Comparable<Bin> {
    Vector<Piece> piecesInThisBin = new Vector();

    void addPiece(Piece p) {
        this.piecesInThisBin.add(p);
    }

    double getFullness() {
        double fullness = 0.0;
        int u = 0;
        while (u < this.piecesInThisBin.size()) {
            Piece p = this.piecesInThisBin.get(u);
            fullness += p.getSize();
            ++u;
        }
        return fullness;
    }

    int numberOfPiecesInThisBin() {
        return this.piecesInThisBin.size();
    }

    String addToString(String s) {
        s = String.valueOf(s) + "[" + this.getFullness() + "]  [";
        int u = 0;
        while (u < this.piecesInThisBin.size()) {
            Piece p = this.piecesInThisBin.get(u);
            s = String.valueOf(s) + p.getSize() + ", ";
            ++u;
        }
        s = String.valueOf(s) + "] \n";
        return s;
    }

    boolean contains(int num) {
        ListIterator<Piece> i = this.piecesInThisBin.listIterator();
        int u = 0;
        while (u < this.piecesInThisBin.size()) {
            Piece item = i.next();
            if (item.getNumber() == (double)num) {
                return true;
            }
            ++u;
        }
        return false;
    }

    void copypiecenumbers(Vector<Integer> v) {
        ListIterator<Piece> i = this.piecesInThisBin.listIterator();
        while (i.hasNext()) {
            v.add((int)i.next().getNumber());
        }
    }

    int contains(Piece p) {
        int index = -1;
        ListIterator<Piece> i = this.piecesInThisBin.listIterator();
        int u = 0;
        while (u < this.piecesInThisBin.size()) {
            Piece item = i.next();
            if (item.getNumber() == p.getNumber()) {
                index = u;
            }
            ++u;
        }
        return index;
    }

    public Bin clone() {
        Bin copy = new Bin();
        int u = 0;
        while (u < this.piecesInThisBin.size()) {
            Piece p = this.piecesInThisBin.get(u).clone();
            copy.addPiece(p);
            ++u;
        }
        return copy;
    }

    Piece removePiece(Piece p) {
        return this.piecesInThisBin.remove(this.piecesInThisBin.indexOf(p));
    }

    double getPieceSize(int index) {
        return this.piecesInThisBin.get(index).getSize();
    }

    Piece[] removeTwoPieces(int a, int b) {
        Piece[] twopieces = new Piece[2];
        Piece p1 = this.piecesInThisBin.get(a);
        Piece p2 = this.piecesInThisBin.get(b);
        twopieces[0] = this.removePiece(p1);
        twopieces[1] = this.removePiece(p2);
        return twopieces;
    }

    Piece removePiece(int index) {
        return this.piecesInThisBin.remove(index);
    }

    @Override
    public int compareTo(Bin b) {
        int ret = 0;
        if (this.getFullness() > b.getFullness()) {
            ret = -1;
        }
        if (this.getFullness() < b.getFullness()) {
            ret = 1;
        }
        return ret;
    }

    void print() {
        ListIterator<Piece> i = this.piecesInThisBin.listIterator();
        System.out.print("[" + this.getFullness() + " ");
        while (i.hasNext()) {
            System.out.print(String.valueOf(i.next().getNumber()) + ",");
        }
        System.out.print("] ");
    }
}

