/*
 * Decompiled with CFR 0.152.
 */
package Examples;

import AbstractClasses.HyperHeuristic;
import AbstractClasses.ProblemDomain;

public class ExampleHyperHeuristic1
extends HyperHeuristic {
    public ExampleHyperHeuristic1(long seed) {
        super(seed);
    }

    @Override
    public void solve(ProblemDomain problem) {
        int number_of_heuristics = problem.getNumberOfHeuristics();
        double current_obj_function_value = Double.POSITIVE_INFINITY;
        problem.initialiseSolution(0);
        while (!this.hasTimeExpired()) {
            int heuristic_to_apply = this.rng.nextInt(number_of_heuristics);
            double new_obj_function_value = problem.applyHeuristic(heuristic_to_apply, 0, 1);
            double delta = current_obj_function_value - new_obj_function_value;
            if (delta > 0.0) {
                problem.copySolution(1, 0);
                current_obj_function_value = new_obj_function_value;
                continue;
            }
            if (!this.rng.nextBoolean()) continue;
            problem.copySolution(1, 0);
            current_obj_function_value = new_obj_function_value;
        }
    }

    @Override
    public String toString() {
        return "Example Hyper Heuristic One";
    }
}

