/*
 * Decompiled with CFR 0.152.
 */
package Examples;

import AbstractClasses.HyperHeuristic;
import AbstractClasses.ProblemDomain;
import BinPacking.BinPacking;
import Examples.ExampleHyperHeuristic1;
import Examples.ExampleHyperHeuristic2;
import FlowShop.FlowShop;
import PersonnelScheduling.PersonnelScheduling;
import SAT.SAT;
import java.util.Random;

public class ExampleRun2 {
    private static HyperHeuristic loadHyperHeuristic(int index, long timeLimit, Random rng) {
        HyperHeuristic h = null;
        switch (index) {
            case 0: {
                h = new ExampleHyperHeuristic1(rng.nextLong());
                h.setTimeLimit(timeLimit);
                break;
            }
            case 1: {
                h = new ExampleHyperHeuristic2(rng.nextLong());
                h.setTimeLimit(timeLimit);
                break;
            }
            default: {
                System.err.println("there is no hyper heuristic with this index");
                System.exit(1);
            }
        }
        return h;
    }

    private static ProblemDomain loadProblemDomain(int index, long instanceseed) {
        ProblemDomain p = null;
        switch (index) {
            case 0: {
                p = new SAT(instanceseed);
                break;
            }
            case 1: {
                p = new BinPacking(instanceseed);
                break;
            }
            case 2: {
                p = new PersonnelScheduling(instanceseed);
                break;
            }
            case 3: {
                p = new FlowShop(instanceseed);
                break;
            }
            default: {
                System.err.println("there is no problem domain with this index");
                System.exit(1);
            }
        }
        return p;
    }

    public static void main(String[] args) {
        Random random_number_generator = new Random(12345L);
        int number_of_hyperheuristics = 2;
        long time_limit = 10000L;
        int[][] instances_to_use = new int[4][];
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        int[] sat = nArray;
        int[] bp = new int[]{2, 3, 4, 5, 6};
        int[] ps = new int[]{4, 5, 6, 7, 8};
        int[] nArray2 = new int[5];
        nArray2[0] = 9;
        nArray2[2] = 4;
        nArray2[3] = 2;
        nArray2[4] = 3;
        int[] fs = nArray2;
        instances_to_use[0] = sat;
        instances_to_use[1] = bp;
        instances_to_use[2] = ps;
        instances_to_use[3] = fs;
        int problem_domain_index = 0;
        while (problem_domain_index < 4) {
            long problem_domain_seed = random_number_generator.nextInt();
            int instance = 0;
            while (instance < 5) {
                int instancetouse = instances_to_use[problem_domain_index][instance];
                System.out.println("Problem Domain " + problem_domain_index);
                System.out.println("\tInstance " + instancetouse);
                long instance_seed = problem_domain_seed * (long)(instance + 1);
                int hyper_heuristic_index = 0;
                while (hyper_heuristic_index < number_of_hyperheuristics) {
                    double[] fitnesstrace;
                    ProblemDomain problem_domain_object = ExampleRun2.loadProblemDomain(problem_domain_index, instance_seed);
                    HyperHeuristic hyper_heuristic_object = ExampleRun2.loadHyperHeuristic(hyper_heuristic_index, time_limit, random_number_generator);
                    problem_domain_object.loadInstance(instancetouse);
                    hyper_heuristic_object.loadProblemDomain(problem_domain_object);
                    hyper_heuristic_object.run();
                    int[] i = problem_domain_object.getHeuristicCallRecord();
                    int counter = 0;
                    int[] nArray3 = i;
                    int n = i.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int y = nArray3[n2];
                        counter += y;
                        ++n2;
                    }
                    System.out.print("\tHYPER HEURISTIC " + hyper_heuristic_object.toString());
                    System.out.print("\t" + hyper_heuristic_object.getBestSolutionValue());
                    System.out.print("\t" + (double)hyper_heuristic_object.getElapsedTime() / 1000.0);
                    System.out.println("\t" + counter);
                    double[] dArray = fitnesstrace = hyper_heuristic_object.getFitnessTrace();
                    int n3 = fitnesstrace.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        double f = dArray[n4];
                        System.out.print(String.valueOf(f) + " ");
                        ++n4;
                    }
                    System.out.println();
                    ++hyper_heuristic_index;
                }
                ++instance;
            }
            ++problem_domain_index;
        }
    }
}

