/*
 * Decompiled with CFR 0.152.
 */
package FlowShop;

import AbstractClasses.ProblemDomain;
import FlowShop.BasicAlgorithms;
import FlowShop.Instance;
import FlowShop.Solution;
import java.util.Arrays;

public class FlowShop
extends ProblemDomain {
    private Solution[] memory = new Solution[2];
    private Solution bestSoFar;
    private Instance probInstance;
    private BasicAlgorithms heuristics = new BasicAlgorithms();

    public FlowShop(long seed) {
        super(seed);
    }

    @Override
    public void loadInstance(int instanceID) {
        this.probInstance = new Instance(instanceID);
    }

    @Override
    public void initialiseSolution(int targetIndex) {
        this.memory[targetIndex] = this.heuristics.neh(this.probInstance, this.generateRandomPermutation(this.probInstance.n));
        this.verifyBestSolution(this.memory[targetIndex]);
    }

    @Override
    public void setMemorySize(int size) {
        Solution[] tempMemory = new Solution[size];
        if (this.memory != null) {
            if (tempMemory.length <= this.memory.length) {
                int i = 0;
                while (i < tempMemory.length) {
                    tempMemory[i] = this.memory[i];
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.memory.length) {
                    tempMemory[i] = this.memory[i];
                    ++i;
                }
            }
        }
        this.memory = tempMemory;
    }

    @Override
    public int[] getHeuristicsOfType(ProblemDomain.HeuristicType heuristicType) {
        if (heuristicType == ProblemDomain.HeuristicType.MUTATION) {
            int[] nArray = new int[5];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            nArray[4] = 4;
            return nArray;
        }
        if (heuristicType == ProblemDomain.HeuristicType.RUIN_RECREATE) {
            return new int[]{5, 6};
        }
        if (heuristicType == ProblemDomain.HeuristicType.LOCAL_SEARCH) {
            return new int[]{7, 8, 9, 10};
        }
        if (heuristicType == ProblemDomain.HeuristicType.CROSSOVER) {
            return new int[]{11, 12, 13, 14};
        }
        return null;
    }

    @Override
    public int[] getHeuristicsThatUseDepthOfSearch() {
        return new int[]{6, 9, 10};
    }

    @Override
    public int[] getHeuristicsThatUseIntensityOfMutation() {
        return new int[]{3, 5, 6};
    }

    @Override
    public double getBestSolutionValue() {
        return this.bestSoFar.Cmax;
    }

    @Override
    public double getFunctionValue(int index) {
        return this.memory[index].Cmax;
    }

    @Override
    public double applyHeuristic(int llhID, int solutionSourceIndex, int solutionTargetIndex) {
        long startTime = System.currentTimeMillis();
        boolean isCrossover = false;
        int[] crossovers = this.getHeuristicsOfType(ProblemDomain.HeuristicType.CROSSOVER);
        if (crossovers != null) {
            int x = 0;
            while (x < crossovers.length) {
                if (crossovers[x] == llhID) {
                    isCrossover = true;
                    break;
                }
                ++x;
            }
        }
        if (isCrossover) {
            this.copySolution(solutionSourceIndex, solutionTargetIndex);
        } else {
            switch (llhID) {
                case 0: {
                    this.randomReinsertion(solutionSourceIndex, solutionTargetIndex);
                    break;
                }
                case 1: {
                    this.swapTwo(solutionSourceIndex, solutionTargetIndex);
                    break;
                }
                case 2: {
                    this.shuffle(solutionSourceIndex, solutionTargetIndex);
                    break;
                }
                case 3: {
                    this.shuffleSubSequence(solutionSourceIndex, solutionTargetIndex);
                    break;
                }
                case 4: {
                    this.useNEH(solutionSourceIndex, solutionTargetIndex);
                    break;
                }
                case 5: {
                    this.iteratedGreedy(solutionSourceIndex, solutionTargetIndex);
                    break;
                }
                case 6: {
                    this.deepIteratedGreedy(solutionSourceIndex, solutionTargetIndex);
                    break;
                }
                case 7: {
                    this.localSearch(solutionSourceIndex, solutionTargetIndex);
                    break;
                }
                case 8: {
                    this.fImpLocalSearch(solutionSourceIndex, solutionTargetIndex);
                    break;
                }
                case 9: {
                    this.randomLocalSearch(solutionSourceIndex, solutionTargetIndex);
                    break;
                }
                case 10: {
                    this.randomFImpLocalSearch(solutionSourceIndex, solutionTargetIndex);
                    break;
                }
                default: {
                    System.err.println("heuristic does not exist, or the crossover index array is not set up correctly");
                    System.exit(-1);
                }
            }
        }
        int n = llhID;
        this.heuristicCallRecord[n] = this.heuristicCallRecord[n] + 1;
        int n2 = llhID;
        this.heuristicCallTimeRecord[n2] = this.heuristicCallTimeRecord[n2] + (int)(System.currentTimeMillis() - startTime);
        this.verifyBestSolution(this.memory[solutionTargetIndex]);
        return this.memory[solutionTargetIndex].Cmax;
    }

    @Override
    public double applyHeuristic(int llhID, int solutionSourceIndex1, int solutionSourceIndex2, int solutionTargetIndex) {
        long startTime = System.currentTimeMillis();
        switch (llhID) {
            case 0: {
                this.randomReinsertion(solutionSourceIndex1, solutionTargetIndex);
                break;
            }
            case 1: {
                this.swapTwo(solutionSourceIndex1, solutionTargetIndex);
                break;
            }
            case 2: {
                this.shuffle(solutionSourceIndex1, solutionTargetIndex);
                break;
            }
            case 3: {
                this.shuffleSubSequence(solutionSourceIndex1, solutionTargetIndex);
                break;
            }
            case 4: {
                this.useNEH(solutionSourceIndex1, solutionTargetIndex);
                break;
            }
            case 5: {
                this.iteratedGreedy(solutionSourceIndex1, solutionTargetIndex);
                break;
            }
            case 6: {
                this.deepIteratedGreedy(solutionSourceIndex1, solutionTargetIndex);
                break;
            }
            case 7: {
                this.localSearch(solutionSourceIndex1, solutionTargetIndex);
                break;
            }
            case 8: {
                this.fImpLocalSearch(solutionSourceIndex1, solutionTargetIndex);
                break;
            }
            case 9: {
                this.randomLocalSearch(solutionSourceIndex1, solutionTargetIndex);
                break;
            }
            case 10: {
                this.fImpLocalSearch(solutionSourceIndex1, solutionTargetIndex);
                break;
            }
            case 11: {
                this.ox(solutionSourceIndex1, solutionSourceIndex2, solutionTargetIndex);
                break;
            }
            case 12: {
                this.ppx(solutionSourceIndex1, solutionSourceIndex2, solutionTargetIndex);
                break;
            }
            case 13: {
                this.pmx(solutionSourceIndex1, solutionSourceIndex2, solutionTargetIndex);
                break;
            }
            case 14: {
                this.oneX(solutionSourceIndex1, solutionSourceIndex2, solutionTargetIndex);
                break;
            }
            default: {
                System.err.println("heuristic does not exist, or the crossover index array is not set up correctly");
                System.exit(-1);
            }
        }
        int n = llhID;
        this.heuristicCallRecord[n] = this.heuristicCallRecord[n] + 1;
        int n2 = llhID;
        this.heuristicCallTimeRecord[n2] = this.heuristicCallTimeRecord[n2] + (int)(System.currentTimeMillis() - startTime);
        this.verifyBestSolution(this.memory[solutionTargetIndex]);
        return this.memory[solutionTargetIndex].Cmax;
    }

    @Override
    public void copySolution(int sourceIndex, int targetIndex) {
        this.memory[targetIndex] = this.memory[sourceIndex].clone();
    }

    @Override
    public int getNumberOfHeuristics() {
        return 15;
    }

    @Override
    public String solutionToString(int solutionIndex) {
        return this.memory[solutionIndex].toString();
    }

    @Override
    public String toString() {
        return "FlowShop";
    }

    @Override
    public String bestSolutionToString() {
        return this.bestSoFar.toString();
    }

    @Override
    public int getNumberOfInstances() {
        return 12;
    }

    public Object getProblemData(String args) {
        if (args == "N") {
            return this.probInstance.n;
        }
        if (args == "M") {
            return this.probInstance.m;
        }
        if (args == "SUM_P") {
            return this.probInstance.getSumP();
        }
        return this.probInstance.processingTimes;
    }

    @Override
    public boolean compareSolutions(int solutionIndex1, int solutionIndex2) {
        if (this.memory[solutionIndex1].Cmax != this.memory[solutionIndex2].Cmax) {
            return false;
        }
        int[] p1 = this.memory[solutionIndex1].permutation;
        int[] p2 = this.memory[solutionIndex2].permutation;
        int n = this.probInstance.n;
        int i = 0;
        while (i < n) {
            if (p1[i] != p2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void randomReinsertion(int sourceIndex, int targetIndex) {
        int i;
        int i2;
        int[] array = (int[])this.memory[sourceIndex].permutation.clone();
        int i1 = this.rng.nextInt(array.length);
        while ((i2 = this.rng.nextInt(array.length)) == i1) {
        }
        int[] newArray = new int[array.length];
        newArray[i2] = array[i1];
        if (i1 < i2) {
            i = 0;
            int count = 0;
            while (count < array.length) {
                if (i == i1) {
                    ++count;
                }
                if (i == i2) {
                    --count;
                } else {
                    newArray[i] = array[count];
                }
                ++i;
                ++count;
            }
        } else {
            i = 0;
            int count = 0;
            while (count < array.length) {
                if (i == i2) {
                    --count;
                } else {
                    newArray[i] = array[count];
                    if (i == i1) {
                        ++count;
                    }
                }
                ++i;
                ++count;
            }
        }
        double Cmax = this.evaluatePermutation(newArray, this.probInstance);
        this.memory[targetIndex] = new Solution(newArray, Cmax);
    }

    private void swapTwo(int sourceIndex, int targetIndex) {
        int[] array = (int[])this.memory[sourceIndex].permutation.clone();
        int i1 = this.rng.nextInt(array.length);
        int i2 = this.rng.nextInt(array.length);
        array[i1] = this.memory[sourceIndex].permutation[i2];
        array[i2] = this.memory[sourceIndex].permutation[i1];
        double Cmax = this.evaluatePermutation(array, this.probInstance);
        this.memory[targetIndex] = new Solution(array, Cmax);
    }

    private void shuffle(int sourceIndex, int targetIndex) {
        int[] array = (int[])this.memory[sourceIndex].permutation.clone();
        this.shufflePermutation(array);
        double Cmax = this.evaluatePermutation(array, this.probInstance);
        this.memory[targetIndex] = new Solution(array, Cmax);
    }

    private void useNEH(int sourceIndex, int targetIndex) {
        this.memory[targetIndex] = this.heuristics.neh(this.probInstance, this.memory[sourceIndex].permutation);
    }

    private void shuffleSubSequence(int sourceIndex, int targetIndex) {
        int numbToShuffle = 2 + (int)(this.getIntensityOfMutation() * (double)(this.probInstance.n - 2));
        int[] AvailableIndices = new int[this.probInstance.n];
        Arrays.fill(AvailableIndices, 1);
        int count = this.probInstance.n;
        int[] IndicesToShuffle = new int[numbToShuffle];
        int[] jobIndices = new int[numbToShuffle];
        int[] permutation = (int[])this.memory[sourceIndex].permutation.clone();
        int count2 = 0;
        int i = 0;
        while (i < numbToShuffle) {
            int randomInteger = this.rng.nextInt(count);
            --count;
            count2 = 0;
            int j = 0;
            while (j < permutation.length) {
                if (AvailableIndices[j] == 1) {
                    if (count2 == randomInteger) {
                        IndicesToShuffle[i] = j;
                        jobIndices[i] = permutation[j];
                        AvailableIndices[j] = -1;
                        break;
                    }
                    ++count2;
                }
                ++j;
            }
            ++i;
        }
        this.shufflePermutation(IndicesToShuffle);
        i = 0;
        while (i < numbToShuffle) {
            permutation[IndicesToShuffle[i]] = jobIndices[i];
            ++i;
        }
        double Cmax = this.evaluatePermutation(permutation, this.probInstance);
        this.memory[targetIndex] = new Solution(permutation, Cmax);
    }

    private void iteratedGreedy(int sourceIndex, int targetIndex) {
        int numbRemove = (int)(this.getIntensityOfMutation() * (double)(this.probInstance.n - 1) * 0.5) + 1;
        int[] partialSequence = new int[this.probInstance.n - numbRemove];
        int[] jobsToInsert = new int[numbRemove];
        int[] list = (int[])this.memory[sourceIndex].permutation.clone();
        int i = 0;
        while (i < numbRemove) {
            int id = this.rng.nextInt(this.probInstance.n);
            while (list[id] < 0) {
                id = this.rng.nextInt(this.probInstance.n);
            }
            jobsToInsert[i] = list[id];
            list[id] = -1;
            ++i;
        }
        i = 0;
        int j = 0;
        while (i < this.probInstance.n) {
            try {
                if (list[i] > -1) {
                    partialSequence[j] = list[i];
                } else {
                    --j;
                }
            }
            catch (Exception ex) {
                System.out.println(" " + partialSequence.length + " " + list.length + " j " + j + " i " + i);
                System.exit(0);
            }
            ++i;
            ++j;
        }
        int[] permutation = this.heuristics.nehPartialSchedule(this.probInstance, partialSequence, jobsToInsert);
        double Cmax = this.evaluatePermutation(permutation, this.probInstance);
        this.memory[targetIndex] = new Solution(permutation, Cmax);
    }

    private void deepIteratedGreedy(int sourceIndex, int targetIndex) {
        int numbRemove = (int)(this.getIntensityOfMutation() * (double)(this.probInstance.n - 1) * 0.5) + 1;
        int depthOfSearch = (int)(this.getDepthOfSearch() * (double)(numbRemove - 1)) + 1;
        int[] partialSequence = new int[this.probInstance.n - numbRemove];
        int[] jobsToInsert = new int[numbRemove];
        int[] list = (int[])this.memory[sourceIndex].permutation.clone();
        int i = 0;
        while (i < numbRemove) {
            int id = this.rng.nextInt(this.probInstance.n);
            while (list[id] < 0) {
                id = this.rng.nextInt(this.probInstance.n);
            }
            jobsToInsert[i] = list[id];
            list[id] = -1;
            ++i;
        }
        i = 0;
        int j = 0;
        while (i < this.probInstance.n) {
            if (list[i] > -1) {
                partialSequence[j] = list[i];
            } else {
                --j;
            }
            ++i;
            ++j;
        }
        int[] permutation = this.heuristics.nehPartScheduleBT(this.probInstance, partialSequence, jobsToInsert, depthOfSearch);
        double Cmax = this.evaluatePermutation(permutation, this.probInstance);
        this.memory[targetIndex] = new Solution(permutation, Cmax);
    }

    private void localSearch(int sourceIndex, int targetIndex) {
        int[] improvedSchedule = this.heuristics.localSearch(this.probInstance, this.memory[sourceIndex].permutation, (int)this.memory[sourceIndex].Cmax);
        double Cmax = this.evaluatePermutation(improvedSchedule, this.probInstance);
        this.memory[targetIndex] = new Solution(improvedSchedule, Cmax);
    }

    private void fImpLocalSearch(int sourceIndex, int targetIndex) {
        int[] improvedSchedule = this.heuristics.fImpLocalSearch(this.probInstance, this.memory[sourceIndex].permutation, (int)this.memory[sourceIndex].Cmax);
        double Cmax = this.evaluatePermutation(improvedSchedule, this.probInstance);
        this.memory[targetIndex] = new Solution(improvedSchedule, Cmax);
    }

    private void randomLocalSearch(int sourceIndex, int targetIndex) {
        int numbLocalSearchPasses = (int)(this.getDepthOfSearch() * (double)(this.probInstance.n - 1)) + 1;
        int[] randomPermutation = this.generateRandomPermutation(this.probInstance.n);
        int[] reducedPermutation = new int[numbLocalSearchPasses];
        int i = 0;
        while (i < numbLocalSearchPasses) {
            reducedPermutation[i] = randomPermutation[i];
            ++i;
        }
        int[] improvedSchedule = this.heuristics.randomLocalSearch(this.probInstance, this.memory[sourceIndex].permutation, (int)this.memory[sourceIndex].Cmax, reducedPermutation);
        double Cmax = this.evaluatePermutation(improvedSchedule, this.probInstance);
        this.memory[targetIndex] = new Solution(improvedSchedule, Cmax);
    }

    private void randomFImpLocalSearch(int sourceIndex, int targetIndex) {
        int numbLocalSearchPasses = (int)(this.getDepthOfSearch() * (double)(this.probInstance.n - 1)) + 1;
        int[] randomPermutation = this.generateRandomPermutation(this.probInstance.n);
        int[] reducedPermutation = new int[numbLocalSearchPasses];
        int i = 0;
        while (i < numbLocalSearchPasses) {
            reducedPermutation[i] = randomPermutation[i];
            ++i;
        }
        int[] improvedSchedule = this.heuristics.randomFImpLocalSearch(this.probInstance, this.memory[sourceIndex].permutation, (int)this.memory[sourceIndex].Cmax, reducedPermutation);
        double Cmax = this.evaluatePermutation(improvedSchedule, this.probInstance);
        this.memory[targetIndex] = new Solution(improvedSchedule, Cmax);
    }

    private void ox(int sourceIndex1, int sourceIndex2, int targetIndex) {
        int job;
        int[] p1 = this.memory[sourceIndex1].permutation;
        int[] p22 = this.memory[sourceIndex2].permutation;
        if (p1.length <= 1 || p22.length <= 1 || p1.length != p22.length) {
            System.out.println("Error in ox (order crossover) input permutation are not of the same length or one of them is of size <= 1");
            System.exit(0);
        }
        int[] p2 = (int[])p22.clone();
        int n = p1.length;
        int point1 = this.rng.nextInt(n);
        int point2 = this.rng.nextInt(n);
        while (point2 == point1) {
            point2 = this.rng.nextInt(n);
        }
        if (point2 < point1) {
            int temp = point1;
            point1 = point2;
            point2 = temp;
        }
        int pointsToCopy = point2 - point1;
        int[] inverseP2 = this.returnInversePermutation(p2);
        int i = 0;
        while (i < pointsToCopy) {
            job = p1[point1 + i];
            int job_index = inverseP2[job];
            p2[job_index] = -1;
            ++i;
        }
        int insertionPoint = inverseP2[p1[point1]];
        int[] receiver = new int[n + pointsToCopy];
        int counter = 0;
        int i2 = 0;
        while (i2 <= n) {
            if (i2 < insertionPoint) {
                receiver[i2] = p2[i2];
            }
            if (i2 == insertionPoint) {
                int j = 0;
                while (j < pointsToCopy) {
                    receiver[i2 + j] = p1[point1 + j];
                    ++j;
                }
            }
            if (i2 > insertionPoint) {
                receiver[i2 - 1 + pointsToCopy] = p2[i2 - 1];
            }
            ++i2;
        }
        int[] p3 = new int[n];
        counter = 0;
        int i3 = 0;
        while (i3 < n) {
            job = receiver[counter];
            if (job == -1) {
                ++counter;
                --i3;
            } else {
                p3[i3] = job;
                ++counter;
            }
            ++i3;
        }
        double Cmax = this.evaluatePermutation(p3, this.probInstance);
        this.memory[targetIndex] = new Solution(p3, Cmax);
    }

    private void pmx(int sourceIndex1, int sourceIndex2, int targetIndex) {
        int[] p1 = this.memory[sourceIndex1].permutation;
        int[] p2 = this.memory[sourceIndex2].permutation;
        if (p1.length <= 1 || p2.length <= 1 || p1.length != p2.length) {
            System.out.println("Error in ox (order crossover) input permutation are not of the same length or one of them is of size <= 1");
            System.exit(0);
        }
        int n = p1.length;
        int point1 = this.rng.nextInt(n);
        int point2 = this.rng.nextInt(n);
        while (point2 == point1) {
            point2 = this.rng.nextInt(n);
        }
        if (point2 < point1) {
            int temp = point1;
            point1 = point2;
            point2 = temp;
        }
        int pointsToCopy = point2 - point1;
        int[] p3 = new int[n];
        Arrays.fill(p3, -1);
        int[] jobsTaken = new int[n];
        int job = p1[point1];
        int i = 0;
        while (i < pointsToCopy) {
            p3[point1 + i] = job = p1[point1 + i];
            jobsTaken[job] = -1;
            ++i;
        }
        int counter = 0;
        int i2 = 0;
        while (i2 < n) {
            if (p3[i2] == -1) {
                job = p2[counter];
                while (jobsTaken[job] == -1) {
                    job = p2[++counter];
                }
                ++counter;
                p3[i2] = job;
            }
            ++i2;
        }
        double Cmax = this.evaluatePermutation(p3, this.probInstance);
        this.memory[targetIndex] = new Solution(p3, Cmax);
    }

    private void ppx(int sourceIndex1, int sourceIndex2, int targetIndex) {
        int[] p12 = this.memory[sourceIndex1].permutation;
        int[] p22 = this.memory[sourceIndex2].permutation;
        int[] p1 = (int[])p12.clone();
        int[] p2 = (int[])p22.clone();
        int n = p1.length;
        int[] inverseP1 = this.returnInversePermutation(p1);
        int[] inverseP2 = this.returnInversePermutation(p2);
        int counterP1 = 0;
        int counterP2 = 0;
        int[] p3 = new int[n];
        int i = 0;
        while (i < n) {
            int job;
            int randNumb = this.rng.nextInt(2);
            if (randNumb == 0) {
                job = p1[counterP1];
                while (job == -1) {
                    job = p1[++counterP1];
                }
                p3[i] = job;
                p1[counterP1] = -1;
                p2[inverseP2[job]] = -1;
                ++counterP1;
            } else {
                job = p2[counterP2];
                while (job == -1) {
                    job = p2[++counterP2];
                }
                p3[i] = job;
                p2[counterP2] = -1;
                p1[inverseP1[job]] = -1;
                ++counterP2;
            }
            ++i;
        }
        double Cmax = this.evaluatePermutation(p3, this.probInstance);
        this.memory[targetIndex] = new Solution(p3, Cmax);
    }

    private void oneX(int sourceIndex1, int sourceIndex2, int targetIndex) {
        int[] p1 = this.memory[sourceIndex1].permutation;
        int[] p2 = this.memory[sourceIndex2].permutation;
        int n = p1.length;
        int xPoint = this.rng.nextInt(n);
        int[] inv = new int[n];
        int[] p3 = new int[n];
        int i = 0;
        while (i < xPoint) {
            p3[i] = p1[i];
            inv[p1[i]] = 1;
            ++i;
        }
        int count = xPoint;
        int i2 = 0;
        while (i2 < n) {
            if (inv[p2[i2]] != 1) {
                p3[count] = p2[i2];
                ++count;
            }
            ++i2;
        }
        double Cmax = this.evaluatePermutation(p3, this.probInstance);
        this.memory[targetIndex] = new Solution(p3, Cmax);
    }

    private void shufflePermutation(int[] array) {
        int n = array.length;
        while (n > 1) {
            int k = this.rng.nextInt(n);
            int temp = array[--n];
            array[n] = array[k];
            array[k] = temp;
        }
    }

    private int[] generateRandomPermutation(int n) {
        int[] randomPermutation = new int[n];
        int i = 0;
        while (i < n) {
            randomPermutation[i] = i;
            ++i;
        }
        this.shufflePermutation(randomPermutation);
        return randomPermutation;
    }

    private void verifyBestSolution(Solution solution) {
        if (this.bestSoFar == null || solution.Cmax < this.bestSoFar.Cmax) {
            this.bestSoFar = solution;
        }
    }

    private int evaluatePermutation(int[] permutation, Instance instance) {
        int jobIndex;
        int[][] processingTimes = instance.processingTimes;
        int n = instance.n;
        int m = instance.m;
        int[] releaseTimes = new int[n];
        int time = 0;
        int j = 0;
        while (j < n) {
            jobIndex = permutation[j];
            releaseTimes[jobIndex] = time += processingTimes[jobIndex][0];
            ++j;
        }
        int i = 1;
        while (i < m) {
            time = 0;
            int j2 = 0;
            while (j2 < n) {
                jobIndex = permutation[j2];
                int releaseTime = releaseTimes[jobIndex];
                int n2 = releaseTime >= time ? releaseTime : time;
                releaseTimes[jobIndex] = time = n2 + processingTimes[jobIndex][i];
                ++j2;
            }
            ++i;
        }
        return time;
    }

    private int[] returnInversePermutation(int[] p) {
        int[] inv = new int[p.length];
        int n = p.length;
        int i = 0;
        while (i < n) {
            inv[p[i]] = i;
            ++i;
        }
        return inv;
    }
}

