/*
 * Decompiled with CFR 0.152.
 */
package FlowShop;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.StringTokenizer;

class Instance {
    int n;
    int m;
    int[][] processingTimes;

    Instance(int insnumber) {
        int number = insnumber;
        if (insnumber == 0) {
            number = 80;
        } else if (insnumber == 1) {
            number = 81;
        } else if (insnumber == 2) {
            number = 82;
        } else if (insnumber == 3) {
            number = 83;
        } else if (insnumber == 4) {
            number = 84;
        } else if (insnumber == 5) {
            number = 91;
        } else if (insnumber == 6) {
            number = 92;
        } else if (insnumber == 7) {
            number = 110;
        } else if (insnumber == 8) {
            number = 111;
        } else if (insnumber == 9) {
            number = 113;
        } else if (insnumber == 10) {
            number = 100;
        } else if (insnumber == 11) {
            number = 112;
        } else {
            number = -1;
            System.err.println("instance does not exist " + insnumber);
            System.exit(-1);
        }
        try {
            String fileName = this.returnNameForFolder(number);
            int[][] data = this.openDataAsInt(fileName, true);
            this.processingTimes = this.transposeMatrix(data);
            this.n = this.processingTimes.length;
            this.m = this.processingTimes[0].length;
        }
        catch (Exception ex) {
            try {
                String fileName = this.returnNameForJar(number);
                int[][] data = this.openDataAsInt(fileName, false);
                this.processingTimes = this.transposeMatrix(data);
                this.n = this.processingTimes.length;
                this.m = this.processingTimes[0].length;
            }
            catch (Exception ex2) {
                System.out.println("Could not open file from Folder: " + ex.toString());
                System.out.println("Could not open file from Jar: " + ex2.toString());
                System.exit(0);
            }
        }
    }

    int getM() {
        return this.m;
    }

    int getN() {
        return this.n;
    }

    int getSumP() {
        int sum = 0;
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.m) {
                sum += this.processingTimes[i][j];
                ++j;
            }
            ++i;
        }
        return sum;
    }

    int[][] getProcTimes() {
        return this.processingTimes;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Processing times: \n");
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.m) {
                buffer.append(String.valueOf(this.processingTimes[i][j]) + " ");
                ++j;
            }
            buffer.append("\n");
            ++i;
        }
        return buffer.toString();
    }

    private int[][] openDataAsInt(String file, boolean fromFolder) throws Exception {
        String data = "";
        data = fromFolder ? this.openFileFromFolder(file) : this.openFileFromJar(file);
        ArrayList<int[]> list = new ArrayList<int[]>();
        int numbColumns = 0;
        try {
            StringReader rdr = new StringReader(data);
            BufferedReader bfr = new BufferedReader(rdr);
            String line = bfr.readLine();
            StringTokenizer tok = new StringTokenizer(line);
            numbColumns = tok.countTokens();
            int[] lineInt = new int[numbColumns];
            while (line != null) {
                tok = new StringTokenizer(line);
                lineInt = new int[numbColumns];
                int i = 0;
                while (i < numbColumns) {
                    lineInt[i] = Integer.parseInt(tok.nextToken());
                    ++i;
                }
                list.add((int[])lineInt.clone());
                line = bfr.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        int[][] finalData = new int[list.size()][];
        int i = 0;
        while (i < list.size()) {
            finalData[i] = (int[])list.get(i);
            ++i;
        }
        return finalData;
    }

    private String openFileFromFolder(String file) throws Exception {
        StringBuffer sbf = new StringBuffer();
        FileReader fr = new FileReader(file);
        BufferedReader bfr = new BufferedReader(fr);
        String strLine = null;
        while ((strLine = bfr.readLine()) != null) {
            sbf.append(String.valueOf(strLine) + "\n");
        }
        bfr.close();
        return sbf.toString();
    }

    private String openFileFromJar(String file) throws Exception {
        StringBuffer sbf = new StringBuffer();
        BufferedReader bfr = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(file)));
        String strLine = null;
        while ((strLine = bfr.readLine()) != null) {
            sbf.append(String.valueOf(strLine) + "\n");
        }
        bfr.close();
        return sbf.toString();
    }

    private String returnNameForFolder(int number) {
        String fileName = "data\\flowshop\\";
        int a = number / 10;
        int b = number % 10;
        switch (a) {
            case 0: {
                fileName = String.valueOf(fileName) + "20x5\\";
                break;
            }
            case 1: {
                fileName = String.valueOf(fileName) + "20x10\\";
                break;
            }
            case 2: {
                fileName = String.valueOf(fileName) + "20x20\\";
                break;
            }
            case 3: {
                fileName = String.valueOf(fileName) + "50x5\\";
                break;
            }
            case 4: {
                fileName = String.valueOf(fileName) + "50x10\\";
                break;
            }
            case 5: {
                fileName = String.valueOf(fileName) + "50x20\\";
                break;
            }
            case 6: {
                fileName = String.valueOf(fileName) + "100x5\\";
                break;
            }
            case 7: {
                fileName = String.valueOf(fileName) + "100x10\\";
                break;
            }
            case 8: {
                fileName = String.valueOf(fileName) + "100x20\\";
                break;
            }
            case 9: {
                fileName = String.valueOf(fileName) + "200x10\\";
                break;
            }
            case 10: {
                fileName = String.valueOf(fileName) + "200x20\\";
                break;
            }
            case 11: {
                fileName = String.valueOf(fileName) + "500x20\\";
            }
        }
        return String.valueOf(fileName) + (b + 1) + ".txt";
    }

    private String returnNameForJar(int number) {
        String fileName = "data/flowshop/";
        int a = number / 10;
        int b = number % 10;
        switch (a) {
            case 0: {
                fileName = String.valueOf(fileName) + "20x5/";
                break;
            }
            case 1: {
                fileName = String.valueOf(fileName) + "20x10/";
                break;
            }
            case 2: {
                fileName = String.valueOf(fileName) + "20x20/";
                break;
            }
            case 3: {
                fileName = String.valueOf(fileName) + "50x5/";
                break;
            }
            case 4: {
                fileName = String.valueOf(fileName) + "50x10/";
                break;
            }
            case 5: {
                fileName = String.valueOf(fileName) + "50x20/";
                break;
            }
            case 6: {
                fileName = String.valueOf(fileName) + "100x5/";
                break;
            }
            case 7: {
                fileName = String.valueOf(fileName) + "100x10/";
                break;
            }
            case 8: {
                fileName = String.valueOf(fileName) + "100x20/";
                break;
            }
            case 9: {
                fileName = String.valueOf(fileName) + "200x10/";
                break;
            }
            case 10: {
                fileName = String.valueOf(fileName) + "200x20/";
                break;
            }
            case 11: {
                fileName = String.valueOf(fileName) + "500x20/";
            }
        }
        return String.valueOf(fileName) + (b + 1) + ".txt";
    }

    private int[][] transposeMatrix(int[][] matrix) {
        int[][] newMatrix = new int[matrix[0].length][matrix.length];
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[i].length) {
                newMatrix[j][i] = matrix[i][j];
                ++j;
            }
            ++i;
        }
        return newMatrix;
    }
}

