/*
 * Decompiled with CFR 0.152.
 */
package SAT;

import AbstractClasses.ProblemDomain;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Vector;

public class SAT
extends ProblemDomain {
    private static int defaultmemorysize = 2;
    private final int[] mutations;
    private final int[] localSearches;
    private final int[] ruin_recreate;
    private final int[] crossovers;
    private int numberOfClauses;
    private int numberOfVariables;
    private Clause[] clauses;
    private Solution[] solutionMemory;
    private Solution bestEverSolution;
    private double bestEverObjectiveFunction;
    private int lrepeats;
    private int mrepeats;

    public SAT(long seed) {
        super(seed);
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        this.mutations = nArray;
        this.localSearches = new int[]{7, 8};
        this.ruin_recreate = new int[]{6};
        this.crossovers = new int[]{9, 10};
        this.bestEverObjectiveFunction = Double.POSITIVE_INFINITY;
    }

    @Override
    public void setDepthOfSearch(double depthOfSearch) {
        super.setDepthOfSearch(depthOfSearch);
        this.lrepeats = depthOfSearch <= 0.2 ? 10 : (depthOfSearch <= 0.4 ? 12 : (depthOfSearch <= 0.6 ? 14 : (depthOfSearch <= 0.8 ? 17 : 20)));
    }

    @Override
    public void setIntensityOfMutation(double intensityOfMutation) {
        super.setIntensityOfMutation(intensityOfMutation);
        this.mrepeats = intensityOfMutation <= 0.2 ? 1 : (intensityOfMutation <= 0.4 ? 2 : (intensityOfMutation <= 0.6 ? 3 : (intensityOfMutation <= 0.8 ? 4 : 5)));
    }

    private LinkedList<Integer> getVariablesWithHighestNetGain(Solution tempSolution) {
        int[] numbersofbrokenclauses = new int[this.numberOfVariables];
        int x = 0;
        while (x < this.numberOfVariables) {
            numbersofbrokenclauses[x] = tempSolution.testFlipForBrokenClauses(x);
            ++x;
        }
        int minimum = numbersofbrokenclauses[0];
        int i = 0;
        while (i < numbersofbrokenclauses.length) {
            if (numbersofbrokenclauses[i] < minimum) {
                minimum = numbersofbrokenclauses[i];
            }
            ++i;
        }
        LinkedList<Integer> jointminimums = new LinkedList<Integer>();
        int i2 = 0;
        while (i2 < this.numberOfVariables) {
            if (numbersofbrokenclauses[i2] == minimum) {
                jointminimums.add(new Integer(i2));
            }
            ++i2;
        }
        return jointminimums;
    }

    private void applyHeuristic0(Solution tempSolution) {
        int re = 0;
        while (re < this.mrepeats) {
            LinkedList<Integer> highestNetGains = this.getVariablesWithHighestNetGain(tempSolution);
            Integer i = highestNetGains.get(this.rng.nextInt(highestNetGains.size()));
            tempSolution.variables[i].permanentflip();
            ++re;
        }
    }

    private void applyHeuristic1(Solution tempSolution) {
        int re = 0;
        while (re < this.mrepeats) {
            LinkedList<Integer> jointminimums = this.getVariablesWithHighestNetGain(tempSolution);
            Variable largestage = tempSolution.variables[jointminimums.getFirst()];
            int x = 0;
            while (x < jointminimums.size()) {
                Variable contender = tempSolution.variables[jointminimums.get(x)];
                if (contender.age > largestage.age) {
                    largestage = contender;
                }
                ++x;
            }
            largestage.permanentflip();
            ++re;
        }
    }

    private Clause getRandomBrokenClause(Solution tempSolution) {
        Vector<Clause> brokenClauses = new Vector<Clause>();
        int x = 0;
        while (x < this.numberOfClauses) {
            if (!this.clauses[x].evaluate(tempSolution.variables)) {
                brokenClauses.add(this.clauses[x]);
            }
            ++x;
        }
        if (brokenClauses.isEmpty()) {
            return null;
        }
        return (Clause)brokenClauses.get(this.rng.nextInt(brokenClauses.size()));
    }

    private void flipRandomVariableInClause(Solution tempSolution, Clause c) {
        int variable = this.rng.nextInt(c.numberOfVariables());
        int specificVariableNumber = c.variablenumbers[variable];
        tempSolution.variables[specificVariableNumber].permanentflip();
    }

    private void flipRandomVariableInRandomBrokenClause(Solution tempSolution) {
        Clause randomBrokenClause = this.getRandomBrokenClause(tempSolution);
        if (randomBrokenClause == null) {
            return;
        }
        this.flipRandomVariableInClause(tempSolution, randomBrokenClause);
    }

    private int getNegativeGain(Solution tempSolution, int variableToFlip) {
        int numberNotNowSatisfied = tempSolution.testFlipForNegGain(variableToFlip);
        return numberNotNowSatisfied;
    }

    private void applyHeuristic2(Solution tempSolution) {
        int re = 0;
        while (re < this.mrepeats) {
            Clause randomBrokenClause = this.getRandomBrokenClause(tempSolution);
            if (randomBrokenClause == null) break;
            int[] negativeGains = new int[randomBrokenClause.numberOfVariables()];
            Vector<Integer> variablesWithNegativeGain0 = new Vector<Integer>(randomBrokenClause.numberOfVariables());
            int x = 0;
            while (x < randomBrokenClause.numberOfVariables()) {
                negativeGains[x] = this.getNegativeGain(tempSolution, randomBrokenClause.variablenumbers[x]);
                if (negativeGains[x] == 0) {
                    variablesWithNegativeGain0.add(new Integer(randomBrokenClause.variablenumbers[x]));
                }
                ++x;
            }
            if (!variablesWithNegativeGain0.isEmpty()) {
                int r = this.rng.nextInt(variablesWithNegativeGain0.size());
                int varnumber = (Integer)variablesWithNegativeGain0.get(r);
                tempSolution.variables[varnumber].permanentflip();
            } else {
                int minimum = negativeGains[0];
                int x2 = 1;
                while (x2 < randomBrokenClause.numberOfVariables()) {
                    if (negativeGains[x2] < minimum) {
                        minimum = negativeGains[x2];
                    }
                    ++x2;
                }
                Vector<Integer> jointminimums = new Vector<Integer>(randomBrokenClause.numberOfVariables());
                int i = 0;
                while (i < randomBrokenClause.numberOfVariables()) {
                    if (negativeGains[i] == minimum) {
                        jointminimums.add(new Integer(randomBrokenClause.variablenumbers[i]));
                    }
                    ++i;
                }
                tempSolution.variables[(Integer)jointminimums.get(this.rng.nextInt(jointminimums.size()))].permanentflip();
            }
            ++re;
        }
    }

    private void applyHeuristic3(Solution tempSolution) {
        int r = 0;
        while (r < this.mrepeats) {
            this.flipRandomVariableInRandomBrokenClause(tempSolution);
            ++r;
        }
    }

    private void applyHeuristic4(Solution tempSolution) {
        int r = 0;
        while (r < this.mrepeats) {
            tempSolution.variables[this.rng.nextInt(this.numberOfVariables)].permanentflip();
            ++r;
        }
    }

    private void applyHeuristic5(Solution tempSolution) {
        int re = 0;
        while (re < this.mrepeats) {
            Clause randomBrokenClause = this.getRandomBrokenClause(tempSolution);
            if (randomBrokenClause == null) break;
            this.applyNovelty(tempSolution, randomBrokenClause);
            ++re;
        }
    }

    private void applyNovelty(Solution tempSolution, Clause randomBrokenClause) {
        double p = 0.7;
        int[] numbersofbrokenclauses = new int[randomBrokenClause.numberOfVariables()];
        int minimalage = Integer.MAX_VALUE;
        int x = 0;
        while (x < randomBrokenClause.numberOfVariables()) {
            numbersofbrokenclauses[x] = tempSolution.testFlipForBrokenClauses(randomBrokenClause.variablenumbers[x]);
            if (tempSolution.variables[randomBrokenClause.variablenumbers[x]].age < minimalage) {
                minimalage = tempSolution.variables[randomBrokenClause.variablenumbers[x]].age;
            }
            ++x;
        }
        int minimum = Integer.MAX_VALUE;
        int secondminimum = Integer.MAX_VALUE;
        int i = 0;
        while (i < randomBrokenClause.numberOfVariables()) {
            if (numbersofbrokenclauses[i] < minimum) {
                secondminimum = minimum;
                minimum = numbersofbrokenclauses[i];
            } else if (numbersofbrokenclauses[i] < secondminimum) {
                secondminimum = numbersofbrokenclauses[i];
            }
            ++i;
        }
        Vector<Integer> jointminimums = new Vector<Integer>(randomBrokenClause.numberOfVariables());
        int i2 = 0;
        while (i2 < randomBrokenClause.numberOfVariables()) {
            if (numbersofbrokenclauses[i2] == minimum) {
                jointminimums.add(new Integer(i2));
            }
            ++i2;
        }
        Integer i22 = (Integer)jointminimums.get(this.rng.nextInt(jointminimums.size()));
        if (tempSolution.variables[randomBrokenClause.variablenumbers[i22]].age == minimalage) {
            if (p < this.rng.nextDouble()) {
                tempSolution.variables[randomBrokenClause.variablenumbers[i22]].permanentflip();
            } else if (randomBrokenClause.numberOfVariables() == 1) {
                tempSolution.variables[randomBrokenClause.variablenumbers[i22]].permanentflip();
            } else if (minimum == secondminimum) {
                Integer q;
                while ((q = (Integer)jointminimums.get(this.rng.nextInt(jointminimums.size()))).intValue() == i22.intValue()) {
                }
                tempSolution.variables[randomBrokenClause.variablenumbers[q]].permanentflip();
            } else {
                jointminimums = new Vector(randomBrokenClause.numberOfVariables());
                int q = 0;
                while (q < randomBrokenClause.numberOfVariables()) {
                    if (numbersofbrokenclauses[q] == secondminimum) {
                        jointminimums.add(new Integer(q));
                    }
                    ++q;
                }
                if (jointminimums.isEmpty()) {
                    System.out.println(String.valueOf(minimum) + " " + secondminimum + " " + randomBrokenClause.numberOfVariables());
                }
                Integer q2 = (Integer)jointminimums.get(this.rng.nextInt(jointminimums.size()));
                tempSolution.variables[randomBrokenClause.variablenumbers[q2]].permanentflip();
            }
        } else {
            tempSolution.variables[randomBrokenClause.variablenumbers[i22]].permanentflip();
        }
    }

    private void applyHeuristic6(Solution tempSolution) {
        double prop = this.intensityOfMutation <= 0.25 ? 0.2 : (this.intensityOfMutation <= 0.49 ? 0.4 : (this.intensityOfMutation <= 0.75 ? 0.6 : 0.8));
        int numofvariables = (int)((double)this.numberOfVariables * prop);
        int[] variables_to_reinitialise = new int[numofvariables];
        int count = 0;
        while (count < numofvariables) {
            int chosen = this.rng.nextInt(this.numberOfVariables);
            boolean alreadychosen = false;
            int y = 0;
            while (y < count) {
                if (variables_to_reinitialise[y] == chosen) {
                    alreadychosen = true;
                    break;
                }
                ++y;
            }
            if (alreadychosen) continue;
            variables_to_reinitialise[count] = chosen;
            ++count;
        }
        int[] nArray = variables_to_reinitialise;
        int n = variables_to_reinitialise.length;
        int n2 = 0;
        while (n2 < n) {
            int y = nArray[n2];
            if (this.rng.nextBoolean()) {
                tempSolution.variables[y].permanentflip();
            }
            ++n2;
        }
    }

    private void applyHeuristic7(Solution tempSolution) {
        double currentres = this.evaluateObjectiveFunction(tempSolution);
        int r = 0;
        while (r < this.lrepeats) {
            Clause randomBrokenClause = this.getRandomBrokenClause(tempSolution);
            if (randomBrokenClause == null) break;
            int variable = this.rng.nextInt(randomBrokenClause.numberOfVariables());
            int specificVariableNumber = randomBrokenClause.variablenumbers[variable];
            tempSolution.variables[specificVariableNumber].testflip();
            double res = this.evaluateObjectiveFunction(tempSolution);
            tempSolution.variables[specificVariableNumber].testflip();
            if (res <= currentres) {
                tempSolution.variables[specificVariableNumber].permanentflip();
                currentres = res;
            }
            ++r;
        }
    }

    private void applyHeuristic8(Solution tempSolution) {
        double currentres = this.evaluateObjectiveFunction(tempSolution);
        int r = 0;
        while (r < this.lrepeats) {
            int vtoflip = this.rng.nextInt(this.numberOfVariables);
            tempSolution.variables[vtoflip].testflip();
            double res = this.evaluateObjectiveFunction(tempSolution);
            tempSolution.variables[vtoflip].testflip();
            if (res <= currentres) {
                tempSolution.variables[vtoflip].permanentflip();
                currentres = res;
            }
            ++r;
        }
    }

    private void applyHeuristic9(Solution tempSolution1, Solution tempSolution2) {
        int crossoverpoint2;
        int crossoverpoint1 = this.rng.nextInt(tempSolution1.variables.length);
        if (crossoverpoint1 > (crossoverpoint2 = this.rng.nextInt(tempSolution1.variables.length))) {
            int temp = crossoverpoint1;
            crossoverpoint1 = crossoverpoint2;
            crossoverpoint2 = temp;
        }
        int x = crossoverpoint1;
        while (x < crossoverpoint2) {
            ((Solution)tempSolution1).variables[x] = tempSolution2.variables[x];
            ++x;
        }
    }

    private void applyHeuristic10(Solution tempSolution1, Solution tempSolution2) {
        int crossoverpoint1;
        int x = crossoverpoint1 = this.rng.nextInt(tempSolution1.variables.length);
        while (x < tempSolution1.variables.length) {
            ((Solution)tempSolution1).variables[x] = tempSolution2.variables[x];
            ++x;
        }
    }

    @Override
    public int getNumberOfHeuristics() {
        return 11;
    }

    @Override
    public double applyHeuristic(int heuristicID, int solutionSourceIndex, int solutionDestinationIndex) {
        long startTime = System.currentTimeMillis();
        Solution temporarysolution = this.deepCopyTheSolution(this.solutionMemory[solutionSourceIndex]);
        boolean isCrossover = false;
        int[] crossovers = this.getHeuristicsOfType(ProblemDomain.HeuristicType.CROSSOVER);
        if (crossovers != null) {
            int x = 0;
            while (x < crossovers.length) {
                if (crossovers[x] == heuristicID) {
                    isCrossover = true;
                    break;
                }
                ++x;
            }
        }
        if (isCrossover) {
            if (this.solutionMemory[solutionDestinationIndex] == null) {
                this.solutionMemory[solutionDestinationIndex] = new Solution();
            }
            this.solutionMemory[solutionDestinationIndex] = this.deepCopyTheSolution(this.solutionMemory[solutionSourceIndex]);
            this.solutionMemory[solutionDestinationIndex].incrementAge();
        } else if (temporarysolution.numberOfBrokenClauses() != 0) {
            if (heuristicID == 0) {
                this.applyHeuristic0(temporarysolution);
            } else if (heuristicID == 1) {
                this.applyHeuristic1(temporarysolution);
            } else if (heuristicID == 2) {
                this.applyHeuristic2(temporarysolution);
            } else if (heuristicID == 3) {
                this.applyHeuristic3(temporarysolution);
            } else if (heuristicID == 4) {
                this.applyHeuristic4(temporarysolution);
            } else if (heuristicID == 5) {
                this.applyHeuristic5(temporarysolution);
            } else if (heuristicID == 6) {
                this.applyHeuristic6(temporarysolution);
            } else if (heuristicID == 7) {
                this.applyHeuristic7(temporarysolution);
            } else if (heuristicID == 8) {
                this.applyHeuristic8(temporarysolution);
            } else {
                System.err.println("Heuristic " + heuristicID + "does not exist");
                System.exit(0);
            }
            int n = heuristicID;
            this.heuristicCallRecord[n] = this.heuristicCallRecord[n] + 1;
            int n2 = heuristicID;
            this.heuristicCallTimeRecord[n2] = this.heuristicCallTimeRecord[n2] + (int)(System.currentTimeMillis() - startTime);
        }
        double newobjectiveFunctionValue = this.evaluateObjectiveFunction(temporarysolution);
        if (newobjectiveFunctionValue < this.bestEverObjectiveFunction) {
            this.bestEverObjectiveFunction = newobjectiveFunctionValue;
            this.bestEverSolution = this.deepCopyTheSolution(temporarysolution);
        }
        if (this.solutionMemory[solutionDestinationIndex] == null) {
            this.solutionMemory[solutionDestinationIndex] = new Solution();
        }
        this.solutionMemory[solutionDestinationIndex] = this.deepCopyTheSolution(temporarysolution);
        this.solutionMemory[solutionDestinationIndex].incrementAge();
        return newobjectiveFunctionValue;
    }

    @Override
    public double applyHeuristic(int heuristicID, int solutionSourceIndex1, int solutionSourceIndex2, int solutionDestinationIndex) {
        long startTime = System.currentTimeMillis();
        Solution temporarysolution = this.deepCopyTheSolution(this.solutionMemory[solutionSourceIndex1]);
        Solution temporarysolution2 = this.deepCopyTheSolution(this.solutionMemory[solutionSourceIndex2]);
        boolean isCrossover = false;
        int[] crossovers = this.getHeuristicsOfType(ProblemDomain.HeuristicType.CROSSOVER);
        if (crossovers != null) {
            int x = 0;
            while (x < crossovers.length) {
                if (crossovers[x] == heuristicID) {
                    isCrossover = true;
                    break;
                }
                ++x;
            }
        }
        if (isCrossover) {
            if (heuristicID == 9) {
                this.applyHeuristic9(temporarysolution, temporarysolution2);
            } else if (heuristicID == 10) {
                this.applyHeuristic10(temporarysolution, temporarysolution2);
            } else {
                System.err.println("Heuristic " + heuristicID + " is not a crossover operator");
                System.exit(0);
            }
        } else if (temporarysolution.numberOfBrokenClauses() != 0) {
            if (heuristicID == 0) {
                this.applyHeuristic0(temporarysolution);
            } else if (heuristicID == 1) {
                this.applyHeuristic1(temporarysolution);
            } else if (heuristicID == 2) {
                this.applyHeuristic2(temporarysolution);
            } else if (heuristicID == 3) {
                this.applyHeuristic3(temporarysolution);
            } else if (heuristicID == 4) {
                this.applyHeuristic4(temporarysolution);
            } else if (heuristicID == 5) {
                this.applyHeuristic5(temporarysolution);
            } else if (heuristicID == 6) {
                this.applyHeuristic6(temporarysolution);
            } else if (heuristicID == 7) {
                this.applyHeuristic7(temporarysolution);
            } else if (heuristicID == 8) {
                this.applyHeuristic8(temporarysolution);
            } else {
                System.err.println("Heuristic " + heuristicID + "does not exist");
                System.exit(0);
            }
        }
        int n = heuristicID;
        this.heuristicCallRecord[n] = this.heuristicCallRecord[n] + 1;
        int n2 = heuristicID;
        this.heuristicCallTimeRecord[n2] = this.heuristicCallTimeRecord[n2] + (int)(System.currentTimeMillis() - startTime);
        double newobjectiveFunctionValue = this.evaluateObjectiveFunction(temporarysolution);
        if (newobjectiveFunctionValue < this.bestEverObjectiveFunction) {
            this.bestEverObjectiveFunction = newobjectiveFunctionValue;
            this.bestEverSolution = this.deepCopyTheSolution(temporarysolution);
        }
        if (this.solutionMemory[solutionDestinationIndex] == null) {
            this.solutionMemory[solutionDestinationIndex] = new Solution();
        }
        this.solutionMemory[solutionDestinationIndex] = this.deepCopyTheSolution(temporarysolution);
        this.solutionMemory[solutionDestinationIndex].incrementAge();
        return newobjectiveFunctionValue;
    }

    @Override
    public String bestSolutionToString() {
        String solutionstring = "";
        solutionstring = String.valueOf(solutionstring) + "Best solution Found\nObjective function value: " + this.getBestSolutionValue() + "\n";
        solutionstring = String.valueOf(solutionstring) + "Variables:";
        int y = 0;
        while (y < this.numberOfVariables) {
            if (y % 5 == 0) {
                solutionstring = String.valueOf(solutionstring) + "\n";
            }
            solutionstring = String.valueOf(solutionstring) + this.bestEverSolution.variables[y].number + ":" + this.bestEverSolution.variables[y].state + "  \t";
            ++y;
        }
        solutionstring = String.valueOf(solutionstring) + "\nClauses:";
        int x = 0;
        while (x < this.numberOfClauses) {
            if (x % 3 == 0) {
                solutionstring = String.valueOf(solutionstring) + "\n";
            }
            solutionstring = String.valueOf(solutionstring) + this.clauses[x].clauseToString(this.bestEverSolution.variables);
            ++x;
        }
        return solutionstring;
    }

    private Solution deepCopyTheSolution(Solution solutionToCopy) {
        Solution newsolution = new Solution();
        int x = 0;
        while (x < solutionToCopy.variables.length) {
            ((Solution)newsolution).variables[x] = solutionToCopy.variables[x].clone();
            ++x;
        }
        return newsolution;
    }

    @Override
    public void copySolution(int source, int destination) {
        Solution tempvariables;
        this.solutionMemory[destination] = tempvariables = this.deepCopyTheSolution(this.solutionMemory[source]);
    }

    @Override
    public double getBestSolutionValue() {
        return this.bestEverObjectiveFunction;
    }

    private double evaluateObjectiveFunction(Solution solution) {
        return solution.numberOfBrokenClauses();
    }

    @Override
    public double getFunctionValue(int solutionIndex) {
        return this.evaluateObjectiveFunction(this.solutionMemory[solutionIndex]);
    }

    @Override
    public int[] getHeuristicsOfType(ProblemDomain.HeuristicType hType) {
        switch (hType) {
            case LOCAL_SEARCH: {
                return this.localSearches;
            }
            case MUTATION: {
                return this.mutations;
            }
            case RUIN_RECREATE: {
                return this.ruin_recreate;
            }
            case CROSSOVER: {
                return this.crossovers;
            }
        }
        return null;
    }

    @Override
    public int[] getHeuristicsThatUseDepthOfSearch() {
        return this.localSearches;
    }

    @Override
    public int[] getHeuristicsThatUseIntensityOfMutation() {
        int[] newint = new int[this.mutations.length + this.ruin_recreate.length];
        int count = 0;
        int x = 0;
        while (x < this.mutations.length) {
            newint[count] = this.mutations[x];
            ++count;
            ++x;
        }
        x = 0;
        while (x < this.ruin_recreate.length) {
            newint[count] = this.ruin_recreate[x];
            ++count;
            ++x;
        }
        return newint;
    }

    @Override
    public int getNumberOfInstances() {
        return 12;
    }

    @Override
    public void initialiseSolution(int index) {
        this.solutionMemory[index] = new Solution();
        int y = 0;
        while (y < this.numberOfVariables) {
            this.solutionMemory[index].variables[y].state = this.rng.nextBoolean();
            ++y;
        }
        double i = this.getFunctionValue(index);
        if (i < this.bestEverObjectiveFunction) {
            this.bestEverObjectiveFunction = i;
        }
    }

    private void readInInstance(BufferedReader buffread) {
        try {
            String readline = "";
            boolean carryon = true;
            while (carryon) {
                readline = buffread.readLine();
                if (!readline.startsWith("p")) continue;
                carryon = false;
            }
            this.numberOfVariables = Integer.parseInt(readline.split(" ")[2]);
            if (readline.split(" ").length == 5) {
                this.numberOfClauses = Integer.parseInt(readline.split(" ")[4]);
            } else if (readline.split(" ").length == 4) {
                this.numberOfClauses = Integer.parseInt(readline.split(" ")[3]);
            } else {
                System.out.println("file format incorrect");
                System.exit(0);
            }
            this.clauses = new Clause[this.numberOfClauses];
            int clause = 0;
            while (clause < this.numberOfClauses) {
                readline = buffread.readLine();
                readline = readline.trim();
                String[] variables = readline.split(" ");
                Clause C = new Clause(variables.length - 1, clause);
                int v = 0;
                while (v < variables.length - 1) {
                    C.addVariable(Integer.parseInt(variables[v]));
                    ++v;
                }
                this.clauses[clause] = C;
                ++clause;
            }
        }
        catch (IOException b) {
            System.err.println(b.getMessage());
            System.exit(0);
        }
    }

    private void loadInstance(String filename) {
        try {
            FileReader read = new FileReader(filename);
            BufferedReader buffread = new BufferedReader(read);
            this.readInInstance(buffread);
        }
        catch (FileNotFoundException a) {
            try {
                InputStream fis = this.getClass().getClassLoader().getResourceAsStream(filename);
                BufferedReader buffread = new BufferedReader(new InputStreamReader(fis));
                this.readInInstance(buffread);
            }
            catch (NullPointerException n) {
                System.err.println("cannot find file " + filename);
                System.exit(-1);
            }
        }
    }

    @Override
    public void loadInstance(int instanceID) {
        this.solutionMemory = new Solution[defaultmemorysize];
        String folder = "invalid instance selected: " + instanceID;
        if (instanceID < 1) {
            folder = "sat07/crafted/Difficult/contest-02-03-04/contest02-Mat26.sat05-457.reshuffled-07.txt";
        } else if (instanceID < 2) {
            folder = "sat07/crafted/Hard/contest03/looksrandom/hidden-k3-s0-r5-n700-01-S2069048075.sat05-488.reshuffled-07.txt";
        } else if (instanceID < 3) {
            folder = "sat07/crafted/Hard/contest03/looksrandom/hidden-k3-s0-r5-n700-02-S350203913.sat05-486.reshuffled-07.txt";
        } else if (instanceID < 4) {
            folder = "sat09/crafted/parity-games/instance_n3_i3_pp.txt";
        } else if (instanceID < 5) {
            folder = "sat09/crafted/parity-games/instance_n3_i3_pp_ci_ce.txt";
        } else if (instanceID < 6) {
            folder = "sat09/crafted/parity-games/instance_n3_i4_pp_ci_ce.txt";
        } else if (instanceID < 7) {
            folder = "ms_random/highgirth/3SAT/HG-3SAT-V250-C1000-1.txt";
        } else if (instanceID < 8) {
            folder = "ms_random/highgirth/3SAT/HG-3SAT-V250-C1000-2.txt";
        } else if (instanceID < 9) {
            folder = "ms_random/highgirth/3SAT/HG-3SAT-V300-C1200-2.txt";
        } else if (instanceID < 10) {
            folder = "ms_crafted/MAXCUT/SPINGLASS/t7pm3-9999.spn.txt";
        } else if (instanceID < 11) {
            folder = "sat07/industrial/jarvisalo/eq.atree.braun.8.unsat.txt";
        } else if (instanceID < 12) {
            folder = "ms_random/highgirth/3SAT/HG-3SAT-V300-C1200-4.txt";
        } else {
            System.err.println("instance does not exist " + instanceID);
            System.exit(-1);
        }
        this.loadInstance("data/sat/" + folder);
    }

    @Override
    public void setMemorySize(int size) {
        Solution[] newSolutionMemory = new Solution[size];
        if (this.solutionMemory != null) {
            int x = 0;
            while (x < this.solutionMemory.length) {
                if (x < size) {
                    newSolutionMemory[x] = this.solutionMemory[x];
                }
                ++x;
            }
        }
        this.solutionMemory = newSolutionMemory;
    }

    private String solutionToString(Solution s) {
        String solutionstring = "";
        int y = 0;
        while (y < this.numberOfVariables) {
            solutionstring = String.valueOf(solutionstring) + s.variables[y].number + ":" + s.variables[y].state + " ";
            ++y;
        }
        return solutionstring;
    }

    @Override
    public String solutionToString(int solutionIndex) {
        return this.solutionToString(this.solutionMemory[solutionIndex]);
    }

    @Override
    public String toString() {
        return "SAT";
    }

    @Override
    public boolean compareSolutions(int solutionIndex1, int solutionIndex2) {
        Solution s1 = this.solutionMemory[solutionIndex1];
        Solution s2 = this.solutionMemory[solutionIndex2];
        int i = 0;
        while (i < this.numberOfVariables) {
            if (s1.variables[i].state != s2.variables[i].state) {
                return false;
            }
            ++i;
        }
        return true;
    }

    class Clause {
        private int number;
        private int[] variablenumbers;
        private boolean[] variablesigns;
        private int clausefill;

        public Clause(int numberofvariables, int num) {
            if (numberofvariables == 0) {
                System.out.println("zero variables in this clause");
                System.exit(0);
            }
            this.number = num;
            this.variablenumbers = new int[numberofvariables];
            this.variablesigns = new boolean[numberofvariables];
            this.clausefill = 0;
        }

        public void addVariable(int n) {
            if (n > 0) {
                this.variablenumbers[this.clausefill] = n - 1;
                this.variablesigns[this.clausefill] = true;
            } else {
                this.variablenumbers[this.clausefill] = n * -1 - 1;
                this.variablesigns[this.clausefill] = false;
            }
            ++this.clausefill;
        }

        public int numberOfVariables() {
            return this.variablenumbers.length;
        }

        public boolean getVariableSign(int index) {
            return this.variablesigns[index];
        }

        public int getVariableNumber(int index) {
            return this.variablenumbers[index];
        }

        public String clauseToString(Variable[] variables) {
            String s = "";
            s = String.valueOf(s) + "( ";
            int x = 0;
            while (x < this.variablenumbers.length) {
                if (!this.variablesigns[x]) {
                    s = String.valueOf(s) + "-";
                }
                s = String.valueOf(s) + this.variablenumbers[x] + ":" + (this.variablesigns[x] == variables[this.variablenumbers[x]].state) + " ";
                ++x;
            }
            s = String.valueOf(s) + ")";
            return s;
        }

        public void printclause(Variable[] variables) {
            System.out.print("( ");
            int x = 0;
            while (x < this.variablenumbers.length) {
                System.out.print(String.valueOf(this.variablesigns[x] == variables[this.variablenumbers[x]].state) + " ");
                ++x;
            }
            System.out.println(")");
        }

        public boolean evaluate(Variable[] variables) {
            int x = 0;
            while (x < this.variablenumbers.length) {
                if (this.variablesigns[x] == variables[this.variablenumbers[x]].state) {
                    return true;
                }
                ++x;
            }
            return false;
        }

        public boolean equals(Clause c) {
            return c.number == this.number;
        }
    }

    class Solution {
        private Variable[] variables;

        public Solution() {
            this.variables = new Variable[SAT.this.numberOfVariables];
            int x = 0;
            while (x < SAT.this.numberOfVariables) {
                this.variables[x] = new Variable(x);
                ++x;
            }
        }

        public int numberOfBrokenClauses() {
            int numberbroken = 0;
            int x = 0;
            while (x < SAT.this.numberOfClauses) {
                if (!SAT.this.clauses[x].evaluate(this.variables)) {
                    ++numberbroken;
                }
                ++x;
            }
            return numberbroken;
        }

        public void incrementAge() {
            int x = 0;
            while (x < SAT.this.numberOfVariables) {
                this.variables[x].incrementAge();
                ++x;
            }
        }

        public int testFlipForBrokenClauses(int variableToFlip) {
            this.variables[variableToFlip].testflip();
            int numberbroken = 0;
            int x = 0;
            while (x < SAT.this.numberOfClauses) {
                if (!SAT.this.clauses[x].evaluate(this.variables)) {
                    ++numberbroken;
                }
                ++x;
            }
            this.variables[variableToFlip].testflip();
            return numberbroken;
        }

        public int testFlipForNegGain(int variableToFlip) {
            ArrayList<Clause> satisfiedClauses = new ArrayList<Clause>(SAT.this.numberOfClauses);
            int x = 0;
            while (x < SAT.this.numberOfClauses) {
                if (SAT.this.clauses[x].evaluate(this.variables)) {
                    satisfiedClauses.add(SAT.this.clauses[x]);
                }
                ++x;
            }
            this.variables[variableToFlip].testflip();
            ArrayList<Clause> newbrokenClauses = new ArrayList<Clause>(50);
            int x2 = 0;
            while (x2 < SAT.this.numberOfClauses) {
                if (!SAT.this.clauses[x2].evaluate(this.variables)) {
                    newbrokenClauses.add(SAT.this.clauses[x2]);
                }
                ++x2;
            }
            int numberNotNowSatisfied = 0;
            int x3 = 0;
            while (x3 < satisfiedClauses.size()) {
                if (newbrokenClauses.contains(satisfiedClauses.get(x3))) {
                    ++numberNotNowSatisfied;
                }
                ++x3;
            }
            this.variables[variableToFlip].testflip();
            return numberNotNowSatisfied;
        }
    }

    class Variable {
        private boolean state;
        private int number;
        private int age;

        public Variable(int n) {
            this.number = n;
            this.state = false;
            this.age = 0;
        }

        public void permanentflip() {
            this.state = !this.state;
            this.age = 0;
        }

        public void testflip() {
            this.state = !this.state;
        }

        public void incrementAge() {
            ++this.age;
        }

        public Variable clone() {
            Variable v = new Variable(this.number);
            v.state = this.state;
            v.age = this.age;
            return v;
        }
    }
}

