/*
 * Decompiled with CFR 0.152.
 */
package VRP;

import VRP.Location;
import VRP.RouteItem;

public class Route {
    private int id;
    private RouteItem first = null;
    private RouteItem last = null;
    private int volume = 0;

    public Route(Location l, int iD, int t) {
        RouteItem depot2;
        RouteItem depot;
        this.setId(iD);
        this.first = depot = new RouteItem(l, null, null, 0.0);
        this.last = depot2 = new RouteItem(l, this.first, null, t);
        this.first.setNext(this.last);
    }

    public Route copyRoute() {
        Route newR = new Route(this.first.getCurrLocation().copyLocation(), this.id, 0);
        newR.getFirst().setWaitingTime(this.first.getWaitingTime());
        RouteItem currRI = this.first;
        RouteItem currNewRI = newR.getFirst();
        while ((currRI = currRI.getNext()).getNext() != null) {
            currNewRI.setNext(new RouteItem(currRI.getCurrLocation().copyLocation(), currNewRI, currNewRI.getNext(), currRI.getTimeArrived()));
            currNewRI = currNewRI.getNext();
            currNewRI.getNext().setPrev(currNewRI);
            currNewRI.setWaitingTime(currRI.getWaitingTime());
        }
        newR.setVolume(this.volume);
        return newR;
    }

    public boolean compareRoute(Route r) {
        boolean identical = true;
        RouteItem thisRI = this.first;
        RouteItem thatRI = r.getFirst();
        while (thisRI != null) {
            if (!thisRI.compareRouteItem(thatRI)) {
                return false;
            }
            thisRI = thisRI.getNext();
            thatRI = thatRI.getNext();
        }
        if (this.id != r.getId() || this.volume != r.getVolume()) {
            return false;
        }
        return identical;
    }

    public void addPenultimate(Location l, double t) {
        RouteItem ri = new RouteItem(l, this.last.getPrev(), this.last, t);
        this.last.getPrev().setNext(ri);
        this.last.setPrev(ri);
        this.volume += l.getDemand();
    }

    public void insertAfter(RouteItem ri, Location l, double t) {
        if (ri.getNext() == null) {
            System.out.println("Last location must be depot");
        } else {
            RouteItem r = new RouteItem(l, ri, ri.getNext(), t);
            ri.getNext().setPrev(r);
            ri.setNext(r);
            this.volume += l.getDemand();
        }
    }

    public void removeRouteItem(RouteItem ri) {
        if (ri.getPrev() == null || ri.getNext() == null) {
            System.out.println("Cannot delete depot");
        } else {
            ri.getPrev().setNext(ri.getNext());
            ri.getNext().setPrev(ri.getPrev());
            this.volume -= ri.getCurrLocation().getDemand();
        }
    }

    public void printRoute() {
        RouteItem currItem = this.first;
        while (currItem != null) {
            Location loc = currItem.getCurrLocation();
            System.out.println("Location " + loc.getId() + " at (" + loc.getXCoord() + "," + loc.getYCoord() + ") has been visited at " + currItem.getTimeArrived());
            currItem = currItem.getNext();
        }
        System.out.println(this.volume);
    }

    public int sizeOfRoute() {
        int size = 1;
        RouteItem curr = this.first;
        while ((curr = curr.getNext()) != null) {
            ++size;
        }
        return size;
    }

    public int calcVolume() {
        RouteItem ri = this.first;
        int volume = 0;
        while (ri != null) {
            volume += ri.getCurrLocation().getDemand();
            ri = ri.getNext();
        }
        return volume;
    }

    public RouteItem getFirst() {
        return this.first;
    }

    public void setFirst(RouteItem first) {
        this.first = first;
    }

    public RouteItem getLast() {
        return this.last;
    }

    public void setLast(RouteItem last) {
        this.last = last;
    }

    public int getVolume() {
        return this.volume;
    }

    public void setVolume(int volume) {
        this.volume = volume;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }
}

