/*
 * Decompiled with CFR 0.152.
 */
package travelingSalesmanProblem;

import java.util.Arrays;
import java.util.Random;
import travelingSalesmanProblem.TspDataStructure;
import travelingSalesmanProblem.TspInstance;

public class TspBasicAlgorithms {
    private TspInstance instance;
    TspDataStructure ds;

    public TspBasicAlgorithms(TspInstance instance) {
        this.instance = instance;
    }

    public int[] generateRandomPermutation(int n, Random rng) {
        int[] randomPermutation = new int[n];
        int i = 0;
        while (i < n) {
            randomPermutation[i] = i;
            ++i;
        }
        this.shufflePermutation(randomPermutation, rng);
        return randomPermutation;
    }

    public void shufflePermutation(int[] array, Random rng) {
        int n = array.length;
        while (n > 1) {
            int k = rng.nextInt(n);
            int temp = array[--n];
            array[n] = array[k];
            array[k] = temp;
        }
    }

    public double computeCost(int[] permutation) {
        double sum = 0.0;
        int i = 1;
        while (i < permutation.length) {
            sum += this.instance.getDistance(permutation[i - 1], permutation[i]);
            ++i;
        }
        return sum += this.instance.getDistance(permutation[0], permutation[permutation.length - 1]);
    }

    public double incrementalInsertionCost(int[] tour, double initialCost, int index1, int index2) {
        return initialCost + this.reinsertionCost(tour, index1, index2);
    }

    public double incrementalCostFlip(int[] tour, double initialCost, int index1, int index2) {
        return initialCost + this.flipCost(tour, index1, index2);
    }

    public double incrementalCostSwap(int[] tour, double initialCost, int index1, int index2) {
        return initialCost + this.swapCost(tour, index1, index2);
    }

    public double reinsertionCost(int[] tour, int index1, int index2) {
        int city1 = tour[index1];
        int city2 = tour[index2];
        int prev1 = index1 == 0 ? tour[this.instance.numbCities - 1] : tour[index1 - 1];
        int next1 = index1 == this.instance.numbCities - 1 ? tour[0] : tour[index1 + 1];
        int prev2 = index2 == 0 ? tour[this.instance.numbCities - 1] : tour[index2 - 1];
        double currentCost = this.instance.getDistance(city1, prev1) + this.instance.getDistance(city1, next1) + this.instance.getDistance(city2, prev2);
        double newCost = this.instance.getDistance(prev2, city1) + this.instance.getDistance(city1, city2) + this.instance.getDistance(prev1, next1);
        return newCost - currentCost;
    }

    public double insertionCost(int[] tour, int city1, int index) {
        if (index == 0 || index == tour.length) {
            return this.instance.getDistance(city1, tour[0]) + this.instance.getDistance(city1, tour[tour.length - 1]);
        }
        return this.instance.getDistance(city1, tour[index - 1]) + this.instance.getDistance(city1, tour[index]);
    }

    public double flipCost(int[] tour, int index1, int index2) {
        int city1 = tour[index1];
        int city2 = tour[index2];
        int prev1 = index1 == 0 ? this.instance.numbCities - 1 : tour[index1 - 1];
        int next2 = index2 == this.instance.numbCities - 1 ? 0 : tour[index2 + 1];
        if (prev1 == city2 || next2 == city1) {
            return 0.0;
        }
        double currentCost = this.instance.getDistance(city1, prev1) + this.instance.getDistance(city2, next2);
        double newCost = this.instance.getDistance(city1, next2) + this.instance.getDistance(city2, prev1);
        return newCost - currentCost;
    }

    public double flipCost(TspDataStructure ds, int city1, int city2) {
        int prev1 = ds.prev(city1);
        int next2 = ds.next(city2);
        if (prev1 == city2 || next2 == city1) {
            return 0.0;
        }
        double currentCost = this.instance.getDistance(city1, prev1) + this.instance.getDistance(city2, next2);
        double newCost = this.instance.getDistance(city1, next2) + this.instance.getDistance(city2, prev1);
        return newCost - currentCost;
    }

    public double swapCost(int[] tour, int index1, int index2) {
        int city1 = tour[index1];
        int city2 = tour[index2];
        int prev1 = index1 == 0 ? this.instance.numbCities - 1 : tour[index1 - 1];
        int prev2 = index2 == 0 ? this.instance.numbCities - 1 : tour[index2 - 1];
        int next1 = index1 == this.instance.numbCities - 1 ? 0 : tour[index1 + 1];
        int next2 = index2 == this.instance.numbCities - 1 ? 0 : tour[index2 + 1];
        double currentCost = this.instance.getDistance(prev1, city1) + this.instance.getDistance(city1, next1) + this.instance.getDistance(prev2, city2) + this.instance.getDistance(city2, next2);
        double newCost = this.instance.getDistance(prev2, city1) + this.instance.getDistance(city1, next2) + this.instance.getDistance(prev1, city2) + this.instance.getDistance(city2, next1);
        return newCost - currentCost;
    }

    public static int[] flip(int[] permutation, int a, int b) {
        if (a > b) {
            int temp = a;
            a = b + 1;
            b = temp - 1;
        }
        if (a == b) {
            return (int[])permutation.clone();
        }
        int[] newPermutation = new int[permutation.length];
        System.arraycopy(permutation, 0, newPermutation, 0, a);
        int count = a;
        int i = b;
        while (i >= a) {
            newPermutation[count] = permutation[i];
            --i;
            ++count;
        }
        System.arraycopy(permutation, b + 1, newPermutation, b + 1, permutation.length - b - 1);
        return newPermutation;
    }

    public int[] greedyInsertion(Double cost) {
        int[] nArray = new int[2];
        nArray[1] = 1;
        int[] tour = nArray;
        int[] toInsert = new int[this.instance.numbCities - 2];
        int i = 2;
        while (i < this.instance.numbCities) {
            toInsert[i - 2] = i;
            ++i;
        }
        cost = cost + 2.0 * this.instance.getDistance(0, 1);
        return this.greedyInsertion(tour, toInsert, cost);
    }

    public int[] greedyInsertion(int[] tour, int[] toInsert, Double cost) {
        double min = Double.MAX_VALUE;
        int index = 0;
        int i = 0;
        while (i < toInsert.length) {
            min = this.insertionCost(tour, toInsert[i], 0);
            index = 0;
            int j = 1;
            while (j <= tour.length) {
                double temp = this.insertionCost(tour, toInsert[i], j);
                if (temp < min) {
                    min = temp;
                    index = j;
                }
                ++j;
            }
            cost = cost + min;
            tour = this.insert(tour, toInsert[i], index);
            ++i;
        }
        return tour;
    }

    public int[] greedyHeuristic(int startCity) {
        int numbCities = this.instance.numbCities;
        int[] tour = new int[numbCities];
        boolean[] included = new boolean[numbCities];
        Arrays.fill(included, false);
        tour[0] = startCity;
        included[startCity] = true;
        int city = 0;
        int i = 1;
        while (i < numbCities) {
            double min = Double.MAX_VALUE;
            int j = 0;
            while (j < numbCities) {
                double temp;
                if (!included[j] && (temp = this.instance.getDistance(tour[i - 1], j)) < min) {
                    min = temp;
                    city = j;
                }
                ++j;
            }
            tour[i] = city;
            included[city] = true;
            ++i;
        }
        return tour;
    }

    public int[] twoOptBestImprovement(int[] tour, TspInstance instance, int maxiterations) {
        TspDataStructure ds = TspDataStructure.create(tour);
        int numbCities = instance.numbCities;
        double flipCost = 0.0;
        boolean improvement = true;
        int[][] nearest = instance.nearestCities;
        int N = nearest[0].length;
        int completediterations = 0;
        while (improvement && completediterations++ < maxiterations) {
            improvement = false;
            int i = 0;
            while (i < numbCities) {
                int bestMoveSoFar = -1;
                double bestCostSoFar = 0.0;
                int j = 0;
                while (j < N) {
                    flipCost = this.flipCost(ds, i, nearest[i][j]);
                    if (flipCost < bestCostSoFar && flipCost < 0.0) {
                        bestMoveSoFar = nearest[i][j];
                        bestCostSoFar = flipCost;
                    }
                    ++j;
                }
                if (bestMoveSoFar != -1) {
                    ds.flip(i, bestMoveSoFar);
                    improvement = true;
                }
                ++i;
            }
        }
        return ds.returnTour(tour[0]);
    }

    public int[] twoOptFirstImprovement(int[] tour, TspInstance instance, int maxiterations) {
        TspDataStructure ds = TspDataStructure.create(tour);
        int numbCities = instance.numbCities;
        double flipCost = 0.0;
        boolean improvement = true;
        int[][] nearest = instance.nearestCities;
        int N = nearest[0].length;
        int completediterations = 0;
        while (improvement && completediterations++ < maxiterations) {
            improvement = false;
            int i = 0;
            while (i < numbCities) {
                int j = 0;
                while (j < N) {
                    flipCost = this.flipCost(ds, i, nearest[i][j]);
                    if (flipCost < 0.0) {
                        ds.flip(i, nearest[i][j]);
                        improvement = true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return ds.returnTour(tour[0]);
    }

    public int[] threeOpt(int[] tour, TspInstance instance, int maxiterations) {
        int numbCities = instance.numbCities;
        TspDataStructure ds = TspDataStructure.create(tour);
        int[][] nearest = instance.nearestCities;
        int N = nearest[0].length;
        boolean localImprovment = false;
        boolean globalImprovement = true;
        int completediterations = 0;
        while (globalImprovement && completediterations++ < maxiterations) {
            globalImprovement = false;
            int i = 0;
            while (i < numbCities) {
                double cost = 0.0;
                localImprovment = false;
                int iPrev = ds.prev(i);
                int j2 = 0;
                while (j2 < N) {
                    int j = nearest[i][j2];
                    if (j != iPrev && j != ds.prev(iPrev)) {
                        cost = this.flipCost(ds, i, j);
                        ds.flip(i, j);
                        int jNext = ds.next(j);
                        int k = 0;
                        while (k < N) {
                            int nextCity = nearest[jNext][k];
                            if (!ds.sequence(iPrev, nextCity, jNext) && nextCity != iPrev && cost + this.flipCost(ds, jNext, nextCity) < 0.0) {
                                ds.flip(jNext, nextCity);
                                localImprovment = true;
                                globalImprovement = true;
                                break;
                            }
                            ++k;
                        }
                        if (localImprovment) break;
                        k = 0;
                        while (k < N) {
                            int prevCity = nearest[iPrev][k];
                            if (!ds.sequence(iPrev, prevCity, jNext) && prevCity != jNext && cost + this.flipCost(ds, iPrev, prevCity) < 0.0) {
                                ds.flip(iPrev, prevCity);
                                localImprovment = true;
                                globalImprovement = true;
                                break;
                            }
                            ++k;
                        }
                        if (localImprovment) break;
                        ds.flip(j, i);
                    }
                    ++j2;
                }
                ++i;
            }
        }
        return ds.returnTour(tour[0]);
    }

    public int[] inversePermutation(int[] permutation) {
        int[] inv = new int[permutation.length];
        int i = 0;
        while (i < permutation.length) {
            inv[permutation[i]] = i;
            ++i;
        }
        return inv;
    }

    public int[] insert(int[] initialTour, int x, int index) {
        int[] newTour = new int[initialTour.length + 1];
        System.arraycopy(initialTour, 0, newTour, 0, index);
        newTour[index] = x;
        if (index < initialTour.length) {
            System.arraycopy(initialTour, index, newTour, index + 1, initialTour.length - index);
        }
        return newTour;
    }

    public boolean verifyPermutation(int[] p, int n) {
        if (p.length != n) {
            return false;
        }
        boolean[] included = new boolean[n];
        Arrays.fill(included, false);
        int i = 0;
        while (i < n) {
            if (p[i] < 0 || p[i] >= n) {
                return false;
            }
            if (included[p[i]]) {
                return false;
            }
            included[p[i]] = true;
            ++i;
        }
        i = 0;
        while (i < n) {
            if (!included[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String tourToString(int[] tour) {
        StringBuilder stb = new StringBuilder();
        int i = 0;
        while (i < tour.length) {
            stb.append(String.valueOf(tour[i]) + " ");
            ++i;
        }
        return stb.toString();
    }
}

