/*
 * Decompiled with CFR 0.152.
 */
package travelingSalesmanProblem;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.StringTokenizer;

public class TspInstance {
    public int numbCities;
    double[][] coordinates;
    String name;
    int N = 8;
    int[][] nearestCities;
    double[][] D;
    String[] instanceNames = new String[]{"pr299", "pr439", "rat575", "u724", "rat783", "pcb1173", "d1291", "u2152", "usa13509", "d18512"};

    public static void saveNearest(int[][] nearest, String fileName) {
        StringBuilder strb = new StringBuilder();
        int N = nearest.length;
        int n = nearest[0].length;
        int i = 0;
        while (i < N) {
            int j = 0;
            while (j < n - 1) {
                strb.append(String.valueOf(nearest[i][j]) + " ");
                ++j;
            }
            if (i < N - 1) {
                strb.append(String.valueOf(nearest[i][n - 1]) + "\n");
            } else {
                strb.append(nearest[i][n - 1]);
            }
            ++i;
        }
        TspInstance.save(fileName, strb.toString());
    }

    public static void save(String fileName, String data) {
        try {
            FileWriter writer = new FileWriter(fileName);
            writer.write(data);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public void calculateNearest(int N) {
        this.nearestCities = new int[this.numbCities][N];
        this.D = new double[this.numbCities][N];
        int i = 0;
        while (i < this.numbCities) {
            Arrays.fill(this.D[i], 2.147483647E9);
            int j = 0;
            while (j < this.numbCities) {
                int max;
                double cost;
                if (i != j && (cost = this.getDistance(i, j)) < this.D[i][max = this.getMax(this.D[i])]) {
                    this.D[i][max] = cost;
                    this.nearestCities[i][max] = j;
                }
                ++j;
            }
            ++i;
        }
    }

    public int getMax(double[] array) {
        double max = -1.7976931348623157E308;
        int maxIndex = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] > max) {
                max = array[i];
                maxIndex = i;
            }
            ++i;
        }
        return maxIndex;
    }

    public boolean isNearest(int cityIndex, int candidate) {
        int i = 0;
        while (i < this.nearestCities.length) {
            if (this.nearestCities[cityIndex][i] == candidate) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public double getDistanceToNearest(int cityIndex, int nthNearest) {
        return this.D[cityIndex][nthNearest];
    }

    public TspInstance(int number) {
        this.name = this.instanceNames[number];
        String fileName = "data\\tsp\\" + this.instanceNames[number] + ".tsp";
        try {
            FileReader fr = new FileReader(fileName);
            BufferedReader bfr = new BufferedReader(fr);
            this.loadData(bfr);
        }
        catch (Exception ex1) {
            try {
                fileName = "data/tsp/" + this.instanceNames[number] + ".tsp";
                BufferedReader bfr = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(fileName)));
                this.loadData(bfr);
            }
            catch (Exception ex2) {
                ex1.printStackTrace();
                ex2.printStackTrace();
                System.err.print("problem when opening file " + fileName);
            }
        }
        this.loadNearestCities();
    }

    public void loadNearestCities() {
        String fileName = "data\\tsp\\" + this.name + "NearestCities.txt";
        try {
            FileReader fr = new FileReader(fileName);
            BufferedReader bfr = new BufferedReader(fr);
            this.readTable(bfr);
        }
        catch (Exception ex1) {
            try {
                fileName = "data/tsp/" + this.name + "NearestCities.txt";
                BufferedReader bfr = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(fileName)));
                this.readTable(bfr);
            }
            catch (Exception ex2) {
                ex1.printStackTrace();
                ex2.printStackTrace();
                System.err.print("problem when opening file " + fileName);
            }
        }
    }

    private void readTable(BufferedReader bfr) throws Exception {
        this.nearestCities = new int[this.numbCities][this.N];
        int i = 0;
        while (i < this.numbCities) {
            String line = bfr.readLine();
            StringTokenizer tok = new StringTokenizer(line);
            int j = 0;
            while (j < this.N) {
                this.nearestCities[i][j] = Integer.parseInt(tok.nextToken());
                ++j;
            }
            ++i;
        }
    }

    private void loadData(BufferedReader bfr) throws Exception {
        int i = 0;
        while (i < 3) {
            bfr.readLine();
            ++i;
        }
        String line = bfr.readLine();
        StringTokenizer tok = new StringTokenizer(line);
        tok.nextToken();
        tok.nextToken();
        this.numbCities = Integer.parseInt(tok.nextToken());
        line = bfr.readLine();
        while (!line.equals("NODE_COORD_SECTION")) {
            line = bfr.readLine();
        }
        this.coordinates = new double[this.numbCities][2];
        int i2 = 0;
        while (i2 < this.numbCities) {
            tok = new StringTokenizer(bfr.readLine());
            tok.nextToken();
            this.coordinates[i2][0] = Double.parseDouble(tok.nextToken());
            this.coordinates[i2][1] = Double.parseDouble(tok.nextToken());
            ++i2;
        }
    }

    public String toString() {
        StringBuilder build = new StringBuilder();
        int i = 0;
        while (i < this.numbCities) {
            build.append(String.valueOf(this.coordinates[i][0]) + " " + this.coordinates[i][1] + "\n");
            ++i;
        }
        return build.toString();
    }

    int getNumbCities() {
        return this.numbCities;
    }

    double[][] getCoordinates() {
        return this.coordinates;
    }

    public double getDistance(int city1, int city2) {
        double x1 = this.coordinates[city1][0];
        double x2 = this.coordinates[city2][0];
        double y1 = this.coordinates[city1][1];
        double y2 = this.coordinates[city2][1];
        return StrictMath.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }
}

