/*
 * Decompiled with CFR 0.152.
 */
package travelingSalesmanProblem;

import travelingSalesmanProblem.TspDataStructure;

class arrayRepresentation
extends TspDataStructure {
    private int[] tour;
    private int[] inverse;
    public boolean reversed = false;
    private int numbCities;

    public arrayRepresentation(int[] tour) {
        this.tour = tour;
        this.numbCities = tour.length;
        this.inverse = new int[this.numbCities];
        int i = 0;
        while (i < this.numbCities) {
            this.inverse[tour[i]] = i;
            ++i;
        }
    }

    @Override
    public int next(int v) {
        if (!this.reversed) {
            if (this.inverse[v] + 1 == this.numbCities) {
                return this.tour[0];
            }
            return this.tour[this.inverse[v] + 1];
        }
        if (this.inverse[v] == 0) {
            return this.tour[this.numbCities - 1];
        }
        return this.tour[this.inverse[v] - 1];
    }

    @Override
    public int prev(int v) {
        if (!this.reversed) {
            if (this.inverse[v] == 0) {
                return this.tour[this.numbCities - 1];
            }
            return this.tour[this.inverse[v] - 1];
        }
        if (this.inverse[v] + 1 == this.numbCities) {
            return this.tour[0];
        }
        return this.tour[this.inverse[v] + 1];
    }

    @Override
    public boolean sequence(int a, int b, int c) {
        int ia = this.inverse[a];
        int ib = this.inverse[b];
        int ic = this.inverse[c];
        return !this.reversed ? (ia < ic ? ib < ic && ib > ia : ib > ia || ib < ic) : (ic < ia ? ib < ia && ib > ic : ib < ia || ib > ic);
    }

    @Override
    public void flip(int b, int d) {
        if (b == d) {
            return;
        }
        if (this.next(d) == b || this.prev(b) == this.next(d)) {
            this.reversed = !this.reversed;
            return;
        }
        if (!this.reversed) {
            if (this.inverse[b] < this.inverse[d]) {
                this.flip1(this.inverse[b], this.inverse[d]);
            } else {
                this.flip2(this.inverse[b], this.inverse[d]);
            }
        } else if (this.inverse[b] < this.inverse[d]) {
            this.flip3(this.inverse[b], this.inverse[d]);
        } else {
            this.flip4(this.inverse[b], this.inverse[d]);
        }
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int startCity) {
        int[] tour = this.returnTour(startCity);
        StringBuilder stb = new StringBuilder();
        int i = 0;
        while (i < this.numbCities) {
            stb.append(String.valueOf(tour[i]) + " ");
            ++i;
        }
        return stb.toString();
    }

    @Override
    public int[] returnTour(int startCity) {
        int[] tour = new int[this.numbCities];
        this.returnTour(startCity, tour);
        return tour;
    }

    @Override
    public void returnTour(int startCity, int[] tour) {
        tour[0] = startCity;
        int aux = this.next(startCity);
        int i = 1;
        while (i < this.numbCities) {
            tour[i] = aux;
            aux = this.next(aux);
            ++i;
        }
    }

    private void flip1(int ib, int id) {
        if (id - ib + 1 < this.numbCities / 2) {
            this.flipIn(ib, id);
        } else {
            boolean bl = this.reversed = !this.reversed;
            if (ib == 0) {
                this.flipIn(id + 1, this.numbCities - 1);
            } else if (id == this.numbCities - 1) {
                this.flipIn(0, ib - 1);
            } else {
                this.flipOut(ib - 1, id + 1);
            }
        }
    }

    private void flip2(int ib, int id) {
        int ia = ib - 1;
        int ic = id + 1;
        if (ia - ic + 1 < this.numbCities / 2) {
            this.reversed = !this.reversed;
            this.flipIn(ic, ia);
        } else {
            this.flipOut(id, ib);
        }
    }

    private void flip3(int ib, int id) {
        int ic = id - 1;
        int ia = ib + 1;
        if (ic - ia + 1 < this.numbCities / 2) {
            this.reversed = !this.reversed;
            this.flipIn(ia, ic);
        } else {
            this.flipOut(ib, id);
        }
    }

    private void flip4(int ib, int id) {
        if (ib - id + 1 < this.numbCities / 2) {
            this.flipIn(id, ib);
        } else {
            boolean bl = this.reversed = !this.reversed;
            if (id == 0) {
                this.flipIn(ib + 1, this.numbCities - 1);
            } else if (ib == this.numbCities - 1) {
                this.flipIn(0, id - 1);
            } else {
                this.flipOut(id - 1, ib + 1);
            }
        }
    }

    private void flipIn(int ib, int id) {
        int q = (id - ib + 1) / 2;
        int count = 0;
        while (count < q) {
            int temp = this.tour[ib + count];
            this.inverse[this.tour[id - count]] = ib + count;
            this.tour[ib + count] = this.tour[id - count];
            this.inverse[temp] = id - count;
            this.tour[id - count] = temp;
            ++count;
        }
    }

    private void flipOut(int ib, int id) {
        int q = ib + 1 < this.numbCities - id ? ib + 1 : this.numbCities - id;
        int count = 0;
        while (count < q) {
            int temp = this.tour[id + count];
            this.inverse[this.tour[ib - count]] = id + count;
            this.tour[id + count] = this.tour[ib - count];
            this.inverse[temp] = ib - count;
            this.tour[ib - count] = temp;
            ++count;
        }
        if (this.numbCities - 1 - id - q > 0) {
            this.flipIn(id + q, this.numbCities - 1);
        } else if (ib - q > 0) {
            this.flipIn(0, ib - q);
        }
    }
}

